/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLOriginalLibrary;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLOverride
extends StyleElement {
    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
            if (nodeInfo.getNodeKind() == 3) {
                this.compileError("Character content is not allowed as a child of xsl:override", "XTSE0010");
                return;
            }
            if (!(nodeInfo instanceof XSLFunction || nodeInfo instanceof XSLTemplate || nodeInfo instanceof XSLGlobalVariable || nodeInfo instanceof XSLAttributeSet)) {
                ((StyleElement)nodeInfo).compileError("Element " + nodeInfo.getDisplayName() + " is not allowed as a child of xsl:override", "XTSE0010");
            }
        });
    }

    @Override
    public void postValidate() {
        XSLUsePackage xSLUsePackage = (XSLUsePackage)this.getParent();
        assert (xSLUsePackage != null);
        if (((StyleElement)xSLUsePackage).getUsedPackage() != null) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((nodeInfo = axisIterator.next()) != null) {
                Object object;
                if (!(nodeInfo instanceof XSLFunction) && !(nodeInfo instanceof XSLTemplate) && !(nodeInfo instanceof XSLGlobalVariable) && !(nodeInfo instanceof XSLAttributeSet)) continue;
                StructuredQName[] structuredQNameArray = (StructuredQName[])nodeInfo;
                SymbolicName symbolicName = structuredQNameArray.getSymbolicName();
                if (symbolicName == null) {
                    if (nodeInfo instanceof XSLTemplate) {
                        StructuredQName[] structuredQNameArray2;
                        object = (XSLTemplate)nodeInfo;
                        if (((XSLTemplate)object).getMatch() == null) {
                            ((StyleElement)object).compileError("An overriding template with no name must have a match pattern");
                        }
                        structuredQNameArray = structuredQNameArray2 = ((XSLTemplate)object).getModeNames();
                        int n2 = structuredQNameArray2.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            StructuredQName structuredQName = structuredQNameArray[i2];
                            if (structuredQName.equals(Mode.OMNI_MODE)) {
                                ((StyleElement)nodeInfo).compileError("An overriding template rule must not specify mode=\"#all\"", "XTSE3440");
                                continue;
                            }
                            if (!structuredQName.equals(Mode.UNNAMED_MODE_NAME) || !(structuredQName = ((StyleElement)object).getDefaultMode()).equals(Mode.UNNAMED_MODE_NAME)) continue;
                            ((StyleElement)nodeInfo).compileError("An overriding template rule must not belong to the unnamed mode", "XTSE3440");
                        }
                        continue;
                    }
                    ((StyleElement)nodeInfo).compileError("An overriding component (other than a template rule) must have a name", "XTSE3440");
                    return;
                }
                object = ((StyleElement)xSLUsePackage).getUsedPackage().getComponent(symbolicName);
                if (object == null) {
                    ((StyleElement)nodeInfo).compileError("There is no " + StandardNames.getLocalName(symbolicName.getComponentKind()) + " named " + symbolicName.getShortName() + " in the used package", "XTSE3058");
                    return;
                }
                Visibility visibility = ((Component)object).getVisibility();
                if (visibility == null) {
                    visibility = Visibility.PRIVATE;
                }
                if (visibility == Visibility.FINAL || visibility == Visibility.PRIVATE) {
                    ((StyleElement)nodeInfo).compileError("The " + StandardNames.getLocalName(symbolicName.getComponentKind()) + " named " + symbolicName.getShortName() + " in the used package cannot be overridden because its visibility is " + visibility.show(), "XTSE3060");
                    return;
                }
                structuredQNameArray.checkCompatibility((Component)object);
            }
        }
    }

    public void addXSLOverrideFunctionLibrary(FunctionLibraryList functionLibraryList) {
        functionLibraryList.addFunctionLibrary(XSLOriginalLibrary.getInstance());
    }
}

