/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLPackage
extends XSLModuleRoot {
    private String a = null;
    private PackageVersion b = null;
    private boolean c = true;
    private boolean d = false;

    @Override
    public void initialise(NodeName nodeName, SchemaType schemaType, AttributeCollectionImpl attributeCollectionImpl, NodeInfo nodeInfo, int n2) {
        super.initialise(nodeName, schemaType, attributeCollectionImpl, nodeInfo, n2);
        this.c = this.getLocalPart().equals("package");
    }

    public String getName() {
        if (this.a == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                this.a = "default";
            }
        }
        return this.a;
    }

    public int getVersion() {
        if (this.version == -1) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                this.version = 30;
            }
        }
        return this.version;
    }

    public VersionedPackageName getNameAndVersion() {
        return new VersionedPackageName(this.getName(), this.getPackageVersion());
    }

    public PackageVersion getPackageVersion() {
        if (this.b == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                this.b = PackageVersion.ONE;
            }
        }
        return this.b;
    }

    @Override
    protected void prepareAttributes() {
        if (this.d) {
            return;
        }
        this.d = true;
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string3 = attributeCollection.getQName(i2);
            if (string3.equals("name") && this.getLocalPart().equals("package")) {
                this.a = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string3.equals("id")) continue;
            if (string3.equals("version")) {
                if (this.version != -1) continue;
                this.processVersionAttribute("");
                continue;
            }
            if (string3.equals("package-version") && this.getLocalPart().equals("package")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string3.equals("declared-modes") && this.getLocalPart().equals("package")) {
                this.c = this.processBooleanAttribute("declared-modes", attributeCollection.getValue(i2));
                continue;
            }
            if (string3.equals("input-type-annotations")) {
                string = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string2 == null) {
            this.b = PackageVersion.ONE;
        } else {
            try {
                this.b = new PackageVersion(string2);
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "package-version");
            }
        }
        if (this.version == -1) {
            this.version = 30;
            this.reportAbsence("version");
        }
        if (string != null) {
            switch (string) {
                case "strip": {
                    return;
                }
                case "preserve": {
                    return;
                }
                case "unspecified": {
                    return;
                }
            }
            this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
        }
    }

    @Override
    public boolean isDeclaredModes() {
        if (this.a == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                this.a = null;
            }
        }
        return this.c;
    }

    @Override
    public void validate(ComponentDeclaration object) {
        String string;
        NodeImpl nodeImpl;
        object = this.iterateAxis((byte)3);
        while ((nodeImpl = (NodeImpl)object.next()) != null) {
            int n2 = nodeImpl.getFingerprint();
            if (nodeImpl.getNodeKind() == 3 || nodeImpl instanceof StyleElement && ((StyleElement)nodeImpl).isDeclaration() || nodeImpl instanceof DataElement || this.getLocalPart().equals("package") && (n2 == 204 || n2 == 152) || !"http://www.w3.org/1999/XSL/Transform".equals(nodeImpl.getURI()) && !"".equals(nodeImpl.getURI()) || nodeImpl instanceof AbsentExtensionElement && ((StyleElement)nodeImpl).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(nodeImpl.getURI())) {
                if (nodeImpl instanceof AbsentExtensionElement) continue;
                ((StyleElement)nodeImpl).compileError("Element " + nodeImpl.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            ((StyleElement)nodeImpl).compileError("Element " + nodeImpl.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
        if (this.c && (string = this.getAttributeValue("default-mode")) != null && this.getPrincipalStylesheetModule().getRuleManager().obtainMode(this.getDefaultMode(), false) == null) {
            this.compileError("The default mode " + string + " has not been declared in an xsl:mode declaration", "XTSE3085");
        }
    }
}

