/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLPerformSort
extends StyleElement {
    private Expression a = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLSort;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("select")) {
                string = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        this.checkSortComesFirst(true);
        if (this.a != null) {
            NodeInfo nodeInfo;
            object = this.iterateAxis((byte)3);
            while ((nodeInfo = object.next()) != null) {
                if (nodeInfo instanceof XSLSort || nodeInfo instanceof XSLFallback) continue;
                if (nodeInfo.getNodeKind() == 3 && !Whitespace.isWhite(nodeInfo.getStringValueCS())) {
                    this.compileError("Within xsl:perform-sort, significant text must not appear if there is a select attribute", "XTSE1040");
                    continue;
                }
                ((StyleElement)nodeInfo).compileError("Within xsl:perform-sort, child instructions are not allowed if there is a select attribute", "XTSE1040");
            }
        }
        this.a = this.typeCheck("select", this.a);
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        SortKeyDefinitionList sortKeyDefinitionList = this.makeSortKeys((Compilation)object, componentDeclaration);
        if (this.a != null) {
            return new SortExpression(this.a, sortKeyDefinitionList);
        }
        if ((object = this.compileSequenceConstructor((Compilation)object, componentDeclaration, true)) == null) {
            object = Literal.makeEmptySequence();
        }
        try {
            return new SortExpression(((Expression)object).simplify(), sortKeyDefinitionList);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

