/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SelectedElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;

public class XSLPreserveSpace
extends StyleElement {
    private String a;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("elements")) {
                this.a = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (this.a == null) {
            this.reportAbsence("elements");
            this.a = "*";
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
    }

    @Override
    public void index(ComponentDeclaration object, PrincipalStylesheetModule principalStylesheetModule) {
        if (this.getFingerprint() == 198 && this.getFingerprint() == 198 && (object = ((NodeImpl)this).getAttributeValue("", "elements")) != null && !((String)object).trim().isEmpty()) {
            principalStylesheetModule.getStylesheetPackage().setStripsWhitespace(true);
        }
    }

    @Override
    public void compileDeclaration(Compilation object, ComponentDeclaration componentDeclaration) {
        object = this.getFingerprint() == 191 ? Stripper.PRESERVE : Stripper.STRIP;
        Object object2 = this.getCompilation().getPrincipalStylesheetModule();
        Object object3 = ((PrincipalStylesheetModule)object2).getStylesheetPackage().getStripperRules();
        if (!(object3 instanceof SelectedElementsSpaceStrippingRule)) {
            object3 = new SelectedElementsSpaceStrippingRule(true);
            ((PrincipalStylesheetModule)object2).getStylesheetPackage().setStripperRules((SpaceStrippingRule)object3);
        }
        object2 = (SelectedElementsSpaceStrippingRule)object3;
        object3 = new StringTokenizer(this.a, " \t\n\r", false);
        try {
            while (((StringTokenizer)object3).hasMoreTokens()) {
                Object object4;
                String string;
                String string2;
                Object object5 = ((StringTokenizer)object3).nextToken();
                if (((String)object5).equals("*")) {
                    object5 = NodeKindTest.ELEMENT;
                    ((SelectedElementsSpaceStrippingRule)object2).addRule((NodeTest)object5, (Stripper.StripRuleTarget)object, componentDeclaration.getModule(), ((NodeImpl)componentDeclaration.getSourceElement()).getLineNumber());
                    continue;
                }
                if (((String)object5).startsWith("Q{")) {
                    int n2 = ((String)object5).indexOf(125);
                    if (n2 < 0) {
                        this.compileError("No closing '}' in EQName");
                        continue;
                    }
                    if (n2 == ((String)object5).length() - 1) {
                        this.compileError("Missing local part in EQName");
                        continue;
                    }
                    string2 = ((String)object5).substring(2, n2);
                    string = ((String)object5).substring(n2 + 1);
                    object5 = string.equals("*") ? new NamespaceTest(this.getNamePool(), 1, string2) : new NameTest(1, string2, string, this.getNamePool());
                    ((SelectedElementsSpaceStrippingRule)object2).addRule((NodeTest)object5, (Stripper.StripRuleTarget)object, componentDeclaration.getModule(), ((NodeImpl)componentDeclaration.getSourceElement()).getLineNumber());
                    continue;
                }
                if (((String)object5).endsWith(":*")) {
                    String string3;
                    if (((String)object5).length() == 2) {
                        this.compileError("No prefix before ':*'");
                    }
                    if ((string2 = this.getURIForPrefix(string3 = ((String)object5).substring(0, ((String)object5).length() - 2), false)) == null) {
                        this.undeclaredNamespaceError(string3, "XTSE0280", "elements");
                    }
                    object5 = new NamespaceTest(this.getNamePool(), 1, string2);
                    ((SelectedElementsSpaceStrippingRule)object2).addRule((NodeTest)object5, (Stripper.StripRuleTarget)object, componentDeclaration.getModule(), ((NodeImpl)componentDeclaration.getSourceElement()).getLineNumber());
                    continue;
                }
                if (((String)object5).startsWith("*:")) {
                    if (((String)object5).length() == 2) {
                        this.compileErrorInAttribute("No local name after '*:'", "XTSE0010", "elements");
                    }
                    String string4 = ((String)object5).substring(2);
                    object5 = new LocalNameTest(this.getNamePool(), 1, string4);
                    ((SelectedElementsSpaceStrippingRule)object2).addRule((NodeTest)object5, (Stripper.StripRuleTarget)object, componentDeclaration.getModule(), ((NodeImpl)componentDeclaration.getSourceElement()).getLineNumber());
                    continue;
                }
                try {
                    object4 = NameChecker.getQNameParts((CharSequence)object5);
                    String string5 = object4[0];
                    if (object4[0].equals("")) {
                        string = this.getDefaultXPathNamespace();
                    } else {
                        string = this.getURIForPrefix(string5, false);
                        if (string == null) {
                            this.undeclaredNamespaceError(string5, "XTSE0280", "elements");
                        }
                    }
                    string2 = object4[1];
                }
                catch (QNameException qNameException) {
                    this.compileError("Element name " + (String)object5 + " is not a valid QName", "XTSE0280");
                    return;
                }
                object4 = this.getNamePool();
                int n3 = object4.allocateFingerprint(string, string2);
                object5 = new NameTest(1, n3, this.getNamePool());
                ((SelectedElementsSpaceStrippingRule)object2).addRule((NodeTest)object5, (Stripper.StripRuleTarget)object, componentDeclaration.getModule(), ((NodeImpl)componentDeclaration.getSourceElement()).getLineNumber());
            }
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.allocateLocation());
            this.compileError(xPathException2);
            return;
        }
    }
}

