/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Whitespace;

public class XSLResultDocument
extends StyleElement {
    public static final HashSet<String> fans = new HashSet<String>(40);
    private Expression a;
    private StructuredQName b;
    private Expression c;
    private int d = 4;
    private SchemaType e = null;
    private Map<StructuredQName, Expression> f = new HashMap<StructuredQName, Expression>(10);
    private boolean g = true;
    public static StructuredQName METHOD;
    public static StructuredQName BUILD_TREE;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            Object object = attributeCollection.getNodeName(i2).getStructuredQName();
            Object object2 = ((StructuredQName)object).getClarkName();
            if (((String)object2).equals("format")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                this.c = this.makeAttributeValueTemplate(string, i2);
                continue;
            }
            if (((String)object2).equals("href")) {
                object = Whitespace.trim(attributeCollection.getValue(i2));
                this.a = this.makeAttributeValueTemplate((String)object, i2);
                continue;
            }
            if (((String)object2).equals("validation")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (((String)object2).equals("type")) {
                string3 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (((String)object2).equals("use-character-maps")) {
                string4 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (fans.contains(object2) || ((String)object2).startsWith("{") && !"{http://saxon.sf.net/}asynchronous".equals(object2)) {
                String string5 = attributeCollection.getValue(i2);
                if (!((String)object2).equals("item-separator") && !((String)object2).equals("{http://saxon.sf.net/}newline")) {
                    string5 = Whitespace.trim(attributeCollection.getValue(i2));
                }
                object2 = this.makeAttributeValueTemplate(string5, i2);
                this.f.put((StructuredQName)object, (Expression)object2);
                continue;
            }
            if (((StructuredQName)object).getLocalPart().equals("asynchronous") && ((StructuredQName)object).hasURI("http://saxon.sf.net/")) {
                this.g = this.processBooleanAttribute("saxon:asynchronous", attributeCollection.getValue(i2));
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    this.g = false;
                    continue;
                }
                if ("EE".equals(((NodeImpl)this).getConfiguration().getEditionCode())) continue;
                this.compileWarning("saxon:asynchronous - ignored when not running Saxon-EE", "SXWN9013");
                this.g = false;
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string != null) {
            if (this.c instanceof StringLiteral) {
                try {
                    this.b = this.makeQName(((StringLiteral)this.c).getStringValue());
                    this.c = null;
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException.getMessage(), "XTDE1460");
                }
            } else {
                this.getPrincipalStylesheetModule().setNeedsDynamicOutputProperties(true);
            }
        }
        this.d = string2 == null ? this.getDefaultValidation() : this.validateValidationAttribute(string2);
        if (string3 != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.e = this.getSchemaType(string3);
            this.d = 8;
        }
        if (string3 != null && string2 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (string4 != null) {
            String string6 = XSLOutput.prepareCharacterMaps(this, string4, new Properties());
            this.f.put(new StructuredQName("", "", "use-character-maps"), new StringLiteral(string6));
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        if (this.a != null && !((NodeImpl)this).getConfiguration().getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.a = this.typeCheck("href", this.a);
        this.c = this.typeCheck("format", this.c);
        for (StructuredQName structuredQName : this.f.keySet()) {
            Expression expression;
            Expression expression2 = this.f.get(structuredQName);
            if (expression2 == (expression = this.typeCheck(structuredQName.getDisplayName(), expression2))) continue;
            this.f.put(structuredQName, expression);
        }
        this.getContainingPackage().setCreatesSecondaryResultDocuments(true);
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        IdentityComparable identityComparable2;
        Iterable<StructuredQName> iterable;
        Object object;
        Object object2 = this.iterateAxis((byte)0);
        while ((object = object2.next()) != null) {
            if (!(object instanceof XSLGeneralVariable) && !(object instanceof XSLFunction)) continue;
            this.issueWarning("An xsl:result-document instruction inside " + object.getDisplayName() + " will always fail at run-time", this);
            return new ErrorExpression("Call to xsl:result-document while in temporary output state", "XTDE1480", false);
        }
        if (this.c == null) {
            try {
                object2 = this.getPrincipalStylesheetModule().gatherOutputProperties(this.b);
            }
            catch (XPathException xPathException) {
                this.compileError("Named output format has not been defined", "XTDE1460");
                return null;
            }
        } else {
            object2 = new Properties();
            this.getPrincipalStylesheetModule().setNeedsDynamicOutputProperties(true);
        }
        if (this.c == null && ((Properties)object2).getProperty("method") == null && this.f.get(METHOD) == null && (iterable = (object = this.iterateAxis((byte)3)).next()) instanceof LiteralResultElement) {
            object = iterable.getURI().equals("http://www.w3.org/1999/xhtml") && iterable.getLocalPart().equals("html") ? (this.getEffectiveVersion() == 10 ? "xml" : "xhtml") : (iterable.getLocalPart().equalsIgnoreCase("html") && iterable.getURI().isEmpty() ? "html" : "xml");
            ((Properties)object2).setProperty("method", (String)object);
        }
        object = new Properties();
        iterable = new HashSet(10);
        NamespaceResolver namespaceResolver = this.getStaticContext().getNamespaceResolver();
        for (IdentityComparable identityComparable2 : this.f.keySet()) {
            Object object3 = this.f.get(identityComparable2);
            if (!(object3 instanceof StringLiteral)) continue;
            object3 = ((StringLiteral)object3).getStringValue();
            String string = identityComparable2.getLocalPart();
            String string2 = identityComparable2.getURI();
            try {
                ResultDocument.setSerializationProperty((Properties)object, string2, string, (String)object3, namespaceResolver, false, compilation.getConfiguration());
                ((HashSet)iterable).add((StructuredQName)identityComparable2);
            }
            catch (XPathException xPathException) {
                if ("http://saxon.sf.net/".equals(xPathException.getErrorCodeNamespace())) {
                    this.compileWarning(xPathException.getMessage(), xPathException.getErrorCodeQName());
                    continue;
                }
                xPathException.setErrorCode("XTSE0020");
                this.compileError(xPathException);
            }
        }
        for (IdentityComparable identityComparable2 : iterable) {
            this.f.remove(identityComparable2);
        }
        ResultDocument resultDocument = new ResultDocument((Properties)object2, (Properties)object, this.a, this.c, this.d, this.e, this.f, this.getContainingPackage().getCharacterMapIndex());
        identityComparable2 = this.compileSequenceConstructor(compilation, componentDeclaration, true);
        if (identityComparable2 == null) {
            identityComparable2 = Literal.makeLiteral(EmptySequence.getInstance());
        }
        resultDocument.setContentExpression((Expression)identityComparable2);
        resultDocument.setAsynchronous(this.g);
        return resultDocument;
    }

    static {
        fans.add("allow-duplicate-names");
        fans.add("build-tree");
        fans.add("byte-order-mark");
        fans.add("cdata-section-elements");
        fans.add("doctype-public");
        fans.add("doctype-system");
        fans.add("encoding");
        fans.add("escape-uri-attributes");
        fans.add("html-version");
        fans.add("include-content-type");
        fans.add("indent");
        fans.add("item-separator");
        fans.add("json-node-output-method");
        fans.add("media-type");
        fans.add("method");
        fans.add("normalization-form");
        fans.add("omit-xml-declaration");
        fans.add("output-version");
        fans.add("parameter-document");
        fans.add("standalone");
        fans.add("suppress-indentation");
        fans.add("undeclare-prefixes");
        fans.add("{http://saxon.sf.net/}attribute-order");
        fans.add("{http://saxon.sf.net/}canonical");
        fans.add("{http://saxon.sf.net/}character-representation");
        fans.add("{http://saxon.sf.net/}double-space");
        fans.add("{http://saxon.sf.net/}indent-spaces");
        fans.add("{http://saxon.sf.net/}line-length");
        fans.add("{http://saxon.sf.net/}newline");
        fans.add("{http://saxon.sf.net/}next-in-chain");
        fans.add("{http://saxon.sf.net/}recognize-binary");
        fans.add("{http://saxon.sf.net/}require-well-formed");
        fans.add("{http://saxon.sf.net/}property-order");
        fans.add("{http://saxon.sf.net/}single-quotes");
        fans.add("{http://saxon.sf.net/}supply-source-locator");
        METHOD = new StructuredQName("", "", "method");
        BUILD_TREE = new StructuredQName("", "", "build-tree");
    }
}

