/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class XSLSortOrMergeKey
extends StyleElement {
    protected SortKeyDefinition sortKeyDefinition;
    protected Expression select;
    protected Expression order;
    protected Expression dataType = null;
    protected Expression caseOrder;
    protected Expression lang;
    protected Expression collationName;
    protected Expression stable;
    protected boolean useDefaultCollation = true;

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected String getErrorCode() {
        return "XTSE1015";
    }

    @Override
    public void validate(ComponentDeclaration object) {
        Object object2;
        if (this.select != null && ((NodeImpl)this).hasChildNodes()) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", this.getErrorCode());
        }
        if (this.select == null && !((NodeImpl)this).hasChildNodes()) {
            this.select = new ContextItemExpression();
            this.select.setRetainedStaticContext(this.getStaticContext().makeRetainedStaticContext());
        }
        if (this.useDefaultCollation) {
            this.collationName = new StringLiteral(this.getDefaultCollationName());
        }
        object = null;
        if (this.collationName instanceof StringLiteral) {
            object2 = ((StringLiteral)this.collationName).getStringValue();
            try {
                object = new URI((String)object2);
                if (!((URI)object).isAbsolute()) {
                    URI uRI = new URI(((NodeImpl)this).getBaseURI());
                    object = uRI.resolve((URI)object);
                    object2 = ((URI)object).toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + (String)object2 + "' is not a valid URI");
                object2 = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            object = this.findCollation((String)object2, ((NodeImpl)this).getBaseURI());
            if (object == null) {
                this.compileError("Collation " + (String)object2 + " has not been defined", "XTDE1035");
                object = CodepointCollator.getInstance();
            }
        }
        this.select = this.typeCheck("select", this.select);
        this.order = this.typeCheck("order", this.order);
        this.caseOrder = this.typeCheck("case-order", this.caseOrder);
        this.lang = this.typeCheck("lang", this.lang);
        this.dataType = this.typeCheck("data-type", this.dataType);
        this.collationName = this.typeCheck("collation", this.collationName);
        if (this.select != null) {
            try {
                object2 = new RoleDiagnostic(4, this.getDisplayName() + "//select", 0);
                this.select = ((NodeImpl)this).getConfiguration().getTypeChecker(false).staticTypeCheck(this.select, SequenceType.ATOMIC_SEQUENCE, (RoleDiagnostic)object2, this.makeExpressionVisitor());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.sortKeyDefinition = new SortKeyDefinition();
        this.sortKeyDefinition.setOrder(this.order);
        this.sortKeyDefinition.setCaseOrder(this.caseOrder);
        this.sortKeyDefinition.setLanguage(this.lang);
        this.sortKeyDefinition.setSortKey(this.select, true);
        this.sortKeyDefinition.setDataTypeExpression(this.dataType);
        this.sortKeyDefinition.setCollationNameExpression(this.collationName);
        this.sortKeyDefinition.setCollation((StringCollator)object);
        this.sortKeyDefinition.setBaseURI(((NodeImpl)this).getBaseURI());
        this.sortKeyDefinition.setStable(this.stable);
        this.sortKeyDefinition.setBackwardsCompatible(this.xPath10ModeIsEnabled());
    }

    protected Expression getStable() {
        return this.stable;
    }

    @Override
    protected void prepareAttributes() {
        Object object;
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            object = attributeCollection.getQName(i2);
            if (((String)object).equals("select")) {
                object = attributeCollection.getValue(i2);
                this.select = this.makeExpression((String)object, i2);
                continue;
            }
            if (((String)object).equals("order")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                this.order = this.makeAttributeValueTemplate(string, i2);
                continue;
            }
            if (((String)object).equals("data-type")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                this.dataType = this.makeAttributeValueTemplate(string2, i2);
                continue;
            }
            if (((String)object).equals("case-order")) {
                string3 = Whitespace.trim(attributeCollection.getValue(i2));
                this.caseOrder = this.makeAttributeValueTemplate(string3, i2);
                continue;
            }
            if (((String)object).equals("lang")) {
                string4 = Whitespace.trim(attributeCollection.getValue(i2));
                this.lang = this.makeAttributeValueTemplate(string4, i2);
                continue;
            }
            if (((String)object).equals("collation")) {
                string5 = Whitespace.trim(attributeCollection.getValue(i2));
                this.collationName = this.makeAttributeValueTemplate(string5, i2);
                continue;
            }
            if (((String)object).equals("stable")) {
                string6 = Whitespace.trim(attributeCollection.getValue(i2));
                this.stable = this.makeAttributeValueTemplate(string6, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.order = new StringLiteral("ascending");
        } else {
            this.checkAttributeValue("order", string, true, new String[]{"ascending", "descending"});
        }
        if (string2 == null) {
            this.dataType = null;
        }
        if (string3 == null) {
            this.caseOrder = new StringLiteral("#default");
        } else {
            this.checkAttributeValue("case-order", string3, true, new String[]{"lower-first", "upper-first"});
            this.useDefaultCollation = false;
        }
        if (string4 == null || string4.equals("")) {
            this.lang = new StringLiteral(StringValue.EMPTY_STRING);
        } else {
            String string7;
            this.useDefaultCollation = false;
            if (this.lang instanceof StringLiteral && (string7 = ((StringLiteral)this.lang).getStringValue()).length() != 0 && (object = ((StringConverter)StringConverter.StringToLanguage.INSTANCE).validate(string7)) != null) {
                this.compileError("The lang attribute must be a valid language code", "XTDE0030");
                this.lang = new StringLiteral(StringValue.EMPTY_STRING);
            }
        }
        if (string6 == null) {
            this.stable = null;
        } else {
            this.checkAttributeValue("stable", string6, true, StyleElement.YES_NO);
        }
        if (string5 != null) {
            this.useDefaultCollation = false;
        }
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration object2) {
        if (this.select == null) {
            if ((object = this.compileSequenceConstructor((Compilation)object, (ComponentDeclaration)object2, true)) == null) {
                object = Literal.makeEmptySequence();
                ((Expression)object).setRetainedStaticContext(this.makeRetainedStaticContext());
            }
            try {
                object2 = Atomizer.makeAtomizer((Expression)object, null);
                object2 = ((Expression)object2).simplify();
                ExpressionTool.copyLocationInfo((Expression)object, (Expression)object2);
                this.sortKeyDefinition.setSortKey((Expression)object2, true);
                this.select = object2;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.sortKeyDefinition = (SortKeyDefinition)this.sortKeyDefinition.simplify();
        return null;
    }

    public SortKeyDefinition getSortKeyDefinition() {
        return this.sortKeyDefinition;
    }
}

