/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public class XSLSourceDocument
extends StyleElement {
    private Expression a = null;
    private Set<Accumulator> b = new HashSet<Accumulator>();
    private boolean c = false;
    private ParseOptions d;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean isWithinDeclaredStreamableConstruct() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        int n2;
        this.d = new ParseOptions(((NodeImpl)this).getConfiguration().getParseOptions());
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (n2 = 0; n2 < attributeCollection.getLength(); ++n2) {
            String string5 = attributeCollection.getQName(n2);
            if (string5.equals("href")) {
                string = attributeCollection.getValue(n2);
                this.a = this.makeAttributeValueTemplate(string, n2);
                continue;
            }
            if (string5.equals("validation")) {
                string2 = Whitespace.trim(attributeCollection.getValue(n2));
                continue;
            }
            if (string5.equals("type")) {
                string3 = Whitespace.trim(attributeCollection.getValue(n2));
                continue;
            }
            if (string5.equals("use-accumulators")) {
                string4 = Whitespace.trim(attributeCollection.getValue(n2));
                continue;
            }
            if (string5.equals("streamable")) {
                this.c = this.b(attributeCollection.getValue(n2));
                continue;
            }
            if ("http://saxon.sf.net/".equals(attributeCollection.getURI(n2))) {
                String string6 = attributeCollection.getLocalName(n2);
                ((NodeImpl)this).getConfiguration().checkLicensedFeature(8, attributeCollection.getQName(n2), this.getPackageData().getLocalLicenseId());
                int n3 = -1;
                switch (string6.hashCode()) {
                    case 2030109202: {
                        if (!string6.equals("dtd-validation")) break;
                        n3 = 0;
                        break;
                    }
                    case -1988919178: {
                        if (!string6.equals("expand-attribute-defaults")) break;
                        n3 = 1;
                        break;
                    }
                    case 2099199328: {
                        if (!string6.equals("line-numbering")) break;
                        n3 = 2;
                        break;
                    }
                    case 626416944: {
                        if (!string6.equals("xinclude")) break;
                        n3 = 3;
                        break;
                    }
                    case -269921958: {
                        if (!string6.equals("validation-params")) break;
                        n3 = 4;
                        break;
                    }
                    case -1377479151: {
                        if (!string6.equals("strip-space")) break;
                        n3 = 5;
                    }
                }
                block8 : switch (n3) {
                    case 0: {
                        this.d.setDTDValidationMode(this.processBooleanAttribute(string5, attributeCollection.getValue(n2)) ? 1 : 4);
                        break;
                    }
                    case 1: {
                        this.d.setExpandAttributeDefaults(this.processBooleanAttribute(string5, attributeCollection.getValue(n2)));
                        break;
                    }
                    case 2: {
                        this.d.setLineNumbering(this.processBooleanAttribute(string5, attributeCollection.getValue(n2)));
                        break;
                    }
                    case 3: {
                        this.d.setXIncludeAware(this.processBooleanAttribute(string5, attributeCollection.getValue(n2)));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        switch (Whitespace.normalizeWhitespace(attributeCollection.getValue(n2)).toString()) {
                            case "#all": {
                                this.d.setSpaceStrippingRule(AllElementsSpaceStrippingRule.getInstance());
                                break block8;
                            }
                            case "#none": {
                                this.d.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                                break block8;
                            }
                            case "#ignorable": {
                                this.d.setSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
                                break block8;
                            }
                            case "#default": {
                                this.d.setSpaceStrippingRule(null);
                                break block8;
                            }
                        }
                        this.invalidAttribute("saxon:strip-space", "#all|#none|#ignorable|#default");
                        break;
                    }
                    default: {
                        this.checkUnknownAttribute(attributeCollection.getNodeName(n2));
                        break;
                    }
                }
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(n2));
        }
        if (string == null) {
            this.reportAbsence("href");
        }
        if (string2 != null) {
            n2 = this.validateValidationAttribute(string2);
            this.d.setSchemaValidationMode(n2);
        }
        if (string3 != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.d.setSchemaValidationMode(8);
            this.d.setTopLevelType(this.getSchemaType(string3));
        }
        if (string3 != null && string2 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (string4 == null) {
            string4 = "";
        }
        AccumulatorRegistry accumulatorRegistry = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry();
        this.b = accumulatorRegistry.getUsedAccumulators(string4, this);
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.a = this.typeCheck("select", this.a);
        if (!((NodeImpl)this).hasChildNodes()) {
            this.compileWarning("An empty xsl:source-document instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration object2) {
        Configuration configuration = ((NodeImpl)this).getConfiguration();
        if (this.d.getSpaceStrippingRule() == null) {
            this.d.setSpaceStrippingRule(this.getPackageData().getSpaceStrippingRule());
        }
        this.d.setApplicableAccumulators(this.b);
        object = this.compileSequenceConstructor((Compilation)object, (ComponentDeclaration)object2, false);
        if (object == null) {
            return Literal.makeEmptySequence();
        }
        try {
            object2 = this.makeExpressionVisitor();
            object = ((Expression)object).simplify();
            object = ((Expression)object).typeCheck((ExpressionVisitor)object2, configuration.makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false));
            return configuration.makeStreamInstruction(this.a, (Expression)object, this.c, this.d, null, this.allocateLocation(), this.makeRetainedStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

