/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLModuleRoot;

public class XSLStylesheet
extends XSLModuleRoot {
    @Override
    protected boolean mayContainParam() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        this.processDefaultCollationAttribute();
        this.processDefaultMode();
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        block24: for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            switch (attributeCollection.getQName(i2)) {
                case "version": {
                    continue block24;
                }
                case "id": {
                    continue block24;
                }
                case "extension-element-prefixes": {
                    continue block24;
                }
                case "exclude-result-prefixes": {
                    continue block24;
                }
                case "input-type-annotations": {
                    string = attributeCollection.getValue(i2);
                    continue block24;
                }
                default: {
                    this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                }
            }
        }
        if (this.version == -1 && (this.getParent() == null || this.getParent().getNodeKind() == 9)) {
            this.reportAbsence("version");
        }
        if (string != null) {
            switch (string) {
                case "strip": {
                    return;
                }
                case "preserve": {
                    return;
                }
                case "unspecified": {
                    return;
                }
            }
            this.invalidAttribute("input-type-annotations", "strip|preserve|unspecified");
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        if (this.validationError != null) {
            XSLStylesheet xSLStylesheet = this;
            xSLStylesheet.compileError(xSLStylesheet.validationError);
        }
        if (this.getParent() != null && this.getParent().getNodeKind() != 9) {
            this.compileError(this.getDisplayName() + " must be the outermost element", "XTSE0010");
        }
        object = this.iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo.getNodeKind() == 3 || nodeInfo instanceof StyleElement && ((StyleElement)nodeInfo).isDeclaration() || nodeInfo instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(nodeInfo.getURI()) && !"".equals(nodeInfo.getURI()) || nodeInfo instanceof AbsentExtensionElement && ((StyleElement)nodeInfo).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(nodeInfo.getURI())) {
                assert (nodeInfo instanceof StyleElement);
                ((StyleElement)nodeInfo).compileError("Element " + nodeInfo.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            assert (nodeInfo instanceof StyleElement);
            ((StyleElement)nodeInfo).compileError("Element " + nodeInfo.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }
}

