/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLTemplate
extends StyleElement
implements StylesheetComponent {
    private String a = null;
    private String b = null;
    private String c = null;
    private String d = null;
    private String e = null;
    private String f = null;
    private StructuredQName[] g;
    private String h;
    private Pattern i;
    private boolean j;
    private double k;
    private SlotManager l;
    private NamedTemplate m;
    private Map<StructuredQName, TemplateRule> n = new HashMap<StructuredQName, TemplateRule>();
    private SequenceType o = SequenceType.ANY_SEQUENCE;
    private boolean p = false;
    private boolean q = false;
    private Visibility r = Visibility.PRIVATE;
    private ItemType s = AnyItemType.getInstance();
    private boolean t = true;
    private boolean u = false;
    private boolean v = false;
    private boolean w;

    @Override
    public final NamedTemplate getActor() {
        return this.m;
    }

    @Override
    public final void setCompilation(Compilation compilation) {
        super.setCompilation(compilation);
    }

    @Override
    public final boolean isDeclaration() {
        return true;
    }

    public final boolean isDeferredCompilation(Compilation compilation) {
        return compilation.isPreScan() && this.getTemplateName() == null && !compilation.isLibraryPackage();
    }

    @Override
    public final boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected final boolean mayContainParam() {
        return true;
    }

    @Override
    protected final boolean isWithinDeclaredStreamableConstruct() {
        try {
            for (Mode mode : this.getApplicableModes()) {
                if (!mode.isDeclaredStreamable()) continue;
                return true;
            }
        }
        catch (XPathException xPathException) {
            return false;
        }
        return false;
    }

    public final void setContextItemRequirements(ItemType itemType, boolean bl2, boolean bl3) {
        this.s = itemType;
        this.t = bl2;
        this.u = bl3;
    }

    @Override
    protected final boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLLocalParam || styleElement.getFingerprint() == 144;
    }

    public final StructuredQName getTemplateName() {
        try {
            String string;
            if (this.getObjectName() == null && (string = ((NodeImpl)this).getAttributeValue("", "name")) != null) {
                XSLTemplate xSLTemplate = this;
                xSLTemplate.setObjectName(xSLTemplate.makeQName(string));
            }
            return this.getObjectName();
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    @Override
    public final SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    public final ItemType getRequiredContextItemType() {
        return this.s;
    }

    public final boolean isMayOmitContextItem() {
        return this.t;
    }

    @Override
    public final void checkCompatibility(Component object) {
        Object object2;
        object = (NamedTemplate)((Component)object).getActor();
        if (!this.getSymbolicName().equals(((Actor)object).getSymbolicName())) {
            throw new IllegalArgumentException();
        }
        Object object3 = this.o == null ? SequenceType.ANY_SEQUENCE : this.o;
        if (!((SequenceType)object3).equals(((NamedTemplate)object).getRequiredType())) {
            this.compileError("The overriding template has a different required type from the overridden template", "XTSE3070");
            return;
        }
        if (!this.s.equals(((NamedTemplate)object).getRequiredContextItemType()) || this.t != ((NamedTemplate)object).isMayOmitContextItem() || this.u != ((NamedTemplate)object).isAbsentFocus()) {
            this.compileError("The required context item for the overriding template differs from that of the overridden template", "XTSE3070");
            return;
        }
        object = ((NamedTemplate)object).getLocalParamDetails();
        object3 = new HashSet();
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (NamedTemplate.LocalParamInfo)object.next();
            XSLLocalParam xSLLocalParam = this.getParam(((NamedTemplate.LocalParamInfo)object2).name);
            if (xSLLocalParam == null) {
                if (!((NamedTemplate.LocalParamInfo)object2).isTunnel) {
                    this.compileError("The overridden template declares a parameter " + ((NamedTemplate.LocalParamInfo)object2).name.getDisplayName() + " which is not declared in the overriding template", "XTSE3070");
                }
                return;
            }
            if (!xSLLocalParam.getRequiredType().equals(((NamedTemplate.LocalParamInfo)object2).requiredType)) {
                xSLLocalParam.compileError("The parameter " + ((NamedTemplate.LocalParamInfo)object2).name.getDisplayName() + " has a different required type in the overridden template", "XTSE3070");
                return;
            }
            if (xSLLocalParam.isRequiredParam() != ((NamedTemplate.LocalParamInfo)object2).isRequired && !((NamedTemplate.LocalParamInfo)object2).isTunnel) {
                xSLLocalParam.compileError("The parameter " + ((NamedTemplate.LocalParamInfo)object2).name.getDisplayName() + " is " + (xSLLocalParam.isRequiredParam() ? "required" : "optional") + " in the overriding template, but " + (((NamedTemplate.LocalParamInfo)object2).isRequired ? "required" : "optional") + " in the overridden template", "XTSE3070");
                return;
            }
            if (xSLLocalParam.isTunnelParam() != ((NamedTemplate.LocalParamInfo)object2).isTunnel) {
                xSLLocalParam.compileError("The parameter " + ((NamedTemplate.LocalParamInfo)object2).name.getDisplayName() + " is a " + (xSLLocalParam.isTunnelParam() ? "tunnel" : "non-tunnel") + " parameter in the overriding template, but " + (((NamedTemplate.LocalParamInfo)object2).isTunnel ? "tunnel" : "non-tunnel") + " parameter in the overridden template", "XTSE3070");
                return;
            }
            object3.add(((NamedTemplate.LocalParamInfo)object2).name);
        }
        object = this.iterateAxis((byte)3);
        while ((object2 = object.next()) != null) {
            if (!(object2 instanceof XSLLocalParam) || object3.contains(((StyleElement)((XSLLocalParam)object2)).getObjectName()) || !((XSLLocalParam)object2).isRequiredParam()) continue;
            ((XSLLocalParam)object2).compileError("An overriding template cannot introduce a required parameter that is not declared in the overridden template", "XTSE3070");
        }
    }

    public final XSLLocalParam getParam(StructuredQName structuredQName) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLLocalParam) || !structuredQName.equals(((StyleElement)((XSLLocalParam)nodeInfo)).getObjectName())) continue;
            return (XSLLocalParam)nodeInfo;
        }
        return null;
    }

    @Override
    public final void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("mode")) {
                this.b = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string2.equals("name")) {
                this.c = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string2.equals("match")) {
                this.a = attributeCollection.getValue(i2);
                continue;
            }
            if (string2.equals("priority")) {
                this.d = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string2.equals("as")) {
                this.e = attributeCollection.getValue(i2);
                continue;
            }
            if (string2.equals("visibility")) {
                this.f = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (attributeCollection.getURI(i2).equals("http://saxon.sf.net/")) {
                if (attributeCollection.getLocalName(i2).equals("as")) {
                    string = attributeCollection.getValue(i2);
                    continue;
                }
                if (!attributeCollection.getLocalName(i2).equals("explain")) continue;
                this.w = XSLTemplate.a(Whitespace.trim(attributeCollection.getValue(i2)));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        try {
            if (this.b == null) {
                if (this.a != null) {
                    StructuredQName structuredQName = this.getDefaultMode();
                    if (structuredQName == null) {
                        structuredQName = Mode.UNNAMED_MODE_NAME;
                    }
                    this.g = new StructuredQName[1];
                    this.g[0] = structuredQName;
                }
            } else {
                if (this.a == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent", "XTSE0500");
                }
                this.getModeNames();
            }
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetErrorCode("XTSE0280");
            if (xPathException2.getErrorCodeLocalPart().equals("XTSE0020")) {
                xPathException2.setErrorCode("XTSE0550");
            }
            xPathException2.setIsStaticError(true);
            this.compileError(xPathException2);
        }
        try {
            if (this.c != null) {
                XSLTemplate xSLTemplate = this;
                StructuredQName structuredQName = xSLTemplate.makeQName(xSLTemplate.c);
                this.setObjectName(structuredQName);
                if (this.m != null) {
                    this.m.setTemplateName(structuredQName);
                }
                this.h = this.c;
            }
        }
        catch (XPathException xPathException) {
            XPathException xPathException3 = xPathException;
            xPathException.maybeSetErrorCode("XTSE0280");
            xPathException3.setIsStaticError(true);
            this.compileError(xPathException3);
        }
        boolean bl2 = this.j = this.d != null;
        if (this.j) {
            if (this.a == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent", "XTSE0500");
            }
            try {
                if (!BigDecimalValue.castableAsDecimal(this.d)) {
                    this.compileError("Invalid numeric value for priority (" + this.k + ')', "XTSE0530");
                }
                this.k = Double.parseDouble(this.d);
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("Invalid numeric value for priority (" + this.k + ')', "XTSE0530");
            }
        }
        if (this.a != null) {
            this.i = this.makePattern(this.a, "match");
            if (this.h == null) {
                this.h = "match=\"" + this.a + '\"';
                if (this.b != null) {
                    this.h = this.h + " mode=\"" + this.b + '\"';
                }
            }
        }
        if (this.i == null && this.c == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)", "XTSE0500");
        }
        if (this.e != null) {
            try {
                this.o = this.makeSequenceType(this.e);
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "as");
            }
        }
        if (string != null) {
            SequenceType sequenceType;
            try {
                sequenceType = this.makeExtendedSequenceType(string);
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "saxon:as");
                sequenceType = this.o;
            }
            if (this.e != null) {
                int n2 = ((NodeImpl)this).getConfiguration().getTypeHierarchy().sequenceTypeRelationship(sequenceType, this.o);
                if (n2 == 0 || n2 == 2) {
                    this.o = sequenceType;
                } else {
                    this.compileErrorInAttribute("When both are present, @saxon:as must be a subtype of @as", "SXER7TBA", "saxon:as");
                }
            } else {
                this.o = sequenceType;
            }
        }
        if (this.f != null) {
            this.r = this.interpretVisibilityValue(this.f, "");
            if (this.c == null) {
                this.compileError("xsl:template/@visibility can be specified only if the template has a @name attribute", "XTSE0020");
                return;
            }
            this.m.setDeclaredVisibility(this.getVisibility());
        }
    }

    @Override
    public final void processAllAttributes() {
        String string = this.getAttributeValue("mode");
        if (string != null) {
            Whitespace.trim(string);
        }
        XSLTemplate xSLTemplate = this;
        if (!xSLTemplate.isDeferredCompilation(xSLTemplate.getCompilation())) {
            super.processAllAttributes();
            return;
        }
        this.processDefaultCollationAttribute();
        this.processDefaultMode();
        this.staticContext = new ExpressionContext(this, null);
        this.processAttributes();
    }

    public final StructuredQName[] getModeNames() {
        if (this.g == null) {
            if (this.b == null) {
                this.b = this.getAttributeValue("mode");
                if (this.b == null) {
                    this.b = "#default";
                }
            }
            boolean bl2 = false;
            String[] stringArray = Whitespace.trim(this.b).split("[ \t\n\r]+");
            int n2 = stringArray.length;
            this.g = new StructuredQName[n2];
            n2 = 0;
            for (String string : stringArray) {
                StructuredQName structuredQName;
                if ("#default".equals(string)) {
                    structuredQName = this.getDefaultMode();
                    if (structuredQName == null) {
                        structuredQName = Mode.UNNAMED_MODE_NAME;
                    }
                } else if ("#unnamed".equals(string)) {
                    structuredQName = Mode.UNNAMED_MODE_NAME;
                } else if ("#all".equals(string)) {
                    bl2 = true;
                    structuredQName = Mode.OMNI_MODE;
                } else {
                    try {
                        structuredQName = this.makeQName(string);
                    }
                    catch (XPathException xPathException) {
                        this.compileError(xPathException.getMessage(), "XTSE0550");
                        structuredQName = Mode.UNNAMED_MODE_NAME;
                    }
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!this.g[i2].equals(structuredQName)) continue;
                    this.compileError("In the list of modes, the value " + string + " is duplicated", "XTSE0550");
                }
                this.g[n2++] = structuredQName;
            }
            if (bl2 && n2 > 1) {
                this.compileError("mode='#all' cannot be combined with other modes", "XTSE0550");
            }
        }
        return this.g;
    }

    public final Set<Mode> getApplicableModes() {
        StructuredQName[] structuredQNameArray = this.getModeNames();
        HashSet<Mode> hashSet = new HashSet<Mode>(structuredQNameArray.length);
        RuleManager ruleManager = this.getPrincipalStylesheetModule().getRuleManager();
        for (StructuredQName structuredQName : structuredQNameArray) {
            if (structuredQName.equals(Mode.OMNI_MODE)) {
                hashSet.add(ruleManager.getUnnamedMode());
                hashSet.addAll(ruleManager.getAllNamedModes());
                continue;
            }
            Mode mode = ruleManager.obtainMode(structuredQName, false);
            if (mode == null) continue;
            hashSet.add(mode);
        }
        return hashSet;
    }

    public final boolean isOmniMode() {
        for (StructuredQName structuredQName : this.getModeNames()) {
            if (!structuredQName.equals(Mode.OMNI_MODE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void validate(ComponentDeclaration object) {
        NodeImpl nodeImpl;
        this.l = ((NodeImpl)this).getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010", true);
        if (this.i != null) {
            this.i = this.typeCheck("match", this.i);
            if (((Expression)this.i).getItemType() instanceof ErrorType) {
                this.issueWarning(new XPathException("Pattern will never match anything", "SXWN9015", this));
            }
            if (this.getPrincipalStylesheetModule().isDeclaredModes()) {
                object = this.getPrincipalStylesheetModule().getRuleManager();
                if (this.g != null) {
                    StructuredQName[] structuredQNameArray = this.g;
                    int n2 = this.g.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        StructuredQName structuredQName = structuredQNameArray[i2];
                        if (structuredQName.equals(Mode.UNNAMED_MODE_NAME) && !((RuleManager)object).isUnnamedModeExplicit()) {
                            this.compileError("The unnamed mode has not been declared in an xsl:mode declaration", "XTSE3085");
                        }
                        if (((RuleManager)object).obtainMode(structuredQName, false) != null) continue;
                        this.compileError("Mode name " + structuredQName.getDisplayName() + " has not been declared in an xsl:mode declaration", "XTSE3085");
                    }
                } else if (!((RuleManager)object).isUnnamedModeExplicit()) {
                    this.compileError("The unnamed mode has not been declared in an xsl:mode declaration", "XTSE3085");
                }
            }
            if (this.r == Visibility.ABSTRACT) {
                this.compileError("An abstract template must have no match attribute");
            }
        }
        object = this.iterateAxis((byte)3);
        boolean bl2 = false;
        while ((nodeImpl = (NodeImpl)object.next()) != null) {
            if (!(nodeImpl instanceof StyleElement) || nodeImpl.getFingerprint() == 144) continue;
            if (nodeImpl instanceof XSLLocalParam) {
                if (!((XSLLocalParam)nodeImpl).isRequiredParam()) continue;
                this.p = true;
                continue;
            }
            bl2 = true;
        }
        if (this.r == Visibility.ABSTRACT && bl2) {
            this.compileError("A template with visibility='abstract' must have no body");
        }
    }

    @Override
    public final void validateSubtree(ComponentDeclaration componentDeclaration, boolean bl2) {
        XSLTemplate xSLTemplate = this;
        if (!xSLTemplate.isDeferredCompilation(xSLTemplate.getCompilation())) {
            super.validateSubtree(componentDeclaration, bl2);
            return;
        }
        try {
            ((StyleElement)this).validate(componentDeclaration);
            return;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return;
        }
    }

    @Override
    public final void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
        if (this.getTemplateName() != null) {
            if (this.m == null) {
                this.m = new NamedTemplate(this.getTemplateName());
            }
            principalStylesheetModule.indexNamedTemplate(componentDeclaration);
        }
    }

    @Override
    public final boolean markTailCalls() {
        StyleElement styleElement = this.getLastChildInstruction();
        return styleElement != null && styleElement.markTailCalls();
    }

    @Override
    public final void compileDeclaration(Compilation object, ComponentDeclaration object2) {
        Expression expression;
        if (this.isDeferredCompilation((Compilation)object)) {
            Object object3 = object;
            object = object2;
            Object compilation2 = object3;
            XSLTemplate xSLTemplate = this;
            object2 = xSLTemplate.g;
            if (xSLTemplate.isOmniMode()) {
                ArrayList<StructuredQName> object32 = new ArrayList<StructuredQName>();
                object32.add(Mode.UNNAMED_MODE_NAME);
                RuleManager ruleManager = xSLTemplate.getCompilation().getPrincipalStylesheetModule().getRuleManager();
                for (Mode object4 : ruleManager.getAllNamedModes()) {
                    object32.add(object4.getModeName());
                }
                object2 = object32.toArray(new StructuredQName[0]);
            }
            for (ArrayList arrayList : object2) {
                object2 = xSLTemplate.n.get(arrayList);
                if (object2 == null) {
                    object2 = ((NodeImpl)xSLTemplate).getConfiguration().makeTemplateRule();
                }
                ((TemplateRule)object2).prepareInitializer((Compilation)compilation2, (ComponentDeclaration)object, (StructuredQName)((Object)arrayList));
                xSLTemplate.n.put((StructuredQName)((Object)arrayList), (TemplateRule)object2);
                RetainedStaticContext retainedStaticContext = xSLTemplate.makeRetainedStaticContext();
                ((TemplateRule)object2).setPackageData(retainedStaticContext.getPackageData());
                xSLTemplate.a((TemplateRule)object2, null);
            }
            return;
        }
        if (((Compilation)object).getCompilerInfo().getOptimizerOptions().isSet(16384)) {
            this.q = this.markTailCalls();
        }
        Expression expression2 = this.compileSequenceConstructor((Compilation)object, (ComponentDeclaration)object2, true);
        expression2.restoreParentPointers();
        NamespaceResolver namespaceResolver = this.makeRetainedStaticContext();
        if (expression2.getRetainedStaticContext() == null) {
            expression2.setRetainedStaticContext((RetainedStaticContext)namespaceResolver);
        }
        if (this.i != null && ((Compilation)object).getConfiguration().getBooleanProperty(Feature.STRICT_STREAMABILITY) && this.isWithinDeclaredStreamableConstruct()) {
            expression = expression2;
            namespaceResolver = this;
            ((NodeImpl)((Object)namespaceResolver)).getConfiguration().checkStrictStreamability((XSLTemplate)namespaceResolver, expression);
        }
        if (this.getTemplateName() != null) {
            expression = expression2;
            namespaceResolver = this;
            RetainedStaticContext retainedStaticContext = expression.getRetainedStaticContext();
            ((XSLTemplate)namespaceResolver).m.setPackageData(retainedStaticContext.getPackageData());
            ((Actor)((XSLTemplate)namespaceResolver).m).setBody(expression);
            ((XSLTemplate)namespaceResolver).m.setStackFrameMap(((XSLTemplate)namespaceResolver).l);
            ((XSLTemplate)namespaceResolver).m.setSystemId(((NodeImpl)((Object)namespaceResolver)).getSystemId());
            ((XSLTemplate)namespaceResolver).m.setLineNumber(((NodeImpl)((Object)namespaceResolver)).getLineNumber());
            ((XSLTemplate)namespaceResolver).m.setHasRequiredParams(((XSLTemplate)namespaceResolver).p);
            ((XSLTemplate)namespaceResolver).m.setRequiredType(((XSLTemplate)namespaceResolver).o);
            ((XSLTemplate)namespaceResolver).m.setContextItemRequirements(((XSLTemplate)namespaceResolver).s, ((XSLTemplate)namespaceResolver).t, ((XSLTemplate)namespaceResolver).u);
            ((XSLTemplate)namespaceResolver).m.setRetainedStaticContext(retainedStaticContext);
            ((XSLTemplate)namespaceResolver).m.setDeclaredVisibility(((StyleElement)namespaceResolver).getDeclaredVisibility());
            Component component = ((StyleElement)namespaceResolver).getOverriddenComponent();
            if (component != null) {
                ((XSLTemplate)namespaceResolver).checkCompatibility(component);
            }
            ContextItemStaticInfo contextItemStaticInfo = ((NodeImpl)((Object)namespaceResolver)).getConfiguration().makeContextItemStaticInfo(((XSLTemplate)namespaceResolver).s, ((XSLTemplate)namespaceResolver).t);
            Expression expression3 = super.a(expression, contextItemStaticInfo);
            ((Actor)((XSLTemplate)namespaceResolver).m).setBody(expression3);
        }
        if (this.i != null) {
            this.compileTemplateRule((Compilation)object, expression2, (ComponentDeclaration)object2);
        }
    }

    private Expression a(Expression expression, ContextItemStaticInfo contextItemStaticInfo) {
        Object object;
        Object object2;
        Expression expression2 = expression;
        try {
            expression = expression.simplify();
        }
        catch (XPathException xPathException) {
            object2 = xPathException;
            if (xPathException.isReportableStatically()) {
                this.compileError((XPathException)object2);
            }
            expression = new ErrorExpression((XPathException)object2);
            ExpressionTool.copyLocationInfo(expression2, expression);
        }
        object2 = ((NodeImpl)this).getConfiguration();
        if (this.r != Visibility.ABSTRACT) {
            try {
                if (this.o != null && this.o != SequenceType.ANY_SEQUENCE) {
                    object = new RoleDiagnostic(7, this.h, 0);
                    ((RoleDiagnostic)object).setErrorCode("XTTE0505");
                    expression = ((Configuration)object2).getTypeChecker(false).staticTypeCheck(expression, this.o, (RoleDiagnostic)object, this.makeExpressionVisitor());
                }
            }
            catch (XPathException xPathException) {
                object = xPathException;
                if (xPathException.isReportableStatically()) {
                    this.compileError((XPathException)object);
                }
                expression = new ErrorExpression((XPathException)object);
                ExpressionTool.copyLocationInfo(expression2, expression);
            }
        }
        if (this.getCompilation().getCompilerInfo().isCompileWithTracing() && (expression = XSLTemplate.makeTraceInstruction(this, expression)) instanceof TraceExpression) {
            ((TraceExpression)expression).setProperty("match", this.a);
            ((TraceExpression)expression).setProperty("mode", this.b);
        }
        try {
            object = this.makeExpressionVisitor();
            expression = expression.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        return expression;
    }

    public final void compileTemplateRule(Compilation object, Expression expression, ComponentDeclaration iterator) {
        object = ((NodeImpl)this).getConfiguration();
        if (this.getTemplateName() != null) {
            expression = expression.copy(new RebindingMap());
        }
        if ((iterator = ((Expression)this.i).getItemType()).equals(ErrorType.getInstance())) {
            iterator = AnyItemType.getInstance();
        }
        object = ((Configuration)object).makeContextItemStaticInfo((ItemType)((Object)iterator), false);
        expression = this.a(expression, (ContextItemStaticInfo)object);
        boolean bl2 = false;
        for (TemplateRule templateRule : this.n.values()) {
            if (bl2) {
                expression = expression.copy(new RebindingMap());
            }
            this.a(templateRule, expression);
            bl2 = true;
            templateRule.updateSlaveCopies();
        }
    }

    private void a(TemplateRule templateRule, Expression expression) {
        templateRule.setMatchPattern(this.i);
        templateRule.setBody(expression);
        templateRule.setStackFrameMap(this.l);
        templateRule.setSystemId(((NodeImpl)this).getSystemId());
        templateRule.setLineNumber(((NodeImpl)this).getLineNumber());
        templateRule.setHasRequiredParams(this.p);
        templateRule.setRequiredType(this.o);
        templateRule.setContextItemRequirements(this.s, this.u);
    }

    public final synchronized void jitCompile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        if (!this.v) {
            this.v = true;
            compilation.setPreScan(false);
            ((StyleElement)this).processAllAttributes();
            this.a(compilation);
            ((StyleElement)this).validateSubtree(componentDeclaration, false);
            this.a(compilation);
            ((StyleElement)this).compileDeclaration(compilation, componentDeclaration);
            this.a(compilation);
        }
    }

    private void a(Compilation object) {
        if (((Compilation)object).getErrorCount() > 0) {
            object = new XPathException("Errors were reported during JIT compilation of template rule with match=\"" + this.a + "\"", "SXST0001", this);
            ((XPathException)object).setHasBeenReported(true);
            throw object;
        }
    }

    public final void register(ComponentDeclaration object) {
        if (this.i != null) {
            object = ((ComponentDeclaration)object).getModule();
            RuleManager ruleManager = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
            ExpressionVisitor expressionVisitor = ExpressionVisitor.make(this.getStaticContext());
            for (StructuredQName bl3 : this.getModeNames()) {
                Object object2;
                ExpressionOwner expressionOwner = ruleManager.obtainMode(bl3, false);
                if (expressionOwner == null) {
                    if (ruleManager.existsOmniMode()) {
                        object2 = ruleManager.obtainMode(Mode.OMNI_MODE, true);
                        expressionOwner = ruleManager.obtainMode(bl3, true);
                        SimpleMode.copyRules(((Mode)object2).getActivePart(), ((Mode)expressionOwner).getActivePart());
                    } else {
                        expressionOwner = ruleManager.obtainMode(bl3, true);
                    }
                } else {
                    boolean bl2 = this.getPrincipalStylesheetModule().checkAcceptableModeForPackage(this, (Mode)expressionOwner);
                    if (!bl2) {
                        return;
                    }
                }
                object2 = this.i.copy(new RebindingMap());
                Object object3 = ((Mode)expressionOwner).getActivePart().getPropertyValue("typed");
                if ("strict".equals(object3) || "lax".equals(object3)) {
                    try {
                        object3 = ((Pattern)object2).convertToTypedPattern((String)object3);
                    }
                    catch (XPathException xPathException) {
                        XPathException xPathException2 = xPathException;
                        xPathException.maybeSetLocation(this);
                        throw xPathException2;
                    }
                    if (object3 != object2) {
                        ContextItemStaticInfo contextItemStaticInfo = ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), false);
                        ExpressionTool.copyLocationInfo(this.i, (Expression)object3);
                        ((Pattern)object3).setOriginalText(((Expression)this.i).toString());
                        object2 = object3 = ((Pattern)object3).typeCheck(expressionVisitor, contextItemStaticInfo);
                    }
                    if (this.g.length == 1) {
                        this.i = object3;
                    }
                }
                if ((object3 = this.n.get(bl3)) == null) {
                    object3 = ((NodeImpl)this).getConfiguration().makeTemplateRule();
                    this.n.put(bl3, (TemplateRule)object3);
                }
                double contextItemStaticInfo = this.j ? this.k : Double.NaN;
                ruleManager.registerRule((Pattern)object2, (TemplateRule)object3, (Mode)expressionOwner, (StylesheetModule)object, contextItemStaticInfo, ruleManager.allocateSequenceNumber(), 0);
                if (((Mode)expressionOwner).isDeclaredStreamable()) {
                    ((TemplateRule)object3).setDeclaredStreamable(true);
                    if (!((Pattern)object2).isMotionless()) {
                        boolean bl4 = ((NodeImpl)this).getConfiguration().getBooleanProperty(Feature.STREAMING_FALLBACK);
                        Object object4 = "Template rule is declared streamable but the match pattern is not motionless";
                        if (bl4) {
                            object4 = (String)object4 + "\n  * Falling back to non-streaming implementation";
                            this.getStaticContext().issueWarning((String)object4, this);
                            ((TemplateRule)object3).setDeclaredStreamable(false);
                            this.getCompilation().setFallbackToNonStreaming(true);
                        } else {
                            throw new XPathException((String)object4, "XTSE3430", this);
                        }
                    }
                }
                if (!((Mode)expressionOwner).getModeName().equals(Mode.OMNI_MODE)) continue;
                this.n.put(Mode.UNNAMED_MODE_NAME, (TemplateRule)object3);
                ruleManager.registerRule((Pattern)object2, (TemplateRule)object3, ruleManager.getUnnamedMode(), (StylesheetModule)object, contextItemStaticInfo, ruleManager.allocateSequenceNumber(), 0);
                for (Object object4 : ruleManager.getAllNamedModes()) {
                    if (!(object4 instanceof SimpleMode)) continue;
                    expressionOwner = ((TemplateRule)object3).copy();
                    if (((Mode)object4).isDeclaredStreamable()) {
                        ((TemplateRule)expressionOwner).setDeclaredStreamable(true);
                    }
                    this.n.put(((Mode)object4).getModeName(), (TemplateRule)expressionOwner);
                    ruleManager.registerRule(((Pattern)object2).copy(new RebindingMap()), (TemplateRule)expressionOwner, (Mode)object4, (StylesheetModule)object, contextItemStaticInfo, ruleManager.allocateSequenceNumber(), 0);
                }
            }
        }
    }

    public final void allocatePatternSlotNumbers() {
        if (this.i != null) {
            for (TemplateRule templateRule : this.n.values()) {
                for (Rule rule : templateRule.getRules()) {
                    Pattern pattern = rule.getPattern();
                    int n2 = 0;
                    if ((((Expression)pattern).getDependencies() & 1) != 0) {
                        n2 = 1;
                    }
                    if ((n2 = pattern.allocateSlots(this.getSlotManager(), n2)) == 0 && (((Expression)pattern).getDependencies() & 0x100) != 0) {
                        n2 = 1;
                    }
                    if (n2 <= 0) continue;
                    RuleManager ruleManager = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
                    boolean bl2 = false;
                    StructuredQName[] structuredQNameArray = this.g;
                    int n3 = this.g.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Object object = structuredQNameArray[i2];
                        if (((StructuredQName)object).equals(Mode.OMNI_MODE)) {
                            bl2 = true;
                            break;
                        }
                        object = ruleManager.obtainMode((StructuredQName)object, true);
                        ((Mode)object).getActivePart().allocatePatternSlots(n2);
                    }
                    if (!bl2) continue;
                    for (Mode mode : ruleManager.getAllNamedModes()) {
                        mode.getActivePart().allocatePatternSlots(n2);
                    }
                    ((Mode)ruleManager.getUnnamedMode()).getActivePart().allocatePatternSlots(n2);
                }
            }
        }
    }

    @Override
    public final void optimize(ComponentDeclaration object) {
        Object object2;
        ExpressionVisitor expressionVisitor;
        ContextItemStaticInfo contextItemStaticInfo;
        Iterator<TemplateRule> iterator;
        object = ((NodeImpl)this).getConfiguration();
        if (this.m != null) {
            iterator = this.m.getBody();
            contextItemStaticInfo = ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(this.s, this.t);
            expressionVisitor = this.makeExpressionVisitor();
            iterator = ((Expression)((Object)iterator)).typeCheck(expressionVisitor, contextItemStaticInfo);
            iterator = ExpressionTool.optimizeComponentBody((Expression)((Object)iterator), this.getCompilation(), expressionVisitor, contextItemStaticInfo, true);
            ((Actor)this.m).setBody((Expression)((Object)iterator));
            this.allocateLocalSlots((Expression)((Object)iterator));
            if (this.w) {
                object2 = ((NodeImpl)this).getConfiguration().getLogger();
                ((Logger)object2).info("Optimized expression tree for named template at line " + ((NodeImpl)this).getLineNumber() + " in " + ((NodeImpl)this).getSystemId() + ':');
                ((Expression)((Object)iterator)).explain((Logger)object2);
            }
            ((Expression)((Object)iterator)).restoreParentPointers();
            if (((Configuration)object).isDeferredByteCode(50) && !this.q) {
                object2 = ((Configuration)object).obtainOptimizer();
                ((Actor)this.m).setBody(((Optimizer)object2).makeByteCodeCandidate(this.m, (Expression)((Object)iterator), this.h, 6));
            }
        }
        if (this.i != null) {
            iterator = this.getContextItemTypeForTemplateRule();
            contextItemStaticInfo = ((Configuration)object).makeContextItemStaticInfo((ItemType)((Object)iterator), false);
            contextItemStaticInfo.setContextPostureStriding();
            expressionVisitor = this.makeExpressionVisitor();
            this.i.resetLocalStaticProperties();
            this.i = this.i.optimize(expressionVisitor, contextItemStaticInfo);
            XSLTemplate xSLTemplate = this;
            if (!xSLTemplate.isDeferredCompilation(xSLTemplate.getCompilation())) {
                object2 = this.n.values().stream().findFirst().map(TemplateRule::getBody).orElse(null);
                ExpressionTool.resetPropertiesWithinSubtree((Expression)object2);
                object = ((NodeImpl)this).getConfiguration().obtainOptimizer();
                try {
                    for (TemplateRule templateRule : this.n.values()) {
                        Object object3 = this.n.size() > 1 ? ((Expression)object2).copy(new RebindingMap()) : object2;
                        expressionVisitor.setOptimizeForStreaming(templateRule.isDeclaredStreamable());
                        object3 = ((Expression)object3).typeCheck(expressionVisitor, contextItemStaticInfo);
                        object3 = ExpressionTool.optimizeComponentBody((Expression)object3, this.getCompilation(), expressionVisitor, contextItemStaticInfo, true);
                        templateRule.setBody((Expression)object3);
                        ((Optimizer)object).checkStreamability(this, templateRule);
                        this.allocateLocalSlots((Expression)object3);
                        for (Rule rule : templateRule.getRules()) {
                            Pattern pattern = rule.getPattern();
                            Object object4 = ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(((Expression)pattern).getItemType(), false);
                            ((ContextItemStaticInfo)object4).setContextPostureStriding();
                            object4 = pattern.optimize(expressionVisitor, (ContextItemStaticInfo)object4);
                            if (this.n.size() > 1) {
                                object4 = ((Pattern)object4).copy(new RebindingMap());
                            }
                            if (object4 == pattern) continue;
                            rule.setPattern((Pattern)object4);
                        }
                        if (expressionVisitor.getConfiguration().isDeferredByteCode(50) && !this.q) {
                            templateRule.setBody(((Optimizer)object).makeByteCodeCandidate(templateRule, (Expression)object3, this.h, 6));
                        }
                        if (!this.w) continue;
                        Logger logger = ((NodeImpl)this).getConfiguration().getLogger();
                        logger.info("Optimized expression tree for template rule at line " + ((NodeImpl)this).getLineNumber() + " in " + ((NodeImpl)this).getSystemId() + ':');
                        ((Expression)object3).explain(logger);
                    }
                    return;
                }
                catch (XPathException xPathException) {
                    iterator = xPathException;
                    xPathException.maybeSetLocation(this);
                    this.compileError((XPathException)((Object)iterator));
                }
            }
        }
    }

    public final ItemType getContextItemTypeForTemplateRule() {
        Configuration configuration = ((NodeImpl)this).getConfiguration();
        ItemType itemType = ((Expression)this.i).getItemType();
        if (itemType.equals(ErrorType.getInstance())) {
            itemType = AnyItemType.getInstance();
        }
        if (this.s != AnyItemType.getInstance()) {
            int n2 = configuration.getTypeHierarchy().relationship(itemType, this.s);
            switch (n2) {
                case 4: {
                    XPathException xPathException = new XPathException("The declared context item type is inconsistent with the match pattern", "XPTY0004", this);
                    xPathException.setIsTypeError(true);
                    throw xPathException;
                }
                case 0: 
                case 2: 
                case 3: {
                    break;
                }
                case 1: {
                    itemType = this.s;
                }
            }
        }
        return itemType;
    }

    @Override
    public final void generateByteCode(Optimizer optimizer) {
        if (this.getCompilation().getCompilerInfo().isGenerateByteCode() && !this.q) {
            ICompilerService iCompilerService = ((NodeImpl)this).getConfiguration().makeCompilerService(50);
            if (this.getTemplateName() != null) {
                try {
                    Expression expression = this.m.getBody();
                    Expression object = optimizer.compileToByteCode(iCompilerService, expression, this.c, 4);
                    if (object != null) {
                        ((Actor)this.m).setBody(object);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Failed while compiling named template " + this.c);
                    exception.printStackTrace();
                    throw new XPathException(exception);
                }
            }
            for (TemplateRule templateRule : this.n.values()) {
                if (templateRule.isDeclaredStreamable()) continue;
                try {
                    Expression expression = templateRule.getBody();
                    if (expression == null || (expression = optimizer.compileToByteCode(iCompilerService, expression, this.a, 4)) == null) continue;
                    templateRule.setBody(expression);
                }
                catch (Exception exception) {
                    System.err.println("Failed while compiling template rule with match = '" + this.a + "'");
                    exception.printStackTrace();
                    throw new XPathException(exception);
                }
            }
        }
    }

    @Override
    public final SlotManager getSlotManager() {
        return this.l;
    }

    public final NamedTemplate getCompiledNamedTemplate() {
        return this.m;
    }

    @Override
    public final int getConstructType() {
        return 200;
    }

    public final Pattern getMatch() {
        return this.i;
    }

    public final Map<StructuredQName, TemplateRule> getTemplateRulesByMode() {
        return this.n;
    }
}

