/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLText
extends XSLLeafNodeConstructor {
    private boolean a = false;
    private StringValue b;

    @Override
    public void prepareAttributes() {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("disable-output-escaping")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string != null) {
            this.a = this.processBooleanAttribute("disable-output-escaping", string);
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        this.b = StringValue.EMPTY_STRING;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).compileError("xsl:text must not contain child elements", "XTSE0010");
                return;
            }
            this.b = StringValue.makeStringValue(nodeInfo.getStringValueCS());
        }
        super.validate(componentDeclaration);
    }

    @Override
    protected String getErrorCodeForSelectPlusContent() {
        return null;
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration object2) {
        if (this.isExpandingText()) {
            object = (TextImpl)this.iterateAxis((byte)3).next();
            if (object != null) {
                object2 = new ArrayList(10);
                this.compileContentValueTemplate((TextImpl)object, (List<Expression>)object2);
                object = Block.makeBlock((List<Expression>)object2);
                ((Expression)object).setLocation(this.allocateLocation());
                return object;
            }
            return new ValueOf(new StringLiteral(StringValue.EMPTY_STRING), this.a, false);
        }
        return new ValueOf(Literal.makeLiteral(this.b), this.a, false);
    }
}

