/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAccept;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.CompoundMode;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public class XSLUsePackage
extends StyleElement {
    private String a = null;
    private PackageVersionRanges b = null;
    private StylesheetPackage c;
    private List<XSLAccept> d = null;

    public void findUsedPackage(CompilerInfo object) {
        if (this.c == null) {
            PackageDetails packageDetails;
            if (this.a == null) {
                this.a = Whitespace.trim(((NodeImpl)this).getAttributeValue("", "name"));
            }
            if (this.a == null) {
                this.reportAbsence("name");
                this.a = "unnamed-package";
            }
            StylesheetPackage stylesheetPackage = this.c = (packageDetails = ((CompilerInfo)object).getPackageLibrary().findPackage(this.a, this.getPackageVersionRanges())) == null ? null : packageDetails.loadedPackage;
            if (this.c == null) {
                this.compileErrorInAttribute("Package " + this.a + " could not be found", "XTSE3000", "name");
                this.c = ((NodeImpl)this).getConfiguration().makeStylesheetPackage();
                this.c.setJustInTimeCompilation(((CompilerInfo)object).isJustInTimeCompilation());
            }
            if ((object = this.c.getContextItemRequirements()) != null && !((GlobalContextRequirement)object).isMayBeOmitted()) {
                this.compileError("Package " + this.getAttributeValue("name") + " requires a global context item, so it cannot be used as a library package", "XTTE0590");
            }
        }
    }

    @Override
    public StylesheetPackage getUsedPackage() {
        return this.c;
    }

    public PackageVersionRanges getPackageVersionRanges() {
        if (this.b == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                this.b = new PackageVersionRanges("*");
            }
        }
        return this.b;
    }

    @Override
    protected void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = "*";
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("name")) {
                this.a = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string2.equals("package-version")) {
                string = Whitespace.trim(attributeCollection.getValue(i2)).replaceAll("\\\\", "");
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        this.b = new PackageVersionRanges(string);
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        object = this.iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo.getNodeKind() == 3) {
                this.compileError("Character content is not allowed as a child of xsl:use-package");
                continue;
            }
            if (nodeInfo instanceof XSLAccept || nodeInfo instanceof XSLOverride) continue;
            this.compileError("Child element " + Err.wrap(nodeInfo.getDisplayName(), 1) + " is not allowed as a child of xsl:use-package", "XTSE0010");
        }
    }

    public Set<SymbolicName> getExplicitAcceptedComponentNames() {
        Object object;
        HashSet<SymbolicName> hashSet = new HashSet<SymbolicName>();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            if (!(object instanceof XSLAccept)) continue;
            object = ((XSLAccept)object).getExplicitComponentTests();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ComponentTest)object.next();
                object2 = ((ComponentTest)object2).getSymbolicNameIfExplicit();
                hashSet.add((SymbolicName)object2);
            }
        }
        return hashSet;
    }

    @Override
    public void postValidate() {
        Object object;
        Object object2 = this.iterateAxis((byte)3);
        while ((object = object2.next()) != null) {
            if (!(object instanceof XSLOverride) && !(object instanceof XSLAccept)) continue;
            ((StyleElement)object).postValidate();
        }
        object2 = this.getExplicitAcceptedComponentNames();
        object = this.getNamedOverrides();
        if (!object2.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                SymbolicName.F f2;
                SymbolicName symbolicName = (SymbolicName)object.next();
                if (object2.contains(symbolicName)) {
                    this.compileError("Cannot accept and override the same component (" + symbolicName + ")", "XTSE3051");
                }
                if (symbolicName.getComponentKind() != 158 || !object2.contains(f2 = new SymbolicName.F(symbolicName.getComponentName(), -1))) continue;
                this.compileError("Cannot accept and override the same function (" + symbolicName + ")", "XTSE3051");
            }
        }
    }

    public List<XSLAccept> getAcceptors() {
        if (this.d == null) {
            NodeInfo nodeInfo;
            this.d = new ArrayList<XSLAccept>();
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLAccept)) continue;
                this.d.add((XSLAccept)nodeInfo);
            }
        }
        return this.d;
    }

    public void gatherNamedOverrides(PrincipalStylesheetModule principalStylesheetModule, List<ComponentDeclaration> list, Set<SymbolicName> set) {
        Object object;
        if (this.c == null) {
            return;
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((object = axisIterator.next()) != null) {
            StructuredQName[] structuredQNameArray;
            if (!(object instanceof XSLOverride)) continue;
            object = object.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((structuredQNameArray = object.next()) != null) {
                if (!(structuredQNameArray instanceof StylesheetComponent)) continue;
                Object object2 = new ComponentDeclaration(principalStylesheetModule, (StyleElement)structuredQNameArray);
                list.add((ComponentDeclaration)object2);
                object2 = ((StylesheetComponent)structuredQNameArray).getSymbolicName();
                if (object2 != null) {
                    set.add((SymbolicName)object2);
                    continue;
                }
                if (!(structuredQNameArray instanceof XSLTemplate) || structuredQNameArray.getAttributeValue("", "match") == null) continue;
                StructuredQName[] structuredQNameArray2 = ((XSLTemplate)structuredQNameArray).getModeNames();
                structuredQNameArray = structuredQNameArray2;
                structuredQNameArray = structuredQNameArray2;
                int n2 = structuredQNameArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    StructuredQName structuredQName = structuredQNameArray[i2];
                    set.add(new SymbolicName(174, structuredQName));
                }
            }
        }
    }

    public Set<SymbolicName> getNamedOverrides() {
        Object object;
        HashSet<SymbolicName> hashSet = new HashSet<SymbolicName>();
        AxisIterator axisIterator = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((object = axisIterator.next()) != null) {
            Object object2;
            if (!(object instanceof XSLOverride)) continue;
            object = object.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((object2 = object.next()) != null) {
                if (!(object2 instanceof StylesheetComponent) || (object2 = ((StylesheetComponent)object2).getSymbolicName()) == null) continue;
                hashSet.add((SymbolicName)object2);
            }
        }
        return hashSet;
    }

    public void gatherRuleOverrides(PrincipalStylesheetModule object, Set<SymbolicName> set) {
        Object object2;
        StylesheetPackage stylesheetPackage = ((PrincipalStylesheetModule)object).getStylesheetPackage();
        object = ((PrincipalStylesheetModule)object).getRuleManager();
        AxisIterator axisIterator = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        HashSet<SymbolicName> hashSet = new HashSet<SymbolicName>();
        while ((object2 = axisIterator.next()) != null) {
            Object object3;
            if (!(object2 instanceof XSLOverride)) continue;
            object2 = object2.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((object3 = object2.next()) != null) {
                StructuredQName[] structuredQNameArray;
                if (!(object3 instanceof XSLTemplate) || object3.getAttributeValue("", "match") == null) continue;
                StructuredQName[] structuredQNameArray2 = structuredQNameArray = ((XSLTemplate)object3).getModeNames();
                int n2 = structuredQNameArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object4 = structuredQNameArray2[i2];
                    if (((StructuredQName)object4).equals(Mode.OMNI_MODE)) {
                        ((StyleElement)object3).compileError("The mode name #all must not appear in an overriding template rule", "XTSE3440");
                        continue;
                    }
                    Object object5 = new SymbolicName(174, (StructuredQName)object4);
                    set.add((SymbolicName)object5);
                    hashSet.add((SymbolicName)object5);
                    object5 = (Component.M)stylesheetPackage.getComponent((SymbolicName)object5);
                    if (object5 == null) {
                        ((StyleElement)object3).compileError("Mode " + ((StructuredQName)object4).getDisplayName() + " is not defined in the used package", "XTSE3060");
                        continue;
                    }
                    if (((Component)object5).getBaseComponent() == null) {
                        ((StyleElement)object3).compileError("Mode " + ((StructuredQName)object4).getDisplayName() + " cannot be overridden because it is local to this package", "XTSE3440");
                        continue;
                    }
                    Component.M m2 = (Component.M)((Component)object5).getBaseComponent();
                    if (m2.getVisibility() == Visibility.FINAL) {
                        ((StyleElement)object3).compileError("Cannot define overriding template rules in mode " + ((StructuredQName)object4).getDisplayName() + " because it has visibility=final", "XTSE3060");
                        continue;
                    }
                    Mode mode = m2.getActor();
                    if (m2.getVisibility() != Visibility.PUBLIC) {
                        ((StyleElement)object3).compileError("Cannot override template rules in mode " + ((StructuredQName)object4).getDisplayName() + ", because the mode is not public", "XTSE3060");
                        continue;
                    }
                    if (((Component.M)object5).getActor() != mode) continue;
                    object4 = new SimpleMode((StructuredQName)object4);
                    object4 = new CompoundMode(mode, (SimpleMode)object4);
                    ((Actor)object4).setDeclaringComponent((Component)object5);
                    ((RuleManager)object).registerMode((Mode)object4);
                    ((Component.M)object5).setActor((Mode)object4);
                }
            }
        }
        object2 = this.c.getRuleManager();
        if (object2 != null) {
            for (Mode mode : ((RuleManager)object2).getAllNamedModes()) {
                Component component;
                SymbolicName symbolicName = ((Actor)mode).getSymbolicName();
                if (hashSet.contains(symbolicName) || (component = stylesheetPackage.getComponent(symbolicName)) == null || component.getVisibility() == Visibility.PRIVATE) continue;
                ((RuleManager)object).registerMode((Mode)component.getActor());
            }
        }
    }
}

