/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;

public class IndependentContext
extends AbstractStaticContext
implements NamespaceResolver,
XPathStaticContext {
    protected HashMap<String, String> namespaces = new HashMap(10);
    protected HashMap<StructuredQName, XPathVariable> variables = new HashMap(20);
    protected NamespaceResolver externalResolver = null;
    protected ItemType requiredContextItemType = AnyItemType.getInstance();
    protected Set<String> importedSchemaNamespaces = new HashSet<String>();
    protected boolean autoDeclare = false;
    protected Executable executable;
    protected RetainedStaticContext retainedStaticContext;
    protected OptimizerOptions optimizerOptions;

    public IndependentContext() {
        this(new Configuration());
    }

    public IndependentContext(Configuration object) {
        this.setConfiguration((Configuration)object);
        this.clearNamespaces();
        this.setDefaultFunctionLibrary(31);
        this.usingDefaultFunctionLibrary = true;
        this.setDefaultCollationName(((Configuration)object).getDefaultCollationName());
        this.setOptimizerOptions(((Configuration)object).getOptimizerOptions());
        object = new PackageData((Configuration)object);
        ((PackageData)object).setHostLanguage(54);
        ((PackageData)object).setSchemaAware(false);
        this.setPackageData((PackageData)object);
    }

    public IndependentContext(IndependentContext independentContext) {
        this(independentContext.getConfiguration());
        this.setPackageData(independentContext.getPackageData());
        this.setBaseURI(independentContext.getStaticBaseURI());
        this.setContainingLocation(independentContext.getContainingLocation());
        ((AbstractStaticContext)this).setDefaultElementNamespace(independentContext.getDefaultElementNamespace());
        this.setDefaultFunctionNamespace(independentContext.getDefaultFunctionNamespace());
        this.setBackwardsCompatibilityMode(independentContext.isInBackwardsCompatibleMode());
        this.namespaces = new HashMap<String, String>(independentContext.namespaces);
        this.variables = new HashMap(10);
        FunctionLibraryList functionLibraryList = (FunctionLibraryList)independentContext.getFunctionLibrary();
        if (functionLibraryList != null) {
            this.setFunctionLibrary((FunctionLibraryList)functionLibraryList.copy());
        }
        this.setImportedSchemaNamespaces(independentContext.importedSchemaNamespaces);
        this.externalResolver = independentContext.externalResolver;
        this.autoDeclare = independentContext.autoDeclare;
        this.setXPathLanguageLevel(independentContext.getXPathVersion());
        this.requiredContextItemType = independentContext.requiredContextItemType;
        this.setExecutable(independentContext.getExecutable());
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        if (this.retainedStaticContext == null) {
            this.retainedStaticContext = new RetainedStaticContext(this);
        }
        return this.retainedStaticContext;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if ("".equals(string)) {
            ((AbstractStaticContext)this).setDefaultElementNamespace(string2);
            return;
        }
        this.namespaces.put(string, string2);
    }

    @Override
    public void setDefaultElementNamespace(String string) {
        if (string == null) {
            string = "";
        }
        super.setDefaultElementNamespace(string);
        this.namespaces.put("", string);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo object) {
        this.namespaces.clear();
        int n2 = object.getNodeKind();
        if (n2 == 2 || n2 == 3 || n2 == 8 || n2 == 7 || n2 == 13) {
            object = object.getParent();
        }
        if (object == null) {
            return;
        }
        object = object.iterateAxis((byte)8);
        NodeInfo nodeInfo;
        while ((nodeInfo = object.next()) != null) {
            String string = nodeInfo.getLocalPart();
            if ("".equals(string)) {
                ((AbstractStaticContext)this).setDefaultElementNamespace(nodeInfo.getStringValue());
                continue;
            }
            this.declareNamespace(nodeInfo.getLocalPart(), nodeInfo.getStringValue());
        }
        return;
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.externalResolver = namespaceResolver;
    }

    public void setAllowUndeclaredVariables(boolean bl2) {
        this.autoDeclare = bl2;
    }

    public boolean isAllowUndeclaredVariables() {
        return this.autoDeclare;
    }

    @Override
    public XPathVariable declareVariable(QNameValue qNameValue) {
        return this.declareVariable(qNameValue.getStructuredQName());
    }

    @Override
    public XPathVariable declareVariable(String object, String string) {
        object = new StructuredQName("", (String)object, string);
        return this.declareVariable((StructuredQName)object);
    }

    public XPathVariable declareVariable(StructuredQName structuredQName) {
        XPathVariable xPathVariable = this.variables.get(structuredQName);
        if (xPathVariable != null) {
            return xPathVariable;
        }
        xPathVariable = XPathVariable.make(structuredQName);
        int n2 = this.variables.size();
        xPathVariable.setSlotNumber(n2);
        this.variables.put(structuredQName, xPathVariable);
        return xPathVariable;
    }

    public Iterator<XPathVariable> iterateExternalVariables() {
        return this.variables.values().iterator();
    }

    public XPathVariable getExternalVariable(StructuredQName structuredQName) {
        return this.variables.get(structuredQName);
    }

    public int getSlotNumber(QNameValue object) {
        object = ((QualifiedNameValue)object).getStructuredQName();
        if ((object = this.variables.get(object)) == null) {
            return -1;
        }
        return ((XPathVariable)object).getLocalSlotNumber();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.externalResolver != null) {
            return this.externalResolver;
        }
        return this;
    }

    @Override
    public String getURIForPrefix(String string, boolean bl2) {
        if (this.externalResolver != null) {
            return this.externalResolver.getURIForPrefix(string, bl2);
        }
        if (string.isEmpty()) {
            if (bl2) {
                return this.getDefaultElementNamespace();
            }
            return "";
        }
        return this.namespaces.get(string);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        if (this.externalResolver != null) {
            return this.externalResolver.iteratePrefixes();
        }
        return this.namespaces.keySet().iterator();
    }

    @Override
    public Expression bindVariable(StructuredQName structuredQName) {
        XPathVariable xPathVariable = this.variables.get(structuredQName);
        if (xPathVariable == null) {
            if (this.autoDeclare) {
                return new LocalVariableReference(this.declareVariable(structuredQName));
            }
            throw new XPathException("Undeclared variable in XPath expression: $" + structuredQName.getClarkName(), "XPST0008");
        }
        return new LocalVariableReference(xPathVariable);
    }

    @Override
    public SlotManager getStackFrameMap() {
        SlotManager slotManager = this.getConfiguration().makeSlotManager();
        XPathVariable[] xPathVariableArray = new XPathVariable[this.variables.size()];
        XPathVariable[] xPathVariableArray2 = this.variables.values().iterator();
        while (xPathVariableArray2.hasNext()) {
            XPathVariable xPathVariable;
            xPathVariableArray[xPathVariable.getLocalSlotNumber()] = xPathVariable = xPathVariableArray2.next();
        }
        xPathVariableArray2 = xPathVariableArray;
        int n2 = xPathVariableArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            XPathVariable xPathVariable = xPathVariableArray2[i2];
            slotManager.allocateSlotNumber(xPathVariable.getVariableQName());
        }
        return slotManager;
    }

    public Collection<XPathVariable> getDeclaredVariables() {
        return this.variables.values();
    }

    @Override
    public boolean isImportedSchema(String string) {
        return this.importedSchemaNamespaces.contains(string);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.importedSchemaNamespaces;
    }

    public void setImportedSchemaNamespaces(Set<String> set) {
        this.importedSchemaNamespaces = set;
        if (!set.isEmpty()) {
            this.setSchemaAware(true);
        }
    }

    public void setRequiredContextItemType(ItemType itemType) {
        this.requiredContextItemType = itemType;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void setOptimizerOptions(OptimizerOptions optimizerOptions) {
        this.optimizerOptions = optimizerOptions;
    }

    @Override
    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }
}

