/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XPathDynamicContext {
    private ItemType a;
    private XPathContextMajor b;
    private SlotManager c;

    protected XPathDynamicContext(ItemType itemType, XPathContextMajor xPathContextMajor, SlotManager slotManager) {
        this.a = itemType;
        this.b = xPathContextMajor;
        this.c = slotManager;
    }

    public void setContextItem(Item<?> object) {
        if (object instanceof NodeInfo && !((NodeInfo)object).getConfiguration().isCompatible(this.b.getConfiguration())) {
            throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
        }
        TypeHierarchy typeHierarchy = this.b.getConfiguration().getTypeHierarchy();
        if (!this.a.matches((Item)object, typeHierarchy)) {
            throw new XPathException("Supplied context item does not match required context item type " + this.a);
        }
        object = new ManualIterator((Item<?>)object);
        this.b.setCurrentIterator((FocusIterator<?>)object);
    }

    public Item getContextItem() {
        return this.b.getContextItem();
    }

    public void setVariable(XPathVariable xPathVariable, Sequence<?> sequence) {
        Object t2;
        Object object = xPathVariable.getRequiredType();
        if (object != SequenceType.ANY_SEQUENCE && (object = TypeChecker.testConformance(sequence, (SequenceType)object, this.b)) != null) {
            throw object;
        }
        object = sequence.iterate();
        while ((t2 = object.next()) != null) {
            if (!(t2 instanceof NodeInfo) || ((NodeInfo)t2).getConfiguration().isCompatible(this.b.getConfiguration())) continue;
            throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
        }
        int n2 = xPathVariable.getLocalSlotNumber();
        StructuredQName structuredQName = t2 = n2 >= this.c.getNumberOfVariables() ? null : this.c.getVariableMap().get(n2);
        if (!xPathVariable.getVariableQName().equals(t2)) {
            throw new XPathException("Supplied XPathVariable is bound to the wrong slot: perhaps it was created using a different static context");
        }
        this.b.setLocalVariable(n2, sequence);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.b.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return ((XPathContextMinor)this.b).getURIResolver();
    }

    public void setCollectionURIResolver(CollectionURIResolver collectionURIResolver) {
        this.b.getController().setCollectionURIResolver(collectionURIResolver);
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.b.getController().getCollectionURIResolver();
    }

    public CollectionFinder getCollectionFinder() {
        return this.b.getController().getCollectionFinder();
    }

    public void setCollectionFinder(CollectionFinder collectionFinder) {
        this.b.getController().setCollectionFinder(collectionFinder);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.b.setErrorListener(errorListener);
    }

    public UnfailingErrorListener getErrorListener() {
        return ((XPathContextMinor)this.b).getErrorListener();
    }

    public XPathContext getXPathContextObject() {
        return this.b;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.b.getController().setUnparsedTextURIResolver(unparsedTextURIResolver);
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.b.getController().getUnparsedTextURIResolver();
    }

    protected void checkExternalVariables(SlotManager object, int n2) {
        Sequence<?>[] sequenceArray = this.b.getStackFrame().getStackFrameValues();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (sequenceArray[i2] != null) continue;
            object = ((SlotManager)object).getVariableMap().get(i2);
            throw new XPathException("No value has been supplied for variable $" + ((StructuredQName)object).getDisplayName());
        }
    }
}

