/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener2;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.Whitespace;

public abstract class AbstractTraceListener
implements TraceListener2 {
    protected int indent = 0;
    private int a = 2;
    protected Logger out = new StandardLogger();
    private static StringBuffer b = new StringBuffer("                ");

    public CodeInjector getCodeInjector() {
        return new TraceCodeInjector();
    }

    public void setLevelOfDetail(int n2) {
        this.a = n2;
    }

    @Override
    public void open(Controller controller) {
        this.out.info("<trace saxon-version=\"" + Version.getProductVersion() + "\" " + this.getOpeningAttributes() + '>');
        ++this.indent;
    }

    protected abstract String getOpeningAttributes();

    @Override
    public void close() {
        --this.indent;
        this.out.info("</trace>");
    }

    @Override
    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        int n2 = instructionInfo.getConstructType();
        Object object = instructionInfo.getObjectName();
        String string = this.tag(n2);
        if (this.level(instructionInfo) > this.a || string == null) {
            return;
        }
        String string2 = StandardErrorListener.abbreviatePath(instructionInfo.getSystemId());
        string = AbstractTraceListener.spaces(this.indent) + '<' + string;
        String string3 = (String)instructionInfo.getProperty("name");
        if (string3 != null) {
            string = string + " name=\"" + this.escape(string3) + '\"';
        } else if (object != null) {
            string = string + " name=\"" + this.escape(((StructuredQName)object).getDisplayName()) + '\"';
        }
        object = instructionInfo.getProperties();
        while (object.hasNext()) {
            int n3;
            string3 = (String)object.next();
            Object object2 = instructionInfo.getProperty(string3);
            if (string3.startsWith("{") && (n3 = string3.indexOf(125)) > 0) {
                string3 = string3.substring(n3 + 1);
            }
            if (object2 == null || string3.equals("name") || string3.equals("expression")) continue;
            string = string + ' ' + string3 + "=\"" + this.escape(object2.toString()) + '\"';
        }
        string = string + " line=\"" + instructionInfo.getLineNumber() + '\"';
        int n4 = instructionInfo.getColumnNumber();
        if (n4 >= 0) {
            string = string + " column=\"" + instructionInfo.getColumnNumber() + '\"';
        }
        string = string + " module=\"" + this.escape(string2) + "\">";
        this.out.info(string);
        ++this.indent;
    }

    public String escape(String charSequence) {
        if (charSequence == null) {
            return "";
        }
        charSequence = Whitespace.collapseWhitespace(charSequence);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() + 10);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '<') {
                fastStringBuffer.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                fastStringBuffer.append("&gt;");
                continue;
            }
            if (c2 == '&') {
                fastStringBuffer.append("&amp;");
                continue;
            }
            if (c2 == '\"') {
                fastStringBuffer.append("&#34;");
                continue;
            }
            if (c2 == '\n') {
                fastStringBuffer.append("&#xA;");
                continue;
            }
            if (c2 == '\r') {
                fastStringBuffer.append("&#xD;");
                continue;
            }
            if (c2 == '\t') {
                fastStringBuffer.append("&#x9;");
                continue;
            }
            fastStringBuffer.append(c2);
        }
        return fastStringBuffer.toString();
    }

    @Override
    public void leave(InstructionInfo instructionInfo) {
        int n2 = instructionInfo.getConstructType();
        String string = this.tag(n2);
        if (this.level(instructionInfo) > this.a || string == null) {
            return;
        }
        --this.indent;
        this.out.info(AbstractTraceListener.spaces(this.indent) + "</" + string + '>');
    }

    protected abstract String tag(int var1);

    protected int level(InstructionInfo instructionInfo) {
        int n2 = instructionInfo.getConstructType();
        if (n2 == 158 || n2 == 200) {
            return 1;
        }
        if (instructionInfo instanceof Instruction) {
            return 2;
        }
        return 3;
    }

    @Override
    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo && this.a > 0) {
            item = (NodeInfo)item;
            this.out.info(AbstractTraceListener.spaces(this.indent) + "<source node=\"" + Navigator.getPath((NodeInfo)item) + "\" line=\"" + item.getLineNumber() + "\" file=\"" + StandardErrorListener.abbreviatePath(item.getSystemId()) + "\">");
        }
        ++this.indent;
    }

    @Override
    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo && this.a > 0) {
            item = (NodeInfo)item;
            this.out.info(AbstractTraceListener.spaces(this.indent) + "</source><!-- " + Navigator.getPath((NodeInfo)item) + " -->");
        }
    }

    protected static String spaces(int n2) {
        while (b.length() < n2) {
            StringBuffer stringBuffer = b;
            stringBuffer.append(stringBuffer);
        }
        return b.substring(0, n2);
    }

    @Override
    public void setOutputDestination(Logger logger) {
        this.out = logger;
    }

    public Logger getOutputDestination() {
        return this.out;
    }

    @Override
    public void endRuleSearch(Object object, Mode mode, Item item) {
    }

    @Override
    public void startRuleSearch() {
    }
}

