/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AtomicValue;

public abstract class ContextStackFrame {
    private XPathContext a;
    private Location b;
    private Item c;
    private Object d;

    public void setLocation(Location location) {
        this.b = location;
    }

    public String getSystemId() {
        return this.b.getSystemId();
    }

    public int getLineNumber() {
        return this.b.getLineNumber();
    }

    public void setComponent(Object object) {
        this.d = object;
    }

    public Object getContainer() {
        return this.d;
    }

    public void setContext(XPathContext xPathContext) {
        this.a = xPathContext;
    }

    public XPathContext getContext() {
        return this.a;
    }

    public void setContextItem(Item item) {
        this.c = item;
    }

    public Item getContextItem() {
        return this.c;
    }

    public abstract void print(Logger var1);

    protected String showLocation() {
        if (this.getSystemId() == null) {
            return "";
        }
        int n2 = this.getLineNumber();
        if (n2 == -1 || n2 == 1048575) {
            return "(" + this.getSystemId() + ")";
        }
        return "(" + this.getSystemId() + "#" + this.getLineNumber() + ")";
    }

    static /* synthetic */ String a(Object object) {
        if (object instanceof Actor) {
            Object object2 = ((Actor)object).getObjectName();
            Object object3 = object2 = object2 == null ? "" : ((StructuredQName)object2).getDisplayName();
            if (object instanceof NamedTemplate) {
                return "template name=\"" + (String)object2 + "\"";
            }
            if (object instanceof UserFunction) {
                return "function " + (String)object2 + "()";
            }
            if (object instanceof AttributeSet) {
                return "attribute-set " + (String)object2;
            }
            if (object instanceof KeyDefinition) {
                return "key " + (String)object2;
            }
            if (object instanceof GlobalVariable) {
                if (((StructuredQName)(object = ((GlobalVariable)object).getVariableQName())).hasURI("http://saxon.sf.net/generated-variable")) {
                    return "optimizer-created global variable";
                }
                return "global variable $" + ((StructuredQName)object).getDisplayName();
            }
        } else if (object instanceof TemplateRule) {
            return "template match=\"" + ((Expression)((TemplateRule)object).getMatchPattern()).toString() + "\"";
        }
        return "";
    }

    public static class VariableEvaluation
    extends ContextStackFrame {
        private StructuredQName a;

        public StructuredQName getVariableName() {
            return this.a;
        }

        public void setVariableName(StructuredQName structuredQName) {
            this.a = structuredQName;
        }

        @Override
        public void print(Logger logger) {
            logger.error("  in " + ContextStackFrame.a(this.getContainer()) + " " + this.showLocation());
        }
    }

    public static class CallTemplate
    extends ContextStackFrame {
        private StructuredQName a;

        public StructuredQName getTemplateName() {
            return this.a;
        }

        public void setTemplateName(StructuredQName structuredQName) {
            this.a = structuredQName;
        }

        @Override
        public void print(Logger logger) {
            String string = this.a == null ? "??" : this.a.getDisplayName();
            logger.error("  at xsl:call-template name=\"" + string + "\" " + this.showLocation());
        }
    }

    public static class ApplyTemplates
    extends ContextStackFrame {
        @Override
        public void print(Logger logger) {
            logger.error("  at xsl:apply-templates " + this.showLocation());
            Item item = this.getContextItem();
            if (item instanceof NodeInfo) {
                logger.error("     processing " + Navigator.getPath((NodeInfo)item));
            }
        }
    }

    public static class FunctionCall
    extends ContextStackFrame {
        private StructuredQName a;

        public StructuredQName getFunctionName() {
            return this.a;
        }

        public void setFunctionName(StructuredQName structuredQName) {
            this.a = structuredQName;
        }

        @Override
        public void print(Logger logger) {
            logger.error("  at " + (this.a == null ? "(anonymous)" : this.a.getDisplayName()) + "() " + this.showLocation());
        }
    }

    public static class BuiltInTemplateRule
    extends ContextStackFrame {
        private XPathContext a;

        public BuiltInTemplateRule(XPathContext xPathContext) {
            this.a = xPathContext;
        }

        @Override
        public void print(Logger logger) {
            Item<?> item = this.a.getContextItem();
            item = item instanceof NodeInfo ? Navigator.getPath((NodeInfo)item) : (item instanceof AtomicValue ? "value " + item.toString() : (item instanceof MapItem ? "map" : (item instanceof ArrayItem ? "array" : (item instanceof Function ? "function" : "item"))));
            logger.error("  in built-in template rule for " + (String)((Object)item) + " in " + this.a.getCurrentMode().getActor().getModeTitle().toLowerCase());
        }
    }

    public static class CallingApplication
    extends ContextStackFrame {
        @Override
        public void print(Logger logger) {
        }
    }
}

