/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.trace.ContextStackFrame;
import net.sf.saxon.trans.rules.BuiltInRuleSet;

public class ContextStackIterator
implements Iterator<ContextStackFrame> {
    private XPathContextMajor a;

    public ContextStackIterator(XPathContext xPathContext) {
        if (!(xPathContext instanceof XPathContextMajor)) {
            xPathContext = ContextStackIterator.a(xPathContext);
        }
        this.a = (XPathContextMajor)xPathContext;
    }

    @Override
    public boolean hasNext() {
        return this.a != null;
    }

    @Override
    public ContextStackFrame next() {
        XPathContextMajor xPathContextMajor = this.a;
        if (xPathContextMajor == null) {
            return null;
        }
        ContextOriginator contextOriginator = xPathContextMajor.getOrigin();
        if (contextOriginator instanceof Controller) {
            this.a = ContextStackIterator.a(xPathContextMajor);
            return new ContextStackFrame.CallingApplication();
        }
        if (contextOriginator instanceof BuiltInRuleSet) {
            this.a = ContextStackIterator.a(xPathContextMajor);
            return new ContextStackFrame.BuiltInTemplateRule(xPathContextMajor);
        }
        if (contextOriginator instanceof UserFunction) {
            ContextStackFrame.FunctionCall functionCall = new ContextStackFrame.FunctionCall();
            contextOriginator = (UserFunction)contextOriginator;
            functionCall.setLocation(((Actor)((Object)contextOriginator)).getLocation());
            functionCall.setFunctionName(((UserFunction)contextOriginator).getFunctionName());
            functionCall.setContextItem(xPathContextMajor.getContextItem());
            functionCall.setContext(xPathContextMajor);
            this.a = ContextStackIterator.a(xPathContextMajor);
            return functionCall;
        }
        if (contextOriginator instanceof UserFunctionCall) {
            ContextStackFrame.FunctionCall functionCall = new ContextStackFrame.FunctionCall();
            contextOriginator = (UserFunctionCall)contextOriginator;
            functionCall.setLocation(((Expression)((Object)contextOriginator)).getLocation());
            functionCall.setFunctionName(((FunctionCall)((Object)contextOriginator)).getFunctionName());
            functionCall.setContextItem(xPathContextMajor.getContextItem());
            functionCall.setContext(xPathContextMajor);
            this.a = ContextStackIterator.a(xPathContextMajor);
            return functionCall;
        }
        if (contextOriginator instanceof ApplyTemplates) {
            ContextStackFrame.ApplyTemplates applyTemplates = new ContextStackFrame.ApplyTemplates();
            contextOriginator = (ApplyTemplates)contextOriginator;
            applyTemplates.setLocation(((Expression)((Object)contextOriginator)).getLocation());
            applyTemplates.setContextItem(xPathContextMajor.getContextItem());
            applyTemplates.setContext(xPathContextMajor);
            this.a = ContextStackIterator.a(xPathContextMajor);
            return applyTemplates;
        }
        if (contextOriginator instanceof CallTemplate) {
            ContextStackFrame.CallTemplate callTemplate = new ContextStackFrame.CallTemplate();
            contextOriginator = (CallTemplate)contextOriginator;
            callTemplate.setLocation(((Expression)((Object)contextOriginator)).getLocation());
            callTemplate.setTemplateName(((Expression)((Object)contextOriginator)).getObjectName());
            callTemplate.setContextItem(xPathContextMajor.getContextItem());
            callTemplate.setContext(xPathContextMajor);
            this.a = ContextStackIterator.a(xPathContextMajor);
            return callTemplate;
        }
        if (contextOriginator instanceof GlobalVariable) {
            ContextStackFrame.VariableEvaluation variableEvaluation = new ContextStackFrame.VariableEvaluation();
            contextOriginator = (GlobalVariable)contextOriginator;
            variableEvaluation.setLocation(((Actor)((Object)contextOriginator)).getLocation());
            variableEvaluation.setContextItem(xPathContextMajor.getContextItem());
            variableEvaluation.setVariableName(((GlobalVariable)contextOriginator).getVariableQName());
            variableEvaluation.setComponent(contextOriginator);
            variableEvaluation.setContext(xPathContextMajor);
            this.a = ContextStackIterator.a(xPathContextMajor);
            return variableEvaluation;
        }
        this.a = ContextStackIterator.a(xPathContextMajor);
        ContextStackFrame contextStackFrame = this.next();
        if (contextStackFrame == null) {
            return new ContextStackFrame.CallingApplication();
        }
        return contextStackFrame;
    }

    private static XPathContextMajor a(XPathContext xPathContext) {
        for (xPathContext = xPathContext.getCaller(); xPathContext != null && !(xPathContext instanceof XPathContextMajor); xPathContext = xPathContext.getCaller()) {
        }
        return (XPathContextMajor)xPathContext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

