/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.CheckSumFilter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class ExpressionPresenter {
    private Configuration a;
    private Receiver b;
    private int c;
    private boolean d;
    private String e;
    private Stack<Expression> f;
    private Stack<String> g;
    private String h;
    private Options i;
    private boolean j;

    public ExpressionPresenter() {
        this.c = 0;
        this.d = false;
        this.e = null;
        this.f = new Stack();
        this.g = new Stack();
        this.i = new ExportOptions();
        this.j = false;
    }

    public ExpressionPresenter(Configuration configuration) {
        Configuration configuration2 = configuration;
        this(configuration2, configuration2.getLogger());
    }

    public ExpressionPresenter(Configuration configuration, StreamResult streamResult) {
        this(configuration, streamResult, false);
    }

    public ExpressionPresenter(Configuration configuration, StreamResult streamResult, boolean bl2) {
        this.c = 0;
        this.d = false;
        this.e = null;
        this.f = new Stack();
        this.g = new Stack();
        this.i = new ExportOptions();
        this.j = false;
        this.init(configuration, streamResult, bl2);
    }

    public void init(Configuration object, StreamResult streamResult, boolean bl2) {
        SerializationProperties serializationProperties = ExpressionPresenter.makeDefaultProperties((Configuration)object);
        if (((Configuration)object).getXMLVersion() == 11) {
            if ("JS".equals(((ExportOptions)this.getOptions()).target)) {
                ((Configuration)object).getLogger().warning("For target=JS, the SEF file will use XML 1.0, which disallows control characters");
            } else {
                serializationProperties.setProperty("version", "1.1");
            }
        }
        try {
            this.b = ((Configuration)object).getSerializerFactory().getReceiver(streamResult, serializationProperties);
            this.b = new NamespaceReducer(this.b);
            if (bl2) {
                this.b = new CheckSumFilter(this.b);
            }
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
        this.a = object;
        try {
            this.b.open();
            this.b.startDocument(0);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
    }

    public void init(Configuration object, Receiver receiver, boolean bl2) {
        this.b = receiver;
        this.b = new NamespaceReducer(this.b);
        if (bl2) {
            this.b = new CheckSumFilter(this.b);
        }
        this.a = object;
        try {
            this.b.open();
            this.b.startDocument(0);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
    }

    public ExpressionPresenter(Configuration configuration, Logger logger) {
        this(configuration, logger.asStreamResult());
    }

    public ExpressionPresenter(Configuration object, Receiver receiver) {
        this.c = 0;
        this.d = false;
        this.e = null;
        this.f = new Stack();
        this.g = new Stack();
        this.i = new ExportOptions();
        this.j = false;
        this.a = object;
        this.b = receiver;
        try {
            receiver.open();
            receiver.startDocument(0);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
    }

    public void setDefaultNamespace(String string) {
        this.h = string;
    }

    public void setOptions(Options options) {
        this.i = options;
    }

    public Options getOptions() {
        return this.i;
    }

    public boolean isRelocatable() {
        return this.j;
    }

    public void setRelocatable(boolean bl2) {
        this.j = bl2;
    }

    public static Receiver defaultDestination(Configuration configuration, Logger logger) {
        SerializationProperties serializationProperties = ExpressionPresenter.makeDefaultProperties(configuration);
        return configuration.getSerializerFactory().getReceiver(logger.asStreamResult(), serializationProperties);
    }

    public static SerializationProperties makeDefaultProperties(Configuration configuration) {
        SerializationProperties serializationProperties = new SerializationProperties();
        serializationProperties.setProperty("method", "xml");
        serializationProperties.setProperty("indent", "yes");
        if (configuration.isLicensedFeature(8)) {
            serializationProperties.setProperty("{http://saxon.sf.net/}indent-spaces", "1");
            serializationProperties.setProperty("{http://saxon.sf.net/}line-length", "4096");
        }
        serializationProperties.setProperty("omit-xml-declaration", "no");
        serializationProperties.setProperty("encoding", "utf-8");
        serializationProperties.setProperty("version", "1.0");
        serializationProperties.setProperty("{http://saxon.sf.net/}single-quotes", "yes");
        return serializationProperties;
    }

    public int startElement(String string, Expression expression) {
        String string2;
        Expression expression2 = this.f.isEmpty() ? null : this.f.peek();
        this.f.push(expression);
        this.g.push("*" + string);
        int n2 = this.b(string);
        if (expression2 == null || expression.getRetainedStaticContext() != expression2.getRetainedStaticContext()) {
            if (expression.getRetainedStaticContext() == null) {
                throw new AssertionError((Object)("Export failure: no retained static context on " + expression.toShortString()));
            }
            this.emitRetainedStaticContext(expression.getRetainedStaticContext(), expression2 == null ? null : expression2.getRetainedStaticContext());
        }
        if (!((string2 = expression.getLocation().getSystemId()) == null || expression2 == null || expression2.getLocation().getSystemId() != null && expression2.getLocation().getSystemId().equals(string2))) {
            this.emitAttribute("module", this.a(string2));
        }
        int n3 = expression.getLocation().getLineNumber();
        if (expression2 == null || expression2.getLocation().getLineNumber() != n3 && n3 != -1) {
            this.emitAttribute("line", "" + n3);
        }
        return n2;
    }

    private String a(String string) {
        if (!this.j) {
            return string;
        }
        String[] stringArray = string.split("/");
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            if (stringArray[i2].isEmpty()) continue;
            return stringArray[i2];
        }
        return string;
    }

    public void emitRetainedStaticContext(RetainedStaticContext retainedStaticContext, RetainedStaticContext object) {
        try {
            if (!(((ExportOptions)this.i).suppressStaticContext || this.j || retainedStaticContext.getStaticBaseUri() == null || object != null && retainedStaticContext.getStaticBaseUri().equals(((RetainedStaticContext)object).getStaticBaseUri()))) {
                this.emitAttribute("baseUri", retainedStaticContext.getStaticBaseUriString());
            }
            if (!(retainedStaticContext.getDefaultCollationName().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint") || object != null && retainedStaticContext.getDefaultCollationName().equals(((RetainedStaticContext)object).getDefaultCollationName()))) {
                this.emitAttribute("defaultCollation", retainedStaticContext.getDefaultCollationName());
            }
            if (!(retainedStaticContext.getDefaultElementNamespace().isEmpty() || object != null && retainedStaticContext.getDefaultElementNamespace().equals(((RetainedStaticContext)object).getDefaultElementNamespace()))) {
                this.emitAttribute("defaultElementNS", retainedStaticContext.getDefaultElementNamespace());
            }
            if (!"http://www.w3.org/2005/xpath-functions".equals(retainedStaticContext.getDefaultFunctionNamespace())) {
                this.emitAttribute("defaultFunctionNS", retainedStaticContext.getDefaultFunctionNamespace());
            }
            if (!(((ExportOptions)this.i).suppressStaticContext || object != null && retainedStaticContext.declaresSameNamespaces((RetainedStaticContext)object))) {
                object = new FastStringBuffer(256);
                Iterator<String> iterator = retainedStaticContext.iteratePrefixes();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    String string2 = retainedStaticContext.getURIForPrefix(string, true);
                    ((FastStringBuffer)object).append(string);
                    ((FastStringBuffer)object).append("=");
                    if (Whitespace.containsWhitespace(string2)) {
                        throw new XPathException("Cannot export a stylesheet if namespaces contain whitespace: '" + string2 + "'");
                    }
                    if (string2.equals(NamespaceConstant.getUriForConventionalPrefix(string))) {
                        string2 = "~";
                    }
                    ((FastStringBuffer)object).append(string2);
                    ((FastStringBuffer)object).append(" ");
                }
                this.emitAttribute("ns", Whitespace.trim((CharSequence)object));
            }
            return;
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    public int startElement(String string) {
        this.g.push(string);
        return this.b(string);
    }

    private int b(String object) {
        try {
            if (this.d) {
                this.b.startContent();
                this.d = false;
            }
            object = this.h == null ? new NoNamespaceName((String)object) : new FingerprintedQName("", this.h, (String)object);
            this.b.startElement((NodeName)object, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            if (this.e != null) {
                this.emitAttribute("role", this.e);
                this.e = null;
            }
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
        this.d = true;
        return this.c++;
    }

    public void setChildRole(String string) {
        this.e = string;
    }

    public void emitAttribute(String object, String string) {
        if (string != null) {
            if (((String)object).equals("module")) {
                string = this.a(string);
            }
            try {
                this.b.attribute(new NoNamespaceName((String)object), BuiltInAtomicType.UNTYPED_ATOMIC, string, ExplicitLocation.UNKNOWN_LOCATION, 0);
                return;
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.printStackTrace();
                throw new InternalError(((Throwable)object).getMessage());
            }
        }
    }

    public void emitAttribute(String object, StructuredQName object2) {
        object2 = ((StructuredQName)object2).getEQName();
        try {
            this.b.attribute(new NoNamespaceName((String)object), BuiltInAtomicType.UNTYPED_ATOMIC, (CharSequence)object2, ExplicitLocation.UNKNOWN_LOCATION, 0);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
    }

    public void namespace(String object, String string) {
        try {
            this.b.namespace(new NamespaceBinding((String)object, string), 0);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(((Throwable)object).getMessage());
        }
    }

    public int endElement() {
        try {
            if (this.d) {
                this.b.startContent();
                this.d = false;
            }
            this.b.endElement();
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(xPathException2.getMessage());
        }
        String string = this.g.pop();
        if (string.startsWith("*")) {
            this.f.pop();
        }
        return --this.c;
    }

    public void startSubsidiaryElement(String string) {
        this.startElement(string);
    }

    public void endSubsidiaryElement() {
        this.endElement();
    }

    public void close() {
        try {
            if (this.b instanceof CheckSumFilter) {
                int n2 = ((CheckSumFilter)this.b).getChecksum();
                this.b.processingInstruction("\u03a3", Integer.toHexString(n2), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
            this.b.endDocument();
            this.b.close();
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.printStackTrace();
            throw new InternalError(xPathException2.getMessage());
        }
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public NamePool getNamePool() {
        return this.a.getNamePool();
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.a.getTypeHierarchy();
    }

    public static String jsEscape(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        block10: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\'': {
                    fastStringBuffer.append("\\'");
                    continue block10;
                }
                case '\"': {
                    fastStringBuffer.append("\\\"");
                    continue block10;
                }
                case '\b': {
                    fastStringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    fastStringBuffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    fastStringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    fastStringBuffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    fastStringBuffer.append("\\t");
                    continue block10;
                }
                case '\\': {
                    fastStringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c2 < ' ' || c2 > '\u007f' && c2 < '\u00a0' || c2 > '\ud800') {
                        fastStringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c2).toUpperCase();
                        while (string2.length() < 4) {
                            string2 = "0" + string2;
                        }
                        fastStringBuffer.append(string2);
                        continue block10;
                    }
                    fastStringBuffer.append(c2);
                }
            }
        }
        return fastStringBuffer.toString();
    }

    public static class ExportOptions
    implements Options {
        public String target = "";
        public int targetVersion = 0;
        public StylesheetPackage rootPackage;
        public Map<Component, Integer> componentMap;
        public Map<StylesheetPackage, Integer> packageMap;
        public boolean explaining;
        public boolean suppressStaticContext;
        public boolean addStaticType;
    }

    public static interface Options {
    }
}

