/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.AbstractTraceListener;
import net.sf.saxon.trace.InstructionInfo;

public class ModeTraceListener
extends AbstractTraceListener {
    private Stack<Item> a = new Stack();

    @Override
    protected String getOpeningAttributes() {
        return "xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"";
    }

    @Override
    public void startCurrentItem(Item item) {
        if (this.a.empty() || this.a.peek() != item) {
            super.startCurrentItem(item);
            this.a.push(item);
        }
    }

    @Override
    public void endCurrentItem(Item item) {
        if (this.a.peek() == item) {
            super.endCurrentItem(item);
            this.a.pop();
        }
    }

    @Override
    public void enter(InstructionInfo object, XPathContext object2) {
        if (object instanceof TemplateRule) {
            object2 = StandardErrorListener.abbreviatePath(object.getSystemId());
            object = AbstractTraceListener.spaces(this.indent) + "<rule match=\"" + this.escape(((Expression)((TemplateRule)object).getMatchPattern()).toString()) + '\"' + " line=\"" + object.getLineNumber() + '\"' + " module=\"" + this.escape((String)object2) + '\"' + '>';
            this.out.info((String)object);
            ++this.indent;
        }
    }

    @Override
    public void leave(InstructionInfo instructionInfo) {
        if (instructionInfo instanceof TemplateRule) {
            --this.indent;
            this.out.info(AbstractTraceListener.spaces(this.indent) + "</rule>");
        }
    }

    @Override
    protected String tag(int n2) {
        return "";
    }
}

