/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.value.StringValue;

public class TimingTraceListener
implements TraceListener {
    private int a = 0;
    private Logger b = new StandardLogger();
    private long c;
    private Stack<a> d = new Stack();
    private HashMap<InstructionInfo, a> e = new HashMap();
    protected Configuration config = null;
    private Map<InstructionInfo, Integer> f = new HashMap<InstructionInfo, Integer>();
    private int g = 50;

    @Override
    public void setOutputDestination(Logger logger) {
        this.b = logger;
    }

    @Override
    public void open(Controller controller) {
        this.config = controller.getConfiguration();
        this.g = controller.getExecutable().getHostLanguage();
        this.c = System.nanoTime();
    }

    @Override
    public void close() {
        this.c = System.nanoTime() - this.c;
        ++this.a;
        try {
            Object object = this.getStyleSheet();
            object = ((PreparedStylesheet)object).newController();
            SerializationProperties serializationProperties = new SerializationProperties();
            serializationProperties.setProperty("method", "html");
            serializationProperties.setProperty("indent", "yes");
            ((Controller)object).setTraceListener(null);
            TransformerReceiver object22 = new TransformerReceiver((XsltController)object);
            ((Controller)object).initializeController(new GlobalParameterSet());
            ((SequenceReceiver)object22).open();
            object = this.config.getSerializerFactory().getReceiver((Result)this.b.asStreamResult(), serializationProperties, ((Controller)object).makePipelineConfiguration());
            object22.setDestination((Receiver)object);
            object = new StreamWriterToReceiver(object22);
            object.writeStartDocument();
            object.writeStartElement("trace");
            object.writeAttribute("t-total", Double.toString((double)this.c / 1000000.0));
            for (a a2 : this.e.values()) {
                String string;
                object.writeStartElement("fn");
                if (a2.a.getObjectName() != null) {
                    string = a2.a.getObjectName().getDisplayName();
                    object.writeAttribute("name", string);
                } else if (a2.a.getProperty("name") != null) {
                    string = a2.a.getProperty("name").toString();
                    object.writeAttribute("name", string);
                }
                if (a2.a.getProperty("match") != null) {
                    string = a2.a.getProperty("match").toString();
                    object.writeAttribute("match", string);
                }
                if (a2.a.getProperty("mode") != null) {
                    string = a2.a.getProperty("mode").toString();
                    object.writeAttribute("mode", string);
                }
                object.writeAttribute("construct", a2.a.getConstructType() == 158 ? "function" : (a2.a.getConstructType() == 206 ? "variable" : "template"));
                string = a2.a.getSystemId();
                if (string != null) {
                    object.writeAttribute("file", string);
                }
                object.writeAttribute("count", Long.toString(a2.d / (long)this.a));
                object.writeAttribute("t-sum-net", Double.toString((double)a2.c / (double)this.a / 1000000.0));
                object.writeAttribute("t-avg-net", Double.toString((double)a2.c / (double)a2.d / 1000000.0));
                object.writeAttribute("t-sum", Double.toString((double)a2.b / (double)this.a / 1000000.0));
                object.writeAttribute("t-avg", Double.toString((double)a2.b / (double)a2.d / 1000000.0));
                object.writeAttribute("line", Long.toString(a2.a.getLineNumber()));
                object.writeEndElement();
            }
            object.writeEndElement();
            object.writeEndDocument();
            object.close();
            return;
        }
        catch (TransformerException transformerException) {
            System.err.println("Unable to transform timing profile information: " + transformerException.getMessage());
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            System.err.println("Unable to generate timing profile information: " + xMLStreamException.getMessage());
            return;
        }
    }

    @Override
    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        int n2 = instructionInfo.getConstructType();
        if (n2 == 158 || n2 == 200 || n2 == 206) {
            long l2 = System.nanoTime();
            Object object = new a(0);
            new a(0).a = instructionInfo;
            ((a)object).b = l2;
            this.d.add((a)object);
            object = this.f.get(instructionInfo);
            if (object == null) {
                this.f.put(instructionInfo, 0);
                return;
            }
            this.f.put(instructionInfo, (Integer)object + 1);
        }
    }

    @Override
    public void leave(InstructionInfo instructionInfo) {
        int n2 = instructionInfo.getConstructType();
        if (n2 == 158 || n2 == 200 || n2 == 206) {
            Object object;
            a a2 = this.d.peek();
            long l2 = System.nanoTime() - a2.b;
            a2.c = l2 - a2.c;
            a2.b = l2;
            a a3 = this.e.get(instructionInfo);
            if (a3 == null) {
                a2.d = 1L;
                this.e.put(instructionInfo, a2);
            } else {
                ++a3.d;
                object = this.f.get(instructionInfo);
                object = (Integer)object - 1;
                this.f.put(instructionInfo, (Integer)object);
                if ((Integer)object == 0) {
                    a3.b += a2.b;
                }
                a3.c += a2.c;
            }
            this.d.pop();
            if (!this.d.isEmpty()) {
                object = this.d.peek();
                this.d.peek().c = ((a)object).c + l2;
            }
        }
    }

    @Override
    public void startCurrentItem(Item item) {
    }

    @Override
    public void endCurrentItem(Item item) {
    }

    protected PreparedStylesheet getStyleSheet() {
        Object object = this.getStylesheetInputStream();
        object = new StreamSource((InputStream)object, "profile.xsl");
        CompilerInfo compilerInfo = this.config.getDefaultXsltCompilerInfo();
        compilerInfo.setParameter(new StructuredQName("", "", "lang"), new StringValue(this.g == 50 ? "XSLT" : "XQuery"));
        return Compilation.compileSingletonPackage(this.config, compilerInfo, (Source)object);
    }

    protected InputStream getStylesheetInputStream() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ClassLoader> arrayList2 = new ArrayList<ClassLoader>();
        return Configuration.locateResource("profile.xsl", arrayList, arrayList2);
    }

    private static final class a {
        public InstructionInfo a;
        public long b;
        public long c;
        public long d;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

