/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Initializer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.regex.EmptyString;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlCatalogResolver;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.NumericValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CommandLineOptions {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_FILENAME = 2;
    public static final int TYPE_CLASSNAME = 3;
    public static final int TYPE_ENUMERATION = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_QNAME = 6;
    public static final int TYPE_FILENAME_LIST = 7;
    public static final int TYPE_DATETIME = 8;
    public static final int TYPE_STRING = 9;
    public static final int TYPE_INTEGER_PAIR = 10;
    public static final int VALUE_REQUIRED = 256;
    public static final int VALUE_PROHIBITED = 512;
    private HashMap<String, Integer> a = new HashMap();
    private HashMap<String, String> b = new HashMap();
    protected Properties namedOptions = new Properties();
    private Properties c = new Properties();
    private Map<String, Set<String>> d = new HashMap<String, Set<String>>();
    private Map<String, String> e = new HashMap<String, String>();
    private List<String> f = new ArrayList<String>();
    private Properties g = new Properties();
    private Properties h = new Properties();
    private Properties i = new Properties();
    private Properties j = new Properties();
    private static DayTimeDurationValue k = new DayTimeDurationValue(1, 0, 0, 0, 0L, 1000);

    public void addRecognizedOption(String string, int n2, String string2) {
        this.a.put(string, n2);
        this.b.put(string, string2);
        if ((n2 & 0xFF) == 1) {
            this.setPermittedValues(string, new String[]{"on", "off"}, "on");
        }
    }

    public void setPermittedValues(String string, String[] object, String string2) {
        object = new HashSet<String>(Arrays.asList(object));
        this.d.put(string, (Set<String>)object);
        if (string2 != null) {
            this.e.put(string, string2);
        }
    }

    private static String a(Set<String> object) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if ("".equals(string)) {
                fastStringBuffer.append("\"\"");
            } else {
                fastStringBuffer.append(string);
            }
            fastStringBuffer.append('|');
        }
        FastStringBuffer fastStringBuffer2 = fastStringBuffer;
        fastStringBuffer2.setLength(fastStringBuffer2.length() - 1);
        return fastStringBuffer.toString();
    }

    public void setActualOptions(String[] object) {
        int n2 = ((String[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2 = object[i2];
            if ("-".equals(string2)) {
                this.f.add(string2);
                continue;
            }
            if (string2.charAt(0) == '-') {
                int n3;
                String string3;
                int n4;
                string = "";
                if (string2.length() > 5 && string2.charAt(1) == '-') {
                    n4 = string2.indexOf(58);
                    if (n4 > 0 && n4 < string2.length() - 1) {
                        string3 = string2.substring(2, n4);
                        string = string2.substring(n4 + 1);
                        this.c.setProperty(string3, string);
                        continue;
                    }
                    if (n4 > 0 && n4 == string2.length() - 1) {
                        string3 = string2.substring(2, n4);
                        this.c.setProperty(string3, "");
                        continue;
                    }
                    String string4 = string2.substring(2);
                    this.c.setProperty(string4, "true");
                    continue;
                }
                n4 = string2.indexOf(58);
                if (n4 > 0 && n4 < string2.length() - 1) {
                    string3 = string2.substring(1, n4);
                    string = string2.substring(n4 + 1);
                } else {
                    string3 = string2.substring(1);
                }
                if (this.a.get(string3) == null) {
                    throw new XPathException("Command line option -" + string3 + " is not recognized. Options available: " + this.displayPermittedOptions());
                }
                if (this.namedOptions.getProperty(string3) != null) {
                    throw new XPathException("Command line option -" + string3 + " appears more than once");
                }
                if ("?".equals(string)) {
                    String string5 = string3;
                    object = this;
                    System.err.println("Help for -" + string5 + " option");
                    i2 = object.a.get(string5);
                    if ((i2 & 0x200) == 0) {
                        switch (i2 & 0xFF) {
                            case 1: {
                                System.err.println("Value: on|off");
                                break;
                            }
                            case 5: {
                                System.err.println("Value: integer");
                                break;
                            }
                            case 2: {
                                System.err.println("Value: file name");
                                break;
                            }
                            case 7: {
                                System.err.println("Value: list of file names, semicolon-separated");
                                break;
                            }
                            case 3: {
                                System.err.println("Value: Java fully-qualified class name");
                                break;
                            }
                            case 6: {
                                System.err.println("Value: QName in Clark notation ({uri}local)");
                                break;
                            }
                            case 9: {
                                System.err.println("Value: string");
                                break;
                            }
                            case 10: {
                                System.err.println("Value: int,int");
                                break;
                            }
                            case 4: {
                                String string6 = "Value: one of ";
                                string6 = string6 + CommandLineOptions.a(object.d.get(string5));
                                System.err.println(string6);
                            }
                        }
                    }
                    System.err.println("Meaning: " + object.b.get(string5));
                    throw new XPathException("No processing requested");
                }
                if ("".equals(string)) {
                    n3 = this.a.get(string3);
                    if ((n3 & 0x100) != 0) {
                        String string7 = "Command line option -" + string3 + " requires a value";
                        if (this.d.get(string3) != null) {
                            string7 = string7 + ": permitted values are " + CommandLineOptions.a(this.d.get(string3));
                        }
                        throw new XPathException(string7);
                    }
                    String string8 = this.e.get(string3);
                    if (string8 != null) {
                        string = string8;
                    }
                } else {
                    n3 = this.a.get(string3);
                    if ((n3 & 0x200) != 0) {
                        String string9 = "Command line option -" + string3 + " does not expect a value";
                        throw new XPathException(string9);
                    }
                }
                Set<String> set = this.d.get(string3);
                if (set != null && !set.contains(string)) {
                    throw new XPathException("Bad option value " + string2 + ": permitted values are " + CommandLineOptions.a(set));
                }
                this.namedOptions.setProperty(string3, string);
                continue;
            }
            int n5 = string2.indexOf(61);
            if (n5 > 0) {
                char c2;
                string = string2.substring(0, n5);
                String string10 = "";
                if (n5 < string2.length() - 1) {
                    string10 = string2.substring(n5 + 1);
                }
                if ((c2 = string2.charAt(0)) == '!' && n5 >= 2) {
                    this.j.setProperty(string.substring(1), string10);
                    continue;
                }
                if (c2 == '?' && n5 >= 2) {
                    this.h.setProperty(string.substring(1), string10);
                    continue;
                }
                if (c2 == '+' && n5 >= 2) {
                    this.i.setProperty(string.substring(1), string10);
                    continue;
                }
                this.g.setProperty(string, string10);
                continue;
            }
            this.f.add(string2);
        }
    }

    public boolean definesParameterValues() {
        return !this.j.isEmpty() || !this.h.isEmpty() || !this.i.isEmpty() || !this.g.isEmpty();
    }

    public boolean testIfSchemaAware() {
        return this.getOptionValue("sa") != null || this.getOptionValue("outval") != null || this.getOptionValue("val") != null || this.getOptionValue("vlax") != null || this.getOptionValue("xsd") != null || this.getOptionValue("xsdversion") != null;
    }

    public void applyToConfiguration(Processor processor) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        String string14;
        String string15;
        String string16;
        String string17;
        String string18;
        String string19;
        String string20;
        String string21;
        String string22;
        String string23;
        String string24;
        Object object;
        Configuration configuration = processor.getUnderlyingConfiguration();
        Enumeration<?> object22 = this.c.propertyNames();
        while (object22.hasMoreElements()) {
            object = (String)object22.nextElement();
            String[] stringArray = this.c.getProperty((String)object);
            String string25 = "http://saxon.sf.net/feature/" + (String)object;
            if (!((String)object).startsWith("parserFeature?") && !((String)object).startsWith("parserProperty?")) {
                Feature<?> feature = Feature.byName(string25);
                if (feature == null) {
                    throw new XPathException("Unknown configuration feature " + (String)object);
                }
                if (feature.type == Boolean.class) {
                    Boolean.valueOf(Configuration.requireBoolean((String)object, stringArray));
                } else if (feature.type != Integer.class && feature.type != String.class) {
                    throw new XPathException("Property --" + (String)object + " cannot be supplied as a string");
                }
            }
            try {
                processor.getUnderlyingConfiguration().setConfigurationProperty(string25, stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException("Incorrect value for --" + (String)object + ": " + illegalArgumentException.getMessage());
            }
        }
        String string26 = this.getOptionValue("catalog");
        if (string26 != null) {
            if (this.getOptionValue("r") != null) {
                throw new XPathException("Cannot use -catalog and -r together");
            }
            if (this.getOptionValue("x") != null) {
                throw new XPathException("Cannot use -catalog and -x together");
            }
            if (this.getOptionValue("y") != null) {
                throw new XPathException("Cannot use -catalog and -y together");
            }
            object = new StringBuilder();
            if (this.getOptionValue("u") != null || CommandLineOptions.isImplicitURI(string26)) {
                for (String string27 : string26.split(";")) {
                    Source source = null;
                    try {
                        source = configuration.getURIResolver().resolve(string27, null);
                    }
                    catch (TransformerException transformerException) {}
                    if (source == null) {
                        source = configuration.getSystemURIResolver().resolve(string27, null);
                    }
                    ((StringBuilder)object).append(source.getSystemId()).append(';');
                }
            } else {
                for (String string28 : string26.split(";")) {
                    File file = new File(string28);
                    if (!file.exists()) {
                        throw new XPathException("Catalog file not found: " + string28);
                    }
                    ((StringBuilder)object).append(file.toURI().toASCIIString()).append(';');
                }
            }
            String string29 = ((StringBuilder)object).toString();
            try {
                configuration.getClass("org.apache.xml.resolver.CatalogManager", false, null);
                XmlCatalogResolver.setCatalog(string29, configuration, this.getOptionValue("t") != null);
            }
            catch (XPathException xPathException) {
                throw new XPathException("Failed to load Apache catalog resolver library", xPathException);
            }
        }
        if ((string24 = this.getOptionValue("cr")) != null) {
            object = configuration.getInstance(string24, null);
            if (!(object instanceof CollectionURIResolver)) {
                throw new XPathException("Class specified using -cr is not a CollectionURIResolver");
            }
            processor.setConfigurationProperty(Feature.COLLECTION_URI_RESOLVER, (CollectionURIResolver)object);
        }
        if ((string23 = this.getOptionValue("dtd")) != null) {
            if ("on".equals(string23)) {
                configuration.setBooleanProperty(Feature.DTD_VALIDATION, true);
                configuration.getParseOptions().setDTDValidationMode(1);
            } else if ("off".equals(string23)) {
                configuration.setBooleanProperty(Feature.DTD_VALIDATION, false);
                configuration.getParseOptions().setDTDValidationMode(4);
            } else if ("recover".equals(string23)) {
                configuration.setBooleanProperty(Feature.DTD_VALIDATION, true);
                configuration.setBooleanProperty(Feature.DTD_VALIDATION_RECOVERABLE, true);
                configuration.getParseOptions().setDTDValidationMode(2);
            }
        }
        if ((string22 = this.getOptionValue("ea")) != null) {
            boolean bl2 = Configuration.requireBoolean("ea", string22);
            configuration.getDefaultXsltCompilerInfo().setAssertionsEnabled(bl2);
        }
        if ((string21 = this.getOptionValue("expand")) != null) {
            boolean bl3 = Configuration.requireBoolean("expand", string21);
            configuration.getParseOptions().setExpandAttributeDefaults(bl3);
        }
        if ((string20 = this.getOptionValue("ext")) != null) {
            boolean bl4 = Configuration.requireBoolean("ext", string20);
            configuration.setBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, bl4);
        }
        if ((string19 = this.getOptionValue("l")) != null) {
            boolean bl5 = Configuration.requireBoolean("l", string19);
            configuration.setBooleanProperty(Feature.LINE_NUMBERING, bl5);
        }
        if ((string18 = this.getOptionValue("m")) != null) {
            configuration.setConfigurationProperty(Feature.MESSAGE_EMITTER_CLASS, string18);
        }
        if ((string17 = this.getOptionValue("opt")) != null) {
            configuration.setConfigurationProperty(Feature.OPTIMIZATION_LEVEL, string17);
        }
        if ((string16 = this.getOptionValue("or")) != null) {
            Object object2 = configuration.getInstance(string16, null);
            if (object2 instanceof OutputURIResolver) {
                configuration.setConfigurationProperty(Feature.OUTPUT_URI_RESOLVER, (OutputURIResolver)object2);
            } else {
                throw new XPathException("Class " + string16 + " is not an OutputURIResolver");
            }
        }
        if ((string15 = this.getOptionValue("outval")) != null) {
            Boolean bl6 = "recover".equals(string15);
            configuration.setConfigurationProperty(Feature.VALIDATION_WARNINGS, bl6);
            configuration.setConfigurationProperty(Feature.VALIDATION_COMMENTS, bl6);
        }
        if ((string14 = this.getOptionValue("r")) != null) {
            Configuration configuration2 = configuration;
            configuration2.setURIResolver(configuration2.makeURIResolver(string14));
        }
        if ((string13 = this.getOptionValue("strip")) != null) {
            configuration.setConfigurationProperty(Feature.STRIP_WHITESPACE, string13);
        }
        if ((string12 = this.getOptionValue("T")) != null) {
            configuration.setCompileWithTracing(true);
        }
        if ((string11 = this.getOptionValue("TJ")) != null) {
            boolean bl7 = Configuration.requireBoolean("TJ", string11);
            configuration.setBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS, bl7);
        }
        if ((string10 = this.getOptionValue("tree")) != null) {
            if ("linked".equals(string10)) {
                configuration.setTreeModel(0);
            } else if ("tiny".equals(string10)) {
                configuration.setTreeModel(1);
            } else if ("tinyc".equals(string10)) {
                configuration.setTreeModel(2);
            }
        }
        if ((string9 = this.getOptionValue("val")) != null) {
            if ("strict".equals(string9)) {
                processor.setConfigurationProperty(Feature.SCHEMA_VALIDATION, 1);
            } else if ("lax".equals(string9)) {
                processor.setConfigurationProperty(Feature.SCHEMA_VALIDATION, 2);
            }
        }
        if ((string8 = this.getOptionValue("warnings")) != null) {
            if ("silent".equals(string8)) {
                processor.setConfigurationProperty(Feature.RECOVERY_POLICY, 0);
            } else if ("recover".equals(string8)) {
                processor.setConfigurationProperty(Feature.RECOVERY_POLICY, 1);
            } else if ("fatal".equals(string8)) {
                processor.setConfigurationProperty(Feature.RECOVERY_POLICY, 2);
            }
        }
        if ((string7 = this.getOptionValue("x")) != null) {
            processor.setConfigurationProperty(Feature.SOURCE_PARSER_CLASS, string7);
        }
        if ((string6 = this.getOptionValue("xi")) != null) {
            boolean bl8 = Configuration.requireBoolean("xi", string6);
            processor.setConfigurationProperty(Feature.XINCLUDE, bl8);
        }
        if ((string5 = this.getOptionValue("xmlversion")) != null) {
            processor.setConfigurationProperty(Feature.XML_VERSION, string5);
        }
        if ((string4 = this.getOptionValue("xsdversion")) != null) {
            processor.setConfigurationProperty(Feature.XSD_VERSION, string4);
        }
        if ((string3 = this.getOptionValue("xsiloc")) != null) {
            boolean bl9 = Configuration.requireBoolean("xsiloc", string3);
            processor.setConfigurationProperty(Feature.USE_XSI_SCHEMA_LOCATION, bl9);
        }
        if ((string2 = this.getOptionValue("y")) != null) {
            processor.setConfigurationProperty(Feature.STYLE_PARSER_CLASS, string2);
        }
        if ((string = this.getOptionValue("init")) != null) {
            Initializer initializer = (Initializer)configuration.getInstance(string, null);
            initializer.initialize(configuration);
        }
    }

    public String displayPermittedOptions() {
        String[] stringArray = new String[this.a.size()];
        stringArray = new ArrayList<String>(this.a.keySet()).toArray(stringArray);
        Arrays.sort(stringArray, Collator.getInstance());
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        for (String string : stringArray) {
            fastStringBuffer.append(" -");
            fastStringBuffer.append(string);
        }
        return fastStringBuffer.toString();
    }

    public String getOptionValue(String string) {
        return this.namedOptions.getProperty(string);
    }

    public List<String> getPositionalOptions() {
        return this.f;
    }

    public void setParams(Processor processor, ParamSetter paramSetter) {
        Object object;
        String string;
        Enumeration<?> enumeration = this.g.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.g.getProperty(string);
            paramSetter.setParam(QName.fromClarkName(string), new XdmAtomicValue((String)object, ItemType.UNTYPED_ATOMIC));
        }
        this.a(processor, paramSetter);
        enumeration = this.h.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.h.getProperty(string);
            XPathCompiler xPathCompiler = processor.newXPathCompiler();
            object = xPathCompiler.compile((String)object);
            object = ((XPathExecutable)object).load().evaluate();
            paramSetter.setParam(QName.fromClarkName(string), (XdmValue)object);
        }
    }

    private void a(Processor processor, ParamSetter paramSetter) {
        boolean bl2 = "on".equals(this.getOptionValue("u"));
        Enumeration<?> enumeration = this.i.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.i.getProperty(string);
            Object object2 = new ArrayList<Source>();
            CommandLineOptions.loadDocuments((String)object, bl2, processor, true, object2);
            if (!object2.isEmpty()) {
                object = new ArrayList(object2.size());
                DocumentBuilder documentBuilder = processor.newDocumentBuilder();
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Source source = (Source)object2.next();
                    object.add(documentBuilder.build(source));
                }
                object2 = new XdmValue((Iterable<? extends XdmItem>)object);
                paramSetter.setParam(QName.fromClarkName(string), (XdmValue)object2);
                continue;
            }
            paramSetter.setParam(QName.fromClarkName(string), XdmEmptySequence.getInstance());
        }
    }

    public void setSerializationProperties(Serializer serializer) {
        Enumeration<?> enumeration = this.j.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.j.getProperty(string);
            if (string.startsWith("saxon:")) {
                string = "{http://saxon.sf.net/}" + string.substring(6);
            }
            serializer.setOutputProperty(QName.fromClarkName(string), string2);
        }
    }

    public void applyStaticParams(XsltCompiler xsltCompiler) {
        Object object;
        String string;
        Processor processor = xsltCompiler.getProcessor();
        Enumeration<?> enumeration = this.g.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.g.getProperty(string);
            xsltCompiler.setParameter(QName.fromClarkName(string), new XdmAtomicValue((String)object, ItemType.UNTYPED_ATOMIC));
        }
        enumeration = this.h.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.h.getProperty(string);
            XPathCompiler xPathCompiler = processor.newXPathCompiler();
            object = xPathCompiler.compile((String)object);
            object = ((XPathExecutable)object).load().evaluate();
            xsltCompiler.setParameter(QName.fromClarkName(string), (XdmValue)object);
        }
    }

    public void applyFileParams(Processor processor, Xslt30Transformer xslt30Transformer) {
        if (!this.i.isEmpty()) {
            HashMap hashMap = new HashMap();
            this.a(processor, hashMap::put);
            xslt30Transformer.setStylesheetParameters(hashMap);
        }
    }

    public static boolean loadDocuments(String object, boolean bl2, Processor stringArray, boolean bl3, List<Source> list) {
        Object object2;
        stringArray = stringArray.getUnderlyingConfiguration();
        if (bl2 || CommandLineOptions.isImplicitURI((String)object)) {
            Source source;
            try {
                source = stringArray.getURIResolver().resolve((String)object, null);
                if (source == null) {
                    source = stringArray.getSystemURIResolver().resolve((String)object, null);
                }
            }
            catch (TransformerException transformerException) {
                throw new SaxonApiException(transformerException);
            }
            list.add(source);
            return false;
        }
        if (((String)object).equals("-")) {
            Source source;
            if (bl3) {
                object = stringArray.getSourceParser();
                source = new SAXSource((XMLReader)object, new InputSource(System.in));
            } else {
                source = new StreamSource(System.in);
            }
            list.add(source);
            return false;
        }
        File file = new File((String)object);
        if (!file.exists()) {
            throw new SaxonApiException("Source file " + file + " does not exist");
        }
        if (file.isDirectory()) {
            object = stringArray.getSourceParser();
            Object object3 = file.list();
            if (object3 != null) {
                stringArray = object3;
                int n2 = ((String[])object3).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object3 = stringArray[i2];
                    if (((File)(object3 = new File(file, (String)object3))).isDirectory()) continue;
                    if (bl3) {
                        object3 = new InputSource(((File)object3).toURI().toString());
                        object3 = new SAXSource((XMLReader)object, (InputSource)object3);
                    } else {
                        object3 = new StreamSource(((File)object3).toURI().toString());
                    }
                    list.add((Source)object3);
                }
            }
            return true;
        }
        if (bl3) {
            object2 = new InputSource(file.toURI().toString());
            object2 = new SAXSource(stringArray.getSourceParser(), (InputSource)object2);
        } else {
            object2 = new StreamSource(file.toURI().toString());
        }
        list.add((Source)object2);
        return false;
    }

    public static boolean isImplicitURI(String string) {
        return string.startsWith("http:") || string.startsWith("https:") || string.startsWith("file:") || string.startsWith("classpath:");
    }

    public static void loadAdditionalSchemas(Configuration configuration, String object) {
        object = new StringTokenizer((String)object, File.pathSeparator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            File file = new File(string);
            if (!file.exists()) {
                throw new SchemaException("Schema document " + string + " not found");
            }
            configuration.addSchemaSource(new StreamSource(file));
        }
    }

    public static String showExecutionTimeNano(long l2) {
        if ((double)l2 < 1.0E9) {
            return (double)l2 / 1000000.0 + "ms";
        }
        try {
            double d2 = (double)l2 / 1000000.0;
            Comparable<DayTimeDurationValue> comparable = k.multiply(d2);
            long l3 = ((NumericValue)((AtomicValue)((Object)comparable)).getComponent(AccessorFn.Component.DAY)).longValue();
            long l4 = ((NumericValue)((AtomicValue)((Object)comparable)).getComponent(AccessorFn.Component.HOURS)).longValue();
            long l5 = ((NumericValue)((AtomicValue)((Object)comparable)).getComponent(AccessorFn.Component.MINUTES)).longValue();
            comparable = ((NumericValue)((AtomicValue)((Object)comparable)).getComponent(AccessorFn.Component.SECONDS)).getDecimalValue();
            FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
            if (l3 > 0L) {
                fastStringBuffer.append(l3 + "days ");
            }
            if (l4 > 0L) {
                fastStringBuffer.append(l4 + "h ");
            }
            if (l5 > 0L) {
                fastStringBuffer.append(l5 + "m ");
            }
            fastStringBuffer.append(comparable + "s");
            return fastStringBuffer + " (" + (double)l2 / 1000000.0 + "ms)";
        }
        catch (XPathException xPathException) {
            return (double)l2 / 1000000.0 + "ms";
        }
    }

    public static String showMemoryUsed() {
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return ((NumericGroupFormatter)new RegularGroupFormatter(3, ",", EmptyString.THE_INSTANCE)).format(new FastStringBuffer("" + l2));
    }

    public static String getCommandName(Object object) {
        if (((String)(object = object.getClass().getName())).startsWith("cli.Saxon.Cmd.DotNet")) {
            object = ((String)object).substring(20);
        }
        return object;
    }

    public static interface ParamSetter {
        public void setParam(QName var1, XdmValue var2);
    }
}

