/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.Rule;

public class CompoundMode
extends Mode {
    private Mode c;
    private SimpleMode d;
    private int e;

    public CompoundMode(Mode mode, SimpleMode simpleMode) {
        super(mode.getModeName());
        if (!mode.getModeName().equals(simpleMode.getModeName())) {
            throw new AssertionError((Object)"Base and overriding modes must have the same name");
        }
        if (mode.getModeName().equals(Mode.UNNAMED_MODE_NAME)) {
            throw new AssertionError((Object)"Cannot override an unnamed mode");
        }
        if (mode.getModeName().equals(Mode.OMNI_MODE)) {
            throw new AssertionError((Object)"Cannot override mode='#all'");
        }
        this.c = mode;
        this.d = simpleMode;
        this.mustBeTyped = mode.mustBeTyped;
        this.mustBeUntyped = mode.mustBeUntyped;
        this.e = mode.getMaxPrecedence() + 1;
    }

    @Override
    public BuiltInRuleSet getBuiltInRuleSet() {
        return this.c.getBuiltInRuleSet();
    }

    @Override
    public SimpleMode getActivePart() {
        return this.d;
    }

    @Override
    public boolean isEmpty() {
        return this.c.isEmpty() && ((Mode)this.d).isEmpty();
    }

    @Override
    public int getMaxPrecedence() {
        return this.e;
    }

    @Override
    public int getMaxRank() {
        return ((Mode)this.d).getMaxRank();
    }

    @Override
    public void computeRankings(int n2) {
        ((Mode)this.d).computeRankings(this.c.getMaxRank() + 1);
    }

    @Override
    public void processRules(Mode.RuleAction ruleAction) {
        ((Mode)this.d).processRules(ruleAction);
        this.c.processRules(ruleAction);
    }

    @Override
    public Set<String> getExplicitNamespaces(NamePool namePool) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.c.getExplicitNamespaces(namePool));
        hashSet.addAll(((Mode)this.d).getExplicitNamespaces(namePool));
        return hashSet;
    }

    @Override
    public void allocateAllBindingSlots(StylesheetPackage stylesheetPackage) {
        if (!this.b) {
            List<ComponentBinding> list = this.c.getDeclaringComponent().getComponentBindings();
            list = new ArrayList<ComponentBinding>(list);
            Component.M m2 = this.getDeclaringComponent();
            m2.setComponentBindings(list);
            SimpleMode.forceAllocateAllBindingSlots(stylesheetPackage, this.d, list);
            this.b = true;
        }
    }

    @Override
    public Rule getRule(Item item, XPathContext xPathContext) {
        Rule rule = ((Mode)this.d).getRule(item, xPathContext);
        if (rule == null) {
            rule = this.c.getRule(item, xPathContext);
        }
        return rule;
    }

    @Override
    public int getStackFrameSlotsNeeded() {
        return Math.max(this.c.getStackFrameSlotsNeeded(), ((Mode)this.d).getStackFrameSlotsNeeded());
    }

    @Override
    public Rule getRule(Item item, XPathContext xPathContext, Mode.RuleFilter ruleFilter) {
        Rule rule = ((Mode)this.d).getRule(item, xPathContext, ruleFilter);
        if (rule == null) {
            rule = this.c.getRule(item, xPathContext, ruleFilter);
        }
        return rule;
    }

    @Override
    public void exportTemplateRules(ExpressionPresenter expressionPresenter) {
        ((Mode)this.d).exportTemplateRules(expressionPresenter);
        this.c.exportTemplateRules(expressionPresenter);
    }

    @Override
    public void explainTemplateRules(ExpressionPresenter expressionPresenter) {
        ((Mode)this.d).explainTemplateRules(expressionPresenter);
        this.c.explainTemplateRules(expressionPresenter);
    }
}

