/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageLibrary;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ConfigurationReader
implements NamespaceResolver,
ContentHandler {
    private int a = 0;
    private String b = null;
    private String c = null;
    private FastStringBuffer d = new FastStringBuffer(100);
    protected Configuration config;
    private ClassLoader e = null;
    private List<XPathException> f = new ArrayList<XPathException>();
    private Locator g;
    private Stack<List<String[]>> h = new Stack();
    private PackageLibrary i;
    private PackageDetails j;
    private Configuration k;

    public void setClassLoader(ClassLoader classLoader) {
        this.e = classLoader;
    }

    public void setBaseConfiguration(Configuration configuration) {
        this.k = configuration;
    }

    /*
     * WARNING - void declaration
     */
    public Configuration makeConfiguration(Source object) {
        void var3_4;
        Object object2;
        Object object32 = null;
        if (object instanceof NodeInfo) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy(this){
                private /* synthetic */ ConfigurationReader a;
                {
                    this.a = configurationReader;
                }

                @Override
                public final void startDocument(int n2) {
                    try {
                        this.getUnderlyingContentHandler().startDocument();
                        return;
                    }
                    catch (SAXException sAXException) {
                        SAXException sAXException2 = sAXException;
                        throw XPathException.makeXPathException(sAXException);
                    }
                }

                @Override
                public final void endDocument() {
                    try {
                        this.getUnderlyingContentHandler().endDocument();
                        return;
                    }
                    catch (SAXException sAXException) {
                        SAXException sAXException2 = sAXException;
                        throw XPathException.makeXPathException(sAXException);
                    }
                }
            };
            contentHandlerProxy.setUnderlyingContentHandler(this);
            contentHandlerProxy.setPipelineConfiguration(((NodeInfo)((Object)object)).getConfiguration().makePipelineConfiguration());
            contentHandlerProxy.open();
            this.setDocumentLocator(new ExplicitLocation(object.getSystemId(), -1, -1));
            contentHandlerProxy.startDocument(0);
            ((NodeInfo)((Object)object)).copy(contentHandlerProxy, 2, ExplicitLocation.UNKNOWN_LOCATION);
            contentHandlerProxy.endDocument();
            contentHandlerProxy.close();
            if (this.k != null) {
                this.config.importLicenseDetails(this.k);
            }
            return this.config;
        }
        if (object instanceof SAXSource) {
            XMLReader xMLReader = ((SAXSource)((Object)object)).getXMLReader();
            object2 = ((SAXSource)((Object)object)).getInputSource();
        } else if (object instanceof StreamSource) {
            object2 = new InputSource(object.getSystemId());
            ((InputSource)object2).setCharacterStream(((StreamSource)((Object)object)).getReader());
            ((InputSource)object2).setByteStream(((StreamSource)((Object)object)).getInputStream());
        } else {
            throw new XPathException("Source for configuration file must be a StreamSource or SAXSource or NodeInfo");
        }
        if (var3_4 == null) {
            XMLReader xMLReader = Version.platform.loadParser();
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                throw new TransformerFactoryConfigurationError(sAXException);
            }
        }
        try {
            void var3_6;
            var3_6.setContentHandler(this);
            var3_6.parse((InputSource)object2);
        }
        catch (IOException iOException) {
            throw new XPathException("Failed to read config file", iOException);
        }
        catch (SAXException sAXException) {
            throw new XPathException("Failed to parse config file", sAXException);
        }
        if (!this.f.isEmpty()) {
            object2 = this.config == null ? new StandardErrorListener() : this.config.getErrorListener();
            try {
                for (XPathException xPathException : this.f) {
                    object2.warning(xPathException);
                }
            }
            catch (TransformerException transformerException) {}
            throw this.f.get(0);
        }
        if (this.k != null) {
            this.config.importLicenseDetails(this.k);
        }
        return this.config;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.g = locator;
    }

    @Override
    public void startDocument() {
        this.h.push(new ArrayList());
    }

    @Override
    public void endDocument() {
        this.h.pop();
        if (this.config != null) {
            this.config.getDefaultXsltCompilerInfo().setPackageLibrary(this.i);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        this.h.peek().add(new String[]{string, string2});
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void startElement(String object, String object2, String object3, Attributes object4) {
        block75: {
            block73: {
                block76: {
                    block74: {
                        String string;
                        this.d.setLength(0);
                        if (!"http://saxon.sf.net/ns/configuration".equals(object)) break block73;
                        if (this.a == 0) {
                            if (!"configuration".equals(object2)) {
                                this.a((String)object2, null, null, "configuration");
                            }
                            if ((object = object4.getValue("edition")) == null) {
                                object = "HE";
                            }
                            switch (object) {
                                case "HE": {
                                    this.config = new Configuration();
                                    break;
                                }
                                case "PE": {
                                    this.config = Configuration.makeLicensedConfiguration(this.e, "com.saxonica.config.ProfessionalConfiguration");
                                    break;
                                }
                                case "EE": {
                                    this.config = Configuration.makeLicensedConfiguration(this.e, "com.saxonica.config.EnterpriseConfiguration");
                                    break;
                                }
                                default: {
                                    this.a("configuration", "edition", (String)object, "HE|PE|EE");
                                    this.config = new Configuration();
                                }
                            }
                            if (this.k != null) {
                                this.config.setNamePool(this.k.getNamePool());
                                this.config.setDocumentNumberAllocator(this.k.getDocumentNumberAllocator());
                            }
                            this.i = new PackageLibrary(this.config.getDefaultXsltCompilerInfo());
                            object3 = object4.getValue("licenseFileLocation");
                            if (object3 != null && !((String)object).equals("HE")) {
                                String string2 = this.g.getSystemId();
                                try {
                                    object = ResolveURI.makeAbsolute((String)object3, string2);
                                    this.config.setConfigurationProperty("http://saxon.sf.net/feature/licenseFileLocation", ((URI)object).toString());
                                }
                                catch (Exception exception) {
                                    this.f.add(new XPathException("Failed to process license at " + (String)object3, exception));
                                }
                            }
                            if ((string = object4.getValue("label")) != null) {
                                this.config.setLabel(string);
                            }
                            this.config.getDynamicLoader().setClassLoader(this.e);
                        }
                        if (this.a != 1) break block74;
                        this.b = object2;
                        if ("global".equals(object2)) {
                            object2 = object4;
                            object = this;
                            object3 = new Properties();
                            for (int i2 = 0; i2 < object2.getLength(); ++i2) {
                                string = object2.getLocalName(i2);
                                String string3 = object2.getValue(i2);
                                if (string3.isEmpty() || !object2.getURI(i2).isEmpty()) continue;
                                ((Properties)object3).put(string, string3);
                            }
                            ((Properties)object3).put("#element", "global");
                            super.a((Properties)object3, "allowExternalFunctions", "http://saxon.sf.net/feature/allow-external-functions");
                            super.a((Properties)object3, "allowMultiThreading", "http://saxon.sf.net/feature/allow-multithreading");
                            super.a((Properties)object3, "allowOldJavaUriFormat", "http://saxon.sf.net/feature/allow-old-java-uri-format");
                            super.a((Properties)object3, "allowSyntaxExtensions", "http://saxon.sf.net/feature/allowSyntaxExtensions");
                            super.a((Properties)object3, "collationUriResolver", "http://saxon.sf.net/feature/collation-uri-resolver-class");
                            super.a((Properties)object3, "collectionUriResolver", "http://saxon.sf.net/feature/collection-uri-resolver-class");
                            super.a((Properties)object3, "compileWithTracing", "http://saxon.sf.net/feature/compile-with-tracing");
                            super.a((Properties)object3, "debugByteCode", "http://saxon.sf.net/feature/debugByteCode");
                            super.a((Properties)object3, "debugByteCodeDirectory", "http://saxon.sf.net/feature/debugByteCodeDir");
                            super.a((Properties)object3, "defaultCollation", "http://saxon.sf.net/feature/defaultCollation");
                            super.a((Properties)object3, "defaultCollection", "http://saxon.sf.net/feature/defaultCollection");
                            super.a((Properties)object3, "defaultRegexEngine", "http://saxon.sf.net/feature/defaultRegexEngine");
                            super.a((Properties)object3, "displayByteCode", "http://saxon.sf.net/feature/displayByteCode");
                            super.a((Properties)object3, "dtdValidation", "http://saxon.sf.net/feature/validation");
                            super.a((Properties)object3, "dtdValidationRecoverable", "http://saxon.sf.net/feature/dtd-validation-recoverable");
                            super.a((Properties)object3, "eagerEvaluation", "http://saxon.sf.net/feature/eagerEvaluation");
                            super.a((Properties)object3, "entityResolver", "http://saxon.sf.net/feature/entityResolverClass");
                            super.a((Properties)object3, "errorListener", "http://saxon.sf.net/feature/errorListenerClass");
                            super.a((Properties)object3, "environmentVariableResolver", "http://saxon.sf.net/feature/environmentVariableResolverClass");
                            super.a((Properties)object3, "expandAttributeDefaults", "http://saxon.sf.net/feature/expandAttributeDefaults");
                            super.a((Properties)object3, "generateByteCode", "http://saxon.sf.net/feature/generateByteCode");
                            super.a((Properties)object3, "ignoreSAXSourceParser", "http://saxon.sf.net/feature/ignoreSAXSourceParser");
                            super.a((Properties)object3, "lineNumbering", "http://saxon.sf.net/feature/linenumbering");
                            super.a((Properties)object3, "markDefaultedAttributes", "http://saxon.sf.net/feature/markDefaultedAttributes");
                            super.a((Properties)object3, "maxCompiledClasses", "http://saxon.sf.net/feature/maxCompiledClasses");
                            super.a((Properties)object3, "monitorHotSpotByteCode", "http://saxon.sf.net/feature/monitorHotSpotByteCode");
                            super.a((Properties)object3, "optimizationLevel", "http://saxon.sf.net/feature/optimizationLevel");
                            super.a((Properties)object3, "parser", "http://saxon.sf.net/feature/sourceParserClass");
                            super.a((Properties)object3, "preEvaluateDoc", "http://saxon.sf.net/feature/preEvaluateDocFunction");
                            super.a((Properties)object3, "preferJaxpParser", "http://saxon.sf.net/feature/preferJaxpParser");
                            super.a((Properties)object3, "recognizeUriQueryParameters", "http://saxon.sf.net/feature/recognize-uri-query-parameters");
                            super.a((Properties)object3, "schemaValidation", "http://saxon.sf.net/feature/schema-validation-mode");
                            super.a((Properties)object3, "serializerFactory", "http://saxon.sf.net/feature/serializerFactoryClass");
                            super.a((Properties)object3, "sourceResolver", "http://saxon.sf.net/feature/sourceResolverClass");
                            super.a((Properties)object3, "stableCollectionUri", "http://saxon.sf.net/feature/stableCollectionUri");
                            super.a((Properties)object3, "stableUnparsedText", "http://saxon.sf.net/feature/stableUnparsedText");
                            super.a((Properties)object3, "standardErrorOutputFile", "http://saxon.sf.net/feature/standardErrorOutputFile");
                            super.a((Properties)object3, "streamability", "http://saxon.sf.net/feature/streamability");
                            super.a((Properties)object3, "streamingFallback", "http://saxon.sf.net/feature/streamingFallback");
                            super.a((Properties)object3, "stripSpace", "http://saxon.sf.net/feature/strip-whitespace");
                            super.a((Properties)object3, "styleParser", "http://saxon.sf.net/feature/styleParserClass");
                            super.a((Properties)object3, "suppressEvaluationExpiryWarning", "http://saxon.sf.net/feature/suppressEvaluationExpiryWarning");
                            super.a((Properties)object3, "suppressXPathWarnings", "http://saxon.sf.net/feature/suppressXPathWarnings");
                            super.a((Properties)object3, "suppressXsltNamespaceCheck", "http://saxon.sf.net/feature/suppressXsltNamespaceCheck");
                            super.a((Properties)object3, "thresholdForHotspotByteCode", "http://saxon.sf.net/feature/thresholdForHotspotByteCode");
                            super.a((Properties)object3, "timing", "http://saxon.sf.net/feature/timing");
                            super.a((Properties)object3, "traceExternalFunctions", "http://saxon.sf.net/feature/trace-external-functions");
                            super.a((Properties)object3, "traceListener", "http://saxon.sf.net/feature/traceListenerClass");
                            super.a((Properties)object3, "traceListenerOutputFile", "http://saxon.sf.net/feature/traceListenerOutputFile");
                            super.a((Properties)object3, "traceOptimizerDecisions", "http://saxon.sf.net/feature/trace-optimizer-decisions");
                            super.a((Properties)object3, "treeModel", "http://saxon.sf.net/feature/treeModelName");
                            super.a((Properties)object3, "unparsedTextUriResolver", "http://saxon.sf.net/feature/unparsedTextURIResolverClass");
                            super.a((Properties)object3, "uriResolver", "http://saxon.sf.net/feature/uriResolverClass");
                            super.a((Properties)object3, "usePiDisableOutputEscaping", "http://saxon.sf.net/feature/use-pi-disable-output-escaping");
                            super.a((Properties)object3, "useTypedValueCache", "http://saxon.sf.net/feature/use-typed-value-cache");
                            super.a((Properties)object3, "validationComments", "http://saxon.sf.net/feature/validation-comments");
                            super.a((Properties)object3, "validationWarnings", "http://saxon.sf.net/feature/validation-warnings");
                            super.a((Properties)object3, "versionOfXml", "http://saxon.sf.net/feature/xml-version");
                            super.a((Properties)object3, "xInclude", "http://saxon.sf.net/feature/xinclude-aware");
                        } else if ("serialization".equals(object2)) {
                            object2 = object4;
                            object = this;
                            object3 = new Properties();
                            for (int i3 = 0; i3 < object2.getLength(); ++i3) {
                                string = object2.getURI(i3);
                                String string4 = object2.getLocalName(i3);
                                String string5 = object2.getValue(i3);
                                if (string5.isEmpty()) continue;
                                try {
                                    ResultDocument.setSerializationProperty((Properties)object3, string, string4, string5, (NamespaceResolver)object, false, ((ConfigurationReader)object).config);
                                    continue;
                                }
                                catch (XPathException xPathException) {
                                    ((ConfigurationReader)object).f.add(xPathException);
                                }
                            }
                            ((ConfigurationReader)object).config.setDefaultSerializationProperties((Properties)object3);
                        } else if ("xquery".equals(object2)) {
                            object2 = object4;
                            object = this;
                            object3 = new Properties();
                            for (int i4 = 0; i4 < object2.getLength(); ++i4) {
                                string = object2.getLocalName(i4);
                                String string6 = object2.getValue(i4);
                                if (string6.isEmpty() || !object2.getURI(i4).isEmpty()) continue;
                                ((Properties)object3).put(string, string6);
                            }
                            ((Properties)object3).put("#element", "xquery");
                            super.a((Properties)object3, "allowUpdate", "http://saxon.sf.net/feature/xqueryAllowUpdate");
                            super.a((Properties)object3, "constructionMode", "http://saxon.sf.net/feature/xqueryConstructionMode");
                            super.a((Properties)object3, "defaultElementNamespace", "http://saxon.sf.net/feature/xqueryDefaultElementNamespace");
                            super.a((Properties)object3, "defaultFunctionNamespace", "http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace");
                            super.a((Properties)object3, "emptyLeast", "http://saxon.sf.net/feature/xqueryEmptyLeast");
                            super.a((Properties)object3, "inheritNamespaces", "http://saxon.sf.net/feature/xqueryInheritNamespaces");
                            super.a((Properties)object3, "moduleUriResolver", "http://saxon.sf.net/feature/moduleURIResolverClass");
                            super.a((Properties)object3, "preserveBoundarySpace", "http://saxon.sf.net/feature/xqueryPreserveBoundarySpace");
                            super.a((Properties)object3, "preserveNamespaces", "http://saxon.sf.net/feature/xqueryPreserveNamespaces");
                            super.a((Properties)object3, "requiredContextItemType", "http://saxon.sf.net/feature/xqueryRequiredContextItemType");
                            super.a((Properties)object3, "schemaAware", "http://saxon.sf.net/feature/xquerySchemaAware");
                            super.a((Properties)object3, "staticErrorListener", "http://saxon.sf.net/feature/xqueryStaticErrorListenerClass");
                            super.a((Properties)object3, "version", "http://saxon.sf.net/feature/xqueryVersion");
                        } else if ("xslt".equals(object2)) {
                            object2 = object4;
                            object = this;
                            object3 = new Properties();
                            for (int i5 = 0; i5 < object2.getLength(); ++i5) {
                                string = object2.getLocalName(i5);
                                String string7 = object2.getValue(i5);
                                if (string7.isEmpty() || !object2.getURI(i5).isEmpty()) continue;
                                ((Properties)object3).put(string, string7);
                            }
                            ((Properties)object3).put("#element", "xslt");
                            super.a((Properties)object3, "disableXslEvaluate", "http://saxon.sf.net/feature/disableXslEvaluate");
                            super.a((Properties)object3, "enableAssertions", "http://saxon.sf.net/feature/enableAssertions");
                            super.a((Properties)object3, "initialMode", "http://saxon.sf.net/feature/initialMode");
                            super.a((Properties)object3, "initialTemplate", "http://saxon.sf.net/feature/initialTemplate");
                            super.a((Properties)object3, "messageEmitter", "http://saxon.sf.net/feature/messageEmitterClass");
                            super.a((Properties)object3, "outputUriResolver", "http://saxon.sf.net/feature/outputURIResolverClass");
                            super.a((Properties)object3, "recoveryPolicy", "http://saxon.sf.net/feature/recoveryPolicyName");
                            super.a((Properties)object3, "resultDocumentThreads", "http://saxon.sf.net/feature/resultDocumentThreads");
                            super.a((Properties)object3, "schemaAware", "http://saxon.sf.net/feature/xsltSchemaAware");
                            super.a((Properties)object3, "staticErrorListener", "http://saxon.sf.net/feature/stylesheetErrorListener");
                            super.a((Properties)object3, "staticUriResolver", "http://saxon.sf.net/feature/stylesheetURIResolver");
                            super.a((Properties)object3, "strictStreamability", "http://saxon.sf.net/feature/strictStreamability");
                            super.a((Properties)object3, "styleParser", "http://saxon.sf.net/feature/styleParserClass");
                            super.a((Properties)object3, "version", "http://saxon.sf.net/feature/xsltVersion");
                        } else if (!"xsltPackages".equals(object2)) {
                            if ("xsd".equals(object2)) {
                                object2 = object4;
                                object = this;
                                object3 = new Properties();
                                for (int i6 = 0; i6 < object2.getLength(); ++i6) {
                                    string = object2.getLocalName(i6);
                                    String string8 = object2.getValue(i6);
                                    if (string8.isEmpty() || !object2.getURI(i6).isEmpty()) continue;
                                    ((Properties)object3).put(string, string8);
                                }
                                ((Properties)object3).put("#element", "xsd");
                                super.a((Properties)object3, "assertionsCanSeeComments", "http://saxon.sf.net/feature/assertionsCanSeeComments");
                                super.a((Properties)object3, "implicitSchemaImports", "http://saxon.sf.net/feature/implicitSchemaImports");
                                super.a((Properties)object3, "multipleSchemaImports", "http://saxon.sf.net/feature/multipleSchemaImports");
                                super.a((Properties)object3, "occurrenceLimits", "http://saxon.sf.net/feature/occurrenceLimits");
                                super.a((Properties)object3, "schemaUriResolver", "http://saxon.sf.net/feature/schemaURIResolverClass");
                                super.a((Properties)object3, "thresholdForCompilingTypes", "http://saxon.sf.net/feature/thresholdForCompilingTypes");
                                super.a((Properties)object3, "useXsiSchemaLocation", "http://saxon.sf.net/feature/useXsiSchemaLocation");
                                super.a((Properties)object3, "version", "http://saxon.sf.net/feature/xsd-version");
                            } else if (!"resources".equals(object2) && !"collations".equals(object2)) {
                                if ("localizations".equals(object2)) {
                                    object2 = object4;
                                    object = this;
                                    for (int i7 = 0; i7 < object2.getLength(); ++i7) {
                                        if (!object2.getURI(i7).isEmpty()) continue;
                                        object4 = object2.getLocalName(i7);
                                        string = object2.getValue(i7);
                                        if ("defaultLanguage".equals(object4) && !string.isEmpty()) {
                                            ((ConfigurationReader)object).config.setConfigurationProperty("http://saxon.sf.net/feature/defaultLanguage", string);
                                        }
                                        if (!"defaultCountry".equals(object4) || string.isEmpty()) continue;
                                        ((ConfigurationReader)object).config.setConfigurationProperty("http://saxon.sf.net/feature/defaultCountry", string);
                                    }
                                } else {
                                    this.a((String)object2, null, null, null);
                                }
                            }
                        }
                        break block75;
                    }
                    if (this.a != 2) break block76;
                    this.c = object2;
                    switch (this.b) {
                        case "resources": {
                            if ("fileExtension".equals(object2)) {
                                object2 = object4;
                                object = this;
                                String string = object2.getValue("", "extension");
                                object4 = object2.getValue("", "mediaType");
                                if (string == null) {
                                    super.a("fileExtension", "extension", null, null);
                                }
                                if (object4 == null) {
                                    super.a("fileExtension", "mediaType", null, null);
                                }
                                ((ConfigurationReader)object).config.registerFileExtension(string, (String)object4);
                                break;
                            }
                            break block75;
                        }
                        case "collations": {
                            if (!"collation".equals(object2)) {
                                this.a((String)object2, null, null, "collation");
                                break;
                            }
                            object2 = object4;
                            object = this;
                            Properties properties = new Properties();
                            object4 = null;
                            for (int i8 = 0; i8 < object2.getLength(); ++i8) {
                                if (!object2.getURI(i8).isEmpty()) continue;
                                String string = object2.getLocalName(i8);
                                String string9 = object2.getValue(i8);
                                if (string9.isEmpty()) continue;
                                if ("uri".equals(string)) {
                                    object4 = string9;
                                    continue;
                                }
                                properties.put(string, string9);
                            }
                            if (object4 == null) {
                                ((ConfigurationReader)object).f.add(new XPathException("collation specified with no uri"));
                            }
                            StringCollator stringCollator = null;
                            try {
                                stringCollator = Version.platform.makeCollation(((ConfigurationReader)object).config, properties, (String)object4);
                            }
                            catch (XPathException xPathException) {
                                ((ConfigurationReader)object).f.add(xPathException);
                            }
                            ((ConfigurationReader)object).config.registerCollation((String)object4, stringCollator);
                            break;
                        }
                        case "localizations": {
                            LocalizerFactory localizerFactory;
                            if (!"localization".equals(object2)) {
                                this.a((String)object2, null, null, "localization");
                                break;
                            }
                            object2 = object4;
                            object = this;
                            String string = null;
                            object4 = new Properties();
                            for (int i9 = 0; i9 < object2.getLength(); ++i9) {
                                if (!object2.getURI(i9).isEmpty()) continue;
                                String string10 = object2.getLocalName(i9);
                                String string11 = object2.getValue(i9);
                                if ("lang".equals(string10) && !string11.isEmpty()) {
                                    string = string11;
                                    continue;
                                }
                                if (string11.isEmpty()) continue;
                                ((Properties)object4).setProperty(string10, string11);
                            }
                            if (string != null && (localizerFactory = ((ConfigurationReader)object).config.getLocalizerFactory()) != null) {
                                localizerFactory.setLanguageProperties(string, (Properties)object4);
                                break;
                            }
                            break block75;
                        }
                        case "xslt": {
                            if ("extensionElement".equals(object2)) {
                                this.readExtensionElement((Attributes)object4);
                                break;
                            }
                            this.a((String)object2, null, null, null);
                            break;
                        }
                        case "xsltPackages": {
                            if ("package".equals(object2)) {
                                this.readXsltPackage((Attributes)object4);
                            } else {
                                break;
                            }
                        }
                    }
                    break block75;
                }
                if (this.a == 3 && "package".equals(this.c)) {
                    if ("withParam".equals(object2)) {
                        this.readWithParam((Attributes)object4);
                    } else {
                        this.a((String)object2, null, null, null);
                    }
                }
                break block75;
            }
            this.f.add(new XPathException("Configuration elements must be in namespace http://saxon.sf.net/ns/configuration"));
        }
        ++this.a;
        this.h.push(new ArrayList());
    }

    private void a(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            try {
                this.config.setConfigurationProperty(string2, string3);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object object = illegalArgumentException;
                object = illegalArgumentException.getMessage();
                if (((String)object).startsWith(string2)) {
                    object = ((String)object).replace(string2, "Value");
                }
                if (((String)object).startsWith("Unknown configuration property")) {
                    object = "Property not available in Saxon-" + this.config.getEditionCode();
                }
                this.a(properties.getProperty("#element"), string, string3, (String)object);
            }
        }
    }

    protected void readExtensionElement(Attributes object) {
        object = new XPathException("Extension elements are not available in Saxon-HE");
        ((TransformerException)object).setLocator(ExplicitLocation.makeFromSax(this.g));
        this.f.add((XPathException)object);
    }

    protected void readXsltPackage(Attributes attributes) {
        Object object = attributes.getValue("name");
        if (object == null) {
            String string = "exportLocation";
            String string2 = attributes.getValue("exportLocation");
            URI uRI = null;
            if (string2 == null) {
                string = "sourceLocation";
                string2 = attributes.getValue("sourceLocation");
            }
            if (string2 == null) {
                this.a("package", string, null, null);
            }
            try {
                uRI = ResolveURI.makeAbsolute(string2, this.g.getSystemId());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.a("package", string, string2, "Requires a valid URI.");
            }
            object = new File(uRI);
            try {
                this.i.addPackage((File)object);
            }
            catch (XPathException xPathException) {
                this.error(xPathException);
                return;
            }
        }
        Object object2 = attributes.getValue("version");
        if (object2 == null) {
            object2 = "1";
        }
        VersionedPackageName versionedPackageName = null;
        PackageDetails packageDetails = new PackageDetails();
        try {
            versionedPackageName = new VersionedPackageName((String)object, (String)object2);
        }
        catch (XPathException xPathException) {
            this.a("package", "version", (String)object2, null);
        }
        packageDetails.nameAndVersion = versionedPackageName;
        this.j = packageDetails;
        object = attributes.getValue("sourceLocation");
        object2 = null;
        if (object != null) {
            try {
                object2 = new StreamSource(ResolveURI.makeAbsolute((String)object, this.g.getSystemId()).toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.a("package", "sourceLocation", (String)object, "Requires a valid URI.");
            }
            packageDetails.sourceLocation = object2;
        }
        if ((object = attributes.getValue("exportLocation")) != null) {
            try {
                object2 = new StreamSource(ResolveURI.makeAbsolute((String)object, this.g.getSystemId()).toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.a("package", "exportLocation", (String)object, "Requires a valid URI.");
            }
            packageDetails.exportLocation = object2;
        }
        if ((object = attributes.getValue("priority")) != null) {
            try {
                packageDetails.priority = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.a("package", "priority", (String)object, "Requires an integer.");
            }
        }
        packageDetails.baseName = attributes.getValue("base");
        packageDetails.shortName = attributes.getValue("shortName");
        this.i.addPackage(packageDetails);
    }

    protected void readWithParam(Attributes object) {
        Object object2;
        if (this.j.exportLocation != null) {
            this.a("withParam", null, null, "Not allowed when @exportLocation exists");
        }
        if ((object2 = object.getValue("name")) == null) {
            this.a("withParam", "name", null, null);
        }
        Object object3 = new QNameParser(this);
        ((QNameParser)object3).setAcceptEQName(true);
        StructuredQName structuredQName = null;
        try {
            structuredQName = ((QNameParser)object3).parse((CharSequence)object2);
        }
        catch (XPathException xPathException) {
            this.a("withParam", "name", (String)object2, "Requires valid QName");
        }
        object = object.getValue("select");
        if (object == null) {
            this.a("withParam", "select", null, null);
        }
        object2 = new IndependentContext(this.config);
        ((IndependentContext)object2).setNamespaceResolver(this);
        object3 = new XPathParser();
        GroundedValue<?> groundedValue = null;
        try {
            object = ((XPathParser)object3).parse((String)object, 0, 0, (StaticContext)object2);
            groundedValue = ((Expression)object).iterate(((AbstractStaticContext)object2).makeEarlyEvaluationContext()).materialize();
        }
        catch (XPathException xPathException) {
            this.error(xPathException);
        }
        if (this.j.staticParams == null) {
            this.j.staticParams = new HashMap();
        }
        this.j.staticParams.put(structuredQName, groundedValue);
    }

    private void a(String object, String string, String string2, String string3) {
        object = string == null ? new XPathException("Invalid configuration element " + (String)object) : (string2 == null ? new XPathException("Missing configuration property " + (String)object + "/@" + string) : new XPathException("Invalid configuration property " + (String)object + "/@" + string + ". Supplied value '" + string2 + "'. " + string3));
        ((TransformerException)object).setLocator(ExplicitLocation.makeFromSax(this.g));
        this.f.add((XPathException)object);
    }

    protected void error(XPathException xPathException) {
        xPathException.setLocator(ExplicitLocation.makeFromSax(this.g));
        this.f.add(xPathException);
    }

    protected void errorClass(String object, String string, String string2, Class clazz, Exception exception) {
        object = new XPathException("Invalid configuration property " + (String)object + (string == null ? "" : "/@" + string) + ". Supplied value '" + string2 + "', required value is the name of a class that implements '" + clazz.getName() + "'", exception);
        ((TransformerException)object).setLocator(ExplicitLocation.makeFromSax(this.g));
        this.f.add((XPathException)object);
    }

    @Override
    public void endElement(String string, String object, String string2) {
        if (this.a == 3 && "resources".equals(this.b) && !(string = this.d.toString()).isEmpty()) {
            if ("externalObjectModel".equals(object)) {
                try {
                    object = (ExternalObjectModel)this.config.getInstance(string, null);
                    this.config.registerExternalObjectModel((ExternalObjectModel)object);
                }
                catch (ClassCastException | XPathException exception) {
                    this.errorClass("externalObjectModel", null, string, ExternalObjectModel.class, exception);
                }
            } else if ("extensionFunction".equals(object)) {
                try {
                    object = (ExtensionFunctionDefinition)this.config.getInstance(string, null);
                    this.config.registerExtensionFunction((ExtensionFunctionDefinition)object);
                }
                catch (ClassCastException | IllegalArgumentException | XPathException exception) {
                    this.errorClass("extensionFunction", null, string, ExtensionFunctionDefinition.class, exception);
                }
            } else if ("schemaDocument".equals(object)) {
                try {
                    object = this.a(string);
                    this.config.addSchemaSource((Source)object);
                }
                catch (SchemaException schemaException) {
                    this.f.add(XPathException.makeXPathException(schemaException));
                }
                catch (XPathException xPathException) {
                    this.f.add(xPathException);
                }
            } else if ("schemaComponentModel".equals(object)) {
                try {
                    object = this.a(string);
                    this.config.importComponents((Source)object);
                }
                catch (XPathException xPathException) {
                    this.f.add(xPathException);
                }
            } else if (!"fileExtension".equals(object)) {
                this.a((String)object, null, null, null);
            }
        }
        --this.a;
        this.d.setLength(0);
        this.h.pop();
    }

    private Source a(String object) {
        try {
            String string = this.g.getSystemId();
            object = ResolveURI.makeAbsolute((String)object, string);
            return new StreamSource(((URI)object).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException(uRISyntaxException);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        this.d.append(cArray, n2, n3);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public String getURIForPrefix(String string, boolean n2) {
        for (n2 = this.h.size() - 1; n2 >= 0; --n2) {
            Object object = (List)this.h.get(n2);
            object = object.iterator();
            while (object.hasNext()) {
                String[] stringArray = (String[])object.next();
                if (!stringArray[0].equals(string)) continue;
                return stringArray[1];
            }
        }
        return null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (List list : this.h) {
            for (String[] stringArray : list) {
                hashSet.add(stringArray[0]);
            }
        }
        return hashSet.iterator();
    }
}

