/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.Arrays;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntHashMap;

public class DecimalSymbols {
    public static final int DECIMAL_SEPARATOR = 0;
    public static final int GROUPING_SEPARATOR = 1;
    public static final int DIGIT = 2;
    public static final int MINUS_SIGN = 3;
    public static final int PERCENT = 4;
    public static final int PER_MILLE = 5;
    public static final int ZERO_DIGIT = 6;
    public static final int EXPONENT_SEPARATOR = 7;
    public static final int PATTERN_SEPARATOR = 8;
    public static final int INFINITY = 9;
    public static final int NAN = 10;
    private static String[] a = new String[]{"XTSE0020", "XTSE1295", "XTSE1300", "XTSE1290"};
    private static String[] b = new String[]{"XQST0097", "XQST0097", "XQST0098", "XQST0114"};
    private String[] c = a;
    private String d;
    private String e;
    public static final String[] propertyNames = new String[]{"decimal-separator", "grouping-separator", "digit", "minus-sign", "percent", "per-mille", "zero-digit", "exponent-separator", "pattern-separator", "infinity", "NaN"};
    private int[] f = new int[propertyNames.length - 2];
    private int[] g = new int[propertyNames.length];
    private boolean[] h = new boolean[propertyNames.length];
    private static int[] i = new int[]{48, 1632, 1776, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3664, 3792, 3872, 4160, 6112, 6160, 6470, 6608, 65296, 66720, 120782, 120792, 120802, 120812, 120822};

    public DecimalSymbols(int n2, int n3) {
        this.f[0] = 46;
        this.f[1] = 44;
        this.f[2] = 35;
        this.f[3] = 45;
        this.f[4] = 37;
        this.f[5] = 8240;
        this.f[6] = 48;
        this.f[7] = 101;
        this.f[8] = 59;
        this.d = "Infinity";
        this.e = "NaN";
        Arrays.fill(this.g, Integer.MIN_VALUE);
        this.setHostLanguage(n2, n3);
    }

    public void setHostLanguage(int n2, int n3) {
        if (n2 == 51) {
            this.c = b;
            return;
        }
        this.c = a;
    }

    public int getDecimalSeparator() {
        return this.f[0];
    }

    public int getGroupingSeparator() {
        return this.f[1];
    }

    public int getDigit() {
        return this.f[2];
    }

    public int getMinusSign() {
        return this.f[3];
    }

    public int getPercent() {
        return this.f[4];
    }

    public int getPerMille() {
        return this.f[5];
    }

    public int getZeroDigit() {
        return this.f[6];
    }

    public int getExponentSeparator() {
        return this.f[7];
    }

    public int getPatternSeparator() {
        return this.f[8];
    }

    public String getInfinity() {
        return this.d;
    }

    public String getNaN() {
        return this.e;
    }

    public void setDecimalSeparator(String string) {
        this.setProperty(0, string, 0);
    }

    public void setGroupingSeparator(String string) {
        this.setProperty(1, string, 0);
    }

    public void setDigit(String string) {
        this.setProperty(2, string, 0);
    }

    public void setMinusSign(String string) {
        this.setProperty(3, string, 0);
    }

    public void setPercent(String string) {
        this.setProperty(4, string, 0);
    }

    public void setPerMille(String string) {
        this.setProperty(5, string, 0);
    }

    public void setZeroDigit(String string) {
        this.setProperty(6, string, 0);
    }

    public void setExponentSeparator(String string) {
        this.setProperty(7, string, 0);
    }

    public void setPatternSeparator(String string) {
        this.setProperty(8, string, 0);
    }

    public void setInfinity(String string) {
        this.setProperty(9, string, 0);
    }

    public void setNaN(String string) {
        this.setProperty(10, string, 0);
    }

    public void setProperty(int n2, String object, int n3) {
        String string = propertyNames[n2];
        if (n2 <= 8) {
            CharSequence charSequence = object;
            object = this;
            if (((UnicodeString)(charSequence = UnicodeString.makeUnicodeString(charSequence))).uLength() != 1) {
                XPathException xPathException = new XPathException("Attribute " + string + " should be a single character", ((DecimalSymbols)object).c[0]);
                xPathException.setIsStaticError(true);
                throw xPathException;
            }
            int n4 = ((UnicodeString)charSequence).uCharAt(0);
            if (n3 > this.g[n2]) {
                this.f[n2] = n4;
                this.g[n2] = n3;
                this.h[n2] = false;
            } else if (n3 == this.g[n2] && n4 != this.f[n2]) {
                this.h[n2] = true;
            }
            if (n2 == 6 && !DecimalSymbols.isValidZeroDigit(n4)) {
                throw new XPathException("The value of the zero-digit attribute must be a Unicode digit with value zero", this.c[1]);
            }
            return;
        }
        if (n2 == 9) {
            if (n3 > this.g[n2]) {
                this.d = object;
                this.g[n2] = n3;
                this.h[n2] = false;
                return;
            }
            if (n3 == this.g[n2] && !this.d.equals(object)) {
                this.h[n2] = true;
                return;
            }
        } else if (n2 == 10) {
            if (n3 > this.g[n2]) {
                this.e = object;
                this.g[n2] = n3;
                this.h[n2] = false;
                return;
            }
            if (n3 == this.g[n2] && !this.e.equals(object)) {
                this.h[n2] = false;
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setIntProperty(String string, int n2) {
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            if (!propertyNames[i2].equals(string)) continue;
            this.f[i2] = n2;
        }
    }

    public void export(StructuredQName structuredQName, ExpressionPresenter expressionPresenter) {
        DecimalSymbols decimalSymbols = new DecimalSymbols(50, 31);
        expressionPresenter.startElement("decimalFormat");
        if (structuredQName != null) {
            expressionPresenter.emitAttribute("name", structuredQName);
        }
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            int n2 = this.f[i2];
            if (n2 == decimalSymbols.f[i2]) continue;
            expressionPresenter.emitAttribute(propertyNames[i2], "" + n2);
        }
        if (!"Infinity".equals(this.getInfinity())) {
            expressionPresenter.emitAttribute("infinity", this.getInfinity());
        }
        if (!"NaN".equals(this.getNaN())) {
            expressionPresenter.emitAttribute("NaN", this.getNaN());
        }
        expressionPresenter.endElement();
    }

    public void checkConsistency(StructuredQName object) {
        int n2;
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!this.h[i2]) continue;
            XPathException xPathException = new XPathException("Inconsistency in " + (object == null ? "unnamed decimal format. " : "decimal format " + ((StructuredQName)object).getDisplayName() + ". ") + "There are two inconsistent values for decimal-format property " + propertyNames[i2] + " at the same import precedence");
            xPathException.setErrorCode(this.c[3]);
            xPathException.setIsStaticError(true);
            throw xPathException;
        }
        IntHashMap<String> intHashMap = new IntHashMap<String>(20);
        intHashMap.put(this.getDecimalSeparator(), "decimal-separator");
        if (intHashMap.get(this.getGroupingSeparator()) != null) {
            this.a("grouping-separator", (String)intHashMap.get(this.getGroupingSeparator()), (StructuredQName)object);
        }
        intHashMap.put(this.getGroupingSeparator(), "grouping-separator");
        if (intHashMap.get(this.getPercent()) != null) {
            this.a("percent", (String)intHashMap.get(this.getPercent()), (StructuredQName)object);
        }
        intHashMap.put(this.getPercent(), "percent");
        if (intHashMap.get(this.getPerMille()) != null) {
            this.a("per-mille", (String)intHashMap.get(this.getPerMille()), (StructuredQName)object);
        }
        intHashMap.put(this.getPerMille(), "per-mille");
        if (intHashMap.get(this.getDigit()) != null) {
            this.a("digit", (String)intHashMap.get(this.getDigit()), (StructuredQName)object);
        }
        intHashMap.put(this.getDigit(), "digit");
        if (intHashMap.get(this.getPatternSeparator()) != null) {
            this.a("pattern-separator", (String)intHashMap.get(this.getPatternSeparator()), (StructuredQName)object);
        }
        intHashMap.put(this.getPatternSeparator(), "pattern-separator");
        if (intHashMap.get(this.getExponentSeparator()) != null) {
            this.a("exponent-separator", (String)intHashMap.get(this.getExponentSeparator()), (StructuredQName)object);
        }
        intHashMap.put(this.getExponentSeparator(), "exponent-separator");
        for (int i3 = n2 = this.getZeroDigit(); i3 < n2 + 10; ++i3) {
            if (intHashMap.get(i3) == null) continue;
            object = new XPathException("Inconsistent properties in " + (object == null ? "unnamed decimal format. " : "decimal format " + ((StructuredQName)object).getDisplayName() + ". ") + "The same character is used as digit " + (i3 - n2) + " in the chosen digit family, and as the " + (String)intHashMap.get(i3));
            ((XPathException)object).setErrorCode(this.c[2]);
            throw object;
        }
    }

    private void a(String object, String string, StructuredQName structuredQName) {
        object = new XPathException("Inconsistent properties in " + (structuredQName == null ? "unnamed decimal format. " : "decimal format " + structuredQName.getDisplayName() + ". ") + "The same character is used as the " + (String)object + " and as the " + string);
        ((XPathException)object).setErrorCode(this.c[2]);
        throw object;
    }

    public static boolean isValidZeroDigit(int n2) {
        return Arrays.binarySearch(i, n2) >= 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalSymbols)) {
            return false;
        }
        object = (DecimalSymbols)object;
        return this.getDecimalSeparator() == ((DecimalSymbols)object).getDecimalSeparator() && this.getGroupingSeparator() == ((DecimalSymbols)object).getGroupingSeparator() && this.getDigit() == ((DecimalSymbols)object).getDigit() && this.getMinusSign() == ((DecimalSymbols)object).getMinusSign() && this.getPercent() == ((DecimalSymbols)object).getPercent() && this.getPerMille() == ((DecimalSymbols)object).getPerMille() && this.getZeroDigit() == ((DecimalSymbols)object).getZeroDigit() && this.getPatternSeparator() == ((DecimalSymbols)object).getPatternSeparator() && this.getInfinity().equals(((DecimalSymbols)object).getInfinity()) && this.getNaN().equals(((DecimalSymbols)object).getNaN());
    }

    public int hashCode() {
        return this.getDecimalSeparator() + 37 * this.getGroupingSeparator() + 41 * this.getDigit();
    }
}

