/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.InputStream;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.serialize.MessageEmitter;
import net.sf.saxon.trans.XPathException;

public class DynamicLoader {
    private ClassLoader a;
    protected HashMap<String, Class> knownClasses = new HashMap(20);

    public DynamicLoader() {
        this.registerKnownClasses();
    }

    protected void registerKnownClasses() {
        this.knownClasses.put("net.sf.saxon.serialize.MessageEmitter", MessageEmitter.class);
        this.knownClasses.put("net.sf.saxon.Configuration", Configuration.class);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.a = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.a;
    }

    public Class getClass(String string, Logger logger, ClassLoader classLoader) {
        Class clazz = this.knownClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        boolean bl2 = logger != null;
        if (bl2) {
            logger.info("Loading " + string);
        }
        try {
            if (classLoader == null) {
                classLoader = this.a;
            }
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (Throwable throwable) {
                    return Class.forName(string);
                }
            }
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            if (bl2) {
                logger.error("The class " + string + " could not be loaded: " + throwable.getMessage());
            }
            throw new XPathException("Failed to load " + string + this.b(string), throwable);
        }
    }

    public Object getInstance(String string, ClassLoader object) {
        object = this.getClass(string, null, (ClassLoader)object);
        try {
            return ((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new XPathException("Failed to instantiate class " + string + " (does it have a public zero-argument constructor?)", exception);
        }
    }

    public Object getInstance(String string, Logger object, ClassLoader classLoader) {
        object = this.getClass(string, (Logger)object, classLoader);
        try {
            return ((Class)object).newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new XPathException("Failed to load instance of class " + string + this.b(string), noClassDefFoundError);
        }
        catch (Exception exception) {
            throw new XPathException("Failed to instantiate class " + string, exception);
        }
    }

    private static String a(String string) {
        if (string.startsWith("net.sf.saxon.option.sql.")) {
            return "saxon9-sql.jar";
        }
        if (string.startsWith("com.saxonica.StatsTransform")) {
            return "saxon9-stats.jar";
        }
        if (string.startsWith("com.ibm.icu.")) {
            return "saxon9-icu.jar";
        }
        if (string.startsWith("com.saxonica")) {
            return "saxon9ee.jar";
        }
        return null;
    }

    private String b(String string) {
        if ((string = DynamicLoader.a(string)) == null) {
            return "";
        }
        return ". Check that " + string + " is on the classpath";
    }

    public InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader.getResourceAsStream(string);
    }
}

