/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class Err {
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int FUNCTION = 3;
    public static final int VALUE = 4;
    public static final int VARIABLE = 5;
    public static final int GENERAL = 6;
    public static final int URI = 7;

    public static String wrap(CharSequence charSequence) {
        return Err.wrap(charSequence, 6);
    }

    /*
     * Unable to fully structure code
     */
    public static String wrap(CharSequence var0, int var1_1) {
        block22: {
            block23: {
                if (var0 == null) {
                    return "(NULL)";
                }
                var2_2 = new FastStringBuffer(64);
                var3_3 = var0.length();
                block14: for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                    var5_6 = var0.charAt(var4_4);
                    switch (var5_6) {
                        case '\n': {
                            var2_2.append("\\n");
                            continue block14;
                        }
                        case '\t': {
                            var2_2.append("\\t");
                            continue block14;
                        }
                        case '\r': {
                            var2_2.append("\\r");
                            continue block14;
                        }
                        default: {
                            if (var5_6 < ' ') {
                                var2_2.append("\\x");
                                var2_2.append(Integer.toHexString(var5_6));
                                continue block14;
                            }
                            var2_2.append(var5_6);
                        }
                    }
                }
                if (var1_1 != 1 && var1_1 != 2) break block23;
                var4_5 = var2_2.toString();
                if (var4_5.startsWith("{")) {
                    var4_5 = "Q" + var4_5;
                }
                if (!var4_5.startsWith("Q{")) break block22;
                try {
                    var5_7 = StructuredQName.fromEQName(var2_2.toString());
                    var0 = Err.abbreviateURI(var5_7.getURI());
                    var4_5 = "Q{" + (String)var0 + "}" + var5_7.getLocalPart();
                    break block22;
                }
                catch (Exception v0) {
                    ** GOTO lbl-1000
                }
            }
            if (var1_1 == 7) {
                v1 = Err.abbreviateURI(var2_2.toString());
            } else if (var3_3 > 30) {
                v1 = var2_2.toString().substring(0, 30) + "...";
            } else lbl-1000:
            // 2 sources

            {
                v1 = var2_2.toString();
            }
            var4_5 = v1;
        }
        switch (var1_1) {
            case 1: {
                return "<" + var4_5 + ">";
            }
            case 2: {
                return "@" + var4_5;
            }
            case 3: {
                return var4_5 + "()";
            }
            case 5: {
                return "$" + var4_5;
            }
            case 4: {
                return "\"" + var4_5 + "\"";
            }
        }
        return "{" + var4_5 + "}";
    }

    public static CharSequence depict(Item item) {
        if (item instanceof NodeInfo) {
            item = (NodeInfo)item;
            switch (item.getNodeKind()) {
                case 9: {
                    return "doc(" + Err.abbreviateURI(item.getSystemId()) + ')';
                }
                case 1: {
                    return "<" + item.getDisplayName() + '>';
                }
                case 2: {
                    return "@" + item.getDisplayName() + "=\"" + item.getStringValueCS() + '\"';
                }
                case 3: {
                    return "text{" + Err.truncate30(item.getStringValueCS()) + "}";
                }
                case 8: {
                    return "<!--...-->";
                }
                case 7: {
                    return "<?" + item.getLocalPart() + "...?>";
                }
                case 13: {
                    return "xmlns:" + item.getLocalPart() + "=" + Err.abbreviateURI(item.getStringValue());
                }
            }
            return "";
        }
        return item.toShortString();
    }

    public static CharSequence depictSequence(Sequence<?> sequence) {
        if (sequence == null) {
            return "(*null*)";
        }
        try {
            GroundedValue<?> groundedValue = sequence.materialize();
            if (groundedValue.getLength() == 0) {
                return "()";
            }
            if (groundedValue.getLength() == 1) {
                return Err.depict(sequence.head());
            }
            return Err.depictSequenceStart(groundedValue.iterate(), 3, groundedValue.getLength());
        }
        catch (Exception exception) {
            return "(*unreadable*)";
        }
    }

    public static String depictSequenceStart(SequenceIterator sequenceIterator, int n2, int n3) {
        try {
            Object t2;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            int n4 = 0;
            fastStringBuffer.append(" (");
            while ((t2 = sequenceIterator.next()) != null) {
                if (n4++ > 0) {
                    fastStringBuffer.append(", ");
                }
                if (n4 > n2) {
                    fastStringBuffer.append("... [" + n3 + "])");
                    return fastStringBuffer.toString();
                }
                fastStringBuffer.append(Err.depict(t2));
            }
            fastStringBuffer.append(") ");
            return fastStringBuffer.toString();
        }
        catch (XPathException xPathException) {
            return "";
        }
    }

    public static CharSequence truncate30(CharSequence charSequence) {
        if (charSequence.length() <= 30) {
            return Whitespace.collapseWhitespace(charSequence);
        }
        return Whitespace.collapseWhitespace(charSequence.subSequence(0, 30)) + "...";
    }

    public static String abbreviateURI(String string) {
        if (string == null) {
            return "";
        }
        int n2 = (string.endsWith("/") ? string.substring(0, string.length() - 1) : string).lastIndexOf(47);
        if (n2 < 0) {
            if (string.length() > 15) {
                String string2 = string;
                string = "..." + string2.substring(string2.length() - 15);
            }
            return string;
        }
        return "..." + string.substring(n2);
    }

    public static String wrap(Expression expression) {
        if (ExpressionTool.expressionSize(expression) < 10 && !(expression instanceof Instruction)) {
            return "{" + expression + "}";
        }
        return expression.getExpressionName();
    }
}

