/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class KeyIndex {
    private Map<AtomicMatchKey, List<NodeInfo>> a;
    private UType b = UType.VOID;
    private UType c = UType.STRING_LIKE;
    private List<UntypedAtomicValue> d;
    private ConversionRules e;
    private int f;
    private StringCollator g;
    private long h;
    private Status i;

    public KeyIndex(boolean bl2) {
        this.a = bl2 ? new TreeMap() : new HashMap(100);
        this.h = Thread.currentThread().getId();
        this.i = Status.UNDER_CONSTRUCTION;
    }

    public Map<AtomicMatchKey, List<NodeInfo>> getUnderlyingMap() {
        return this.a;
    }

    public boolean isCreatedInThisThread() {
        return this.h == Thread.currentThread().getId();
    }

    public Status getStatus() {
        return this.i;
    }

    public void setStatus(Status status) {
        this.i = status;
    }

    public void buildIndex(KeyDefinitionSet object, TreeInfo treeInfo, XPathContext xPathContext) {
        object = ((KeyDefinitionSet)object).getKeyDefinitions();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            boolean bl2 = i2 == 0;
            XPathContext xPathContext2 = xPathContext;
            KeyDefinition keyDefinition = (KeyDefinition)object.get(i2);
            TreeInfo treeInfo2 = treeInfo;
            KeyIndex keyIndex = this;
            Pattern pattern = keyDefinition.getMatch();
            xPathContext2 = xPathContext2.newContext();
            ((XPathContextMajor)xPathContext2).setOrigin(keyDefinition);
            ((XPathContextMajor)xPathContext2).setCurrentComponent(keyDefinition.getDeclaringComponent());
            ((XPathContextMinor)xPathContext2).setTemporaryOutputState(165);
            SlotManager slotManager = keyDefinition.getStackFrameMap();
            if (slotManager != null) {
                ((XPathContextMajor)xPathContext2).openStackFrame(slotManager);
            }
            pattern.selectNodes(treeInfo2, xPathContext2).forEachOrFail(arg_0 -> keyIndex.a(keyDefinition, (XPathContextMajor)xPathContext2, bl2, arg_0));
        }
        this.e = xPathContext.getConfiguration().getConversionRules();
        this.f = xPathContext.getImplicitTimezone();
        this.g = ((KeyDefinition)object.get(0)).getCollation();
    }

    private void a(AtomicMatchKey object, NodeInfo nodeInfo, boolean bl2) {
        List<NodeInfo> list = this.a.get(object);
        if (list == null) {
            list = new ArrayList<NodeInfo>(4);
            this.a.put((AtomicMatchKey)object, list);
            list.add(nodeInfo);
            return;
        }
        if (bl2) {
            List<NodeInfo> list2 = list;
            if (list2.get(list2.size() - 1) != nodeInfo) {
                list.add(nodeInfo);
                return;
            }
        } else {
            object = LocalOrderComparer.getInstance();
            bl2 = false;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                int n2 = ((LocalOrderComparer)object).compare(nodeInfo, list.get(i2));
                if (n2 < 0) continue;
                if (n2 != 0) {
                    list.add(i2 + 1, nodeInfo);
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                list.add(0, nodeInfo);
            }
        }
    }

    public void reindexUntypedValues(BuiltInAtomicType object) {
        UType uType = ((BuiltInAtomicType)object).getUType();
        if (UType.STRING_LIKE.subsumes(uType)) {
            return;
        }
        if (UType.NUMERIC.subsumes(uType)) {
            object = BuiltInAtomicType.DOUBLE;
        }
        object = ((BuiltInAtomicType)object).getStringConverter(this.e);
        for (UntypedAtomicValue untypedAtomicValue : this.d) {
            Iterator iterator = KeyIndex.a(untypedAtomicValue, this.g, this.f);
            iterator = this.a.get(iterator);
            AtomicValue atomicValue = ((StringConverter)object).convertString(untypedAtomicValue.getStringValueCS()).asAtomic();
            AtomicMatchKey object2 = KeyIndex.a(atomicValue, this.g, this.f);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)iterator.next();
                this.a(object2, nodeInfo, false);
            }
        }
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public List<NodeInfo> get(AtomicValue atomicValue) {
        if (this.d != null && !this.c.subsumes(atomicValue.getUType())) {
            this.reindexUntypedValues(atomicValue.getPrimitiveType());
        }
        return this.a.get(KeyIndex.a(atomicValue, this.g, this.f));
    }

    public List<NodeInfo> getComposite(SequenceIterator<?> sequenceIterator) {
        ArrayList<AtomicMatchKey> arrayList = new ArrayList<AtomicMatchKey>(4);
        sequenceIterator.forEachOrFail(item -> arrayList.add(KeyIndex.a((AtomicValue)item, this.g, this.f)));
        return this.a.get(new a(this, arrayList));
    }

    private static AtomicMatchKey a(AtomicValue atomicValue, StringCollator stringCollator, int n2) {
        if (UType.STRING_LIKE.subsumes(atomicValue.getUType())) {
            if (stringCollator == null) {
                return new CodepointMatchKey(atomicValue.getStringValue());
            }
            return stringCollator.getCollationKey(atomicValue.getStringValue());
        }
        return atomicValue.getXPathComparable(false, stringCollator, n2);
    }

    private static /* synthetic */ void a(List list, StringCollator stringCollator, int n2, Item item) {
        list.add(KeyIndex.a((AtomicValue)item, stringCollator, n2));
    }

    private /* synthetic */ void a(KeyDefinition object, XPathContextMajor object2, boolean bl2, NodeInfo sequenceIterator) {
        NodeInfo nodeInfo = sequenceIterator;
        boolean bl3 = bl2;
        sequenceIterator = object2;
        KeyDefinition keyDefinition = object;
        object2 = nodeInfo;
        object = this;
        Object object3 = new ManualIterator<Object>(object2);
        sequenceIterator.setCurrentIterator((FocusIterator<?>)object3);
        object3 = keyDefinition.getCollation();
        int n2 = sequenceIterator.getImplicitTimezone();
        Object object4 = keyDefinition.getUse();
        sequenceIterator = ((Expression)object4).iterate((XPathContext)((Object)sequenceIterator));
        if (keyDefinition.isComposite()) {
            object4 = new ArrayList(4);
            sequenceIterator.forEachOrFail(arg_0 -> KeyIndex.a((List)object4, (StringCollator)object3, n2, arg_0));
            super.a(new a((KeyIndex)object, (List<AtomicMatchKey>)object4), (NodeInfo)object2, bl3);
            return;
        }
        while ((object4 = (AtomicValue)sequenceIterator.next()) != null) {
            if (((AtomicValue)object4).isNaN()) continue;
            UType uType = ((AtomicValue)object4).getUType();
            if (!((KeyIndex)object).b.subsumes(uType)) {
                ((KeyIndex)object).b = ((KeyIndex)object).b.union(uType);
            }
            AtomicMatchKey atomicMatchKey = KeyIndex.a((AtomicValue)object4, (StringCollator)object3, n2);
            if (uType.equals(UType.UNTYPED_ATOMIC) && keyDefinition.isConvertUntypedToOther()) {
                if (((KeyIndex)object).d == null) {
                    ((KeyIndex)object).d = new ArrayList<UntypedAtomicValue>(20);
                }
                ((KeyIndex)object).d.add((UntypedAtomicValue)object4);
            }
            super.a(atomicMatchKey, (NodeInfo)object2, bl3);
        }
    }

    private final class a
    implements AtomicMatchKey {
        private List<AtomicMatchKey> a;
        private /* synthetic */ KeyIndex b;

        public a(KeyIndex keyIndex, List<AtomicMatchKey> list) {
            this.b = keyIndex;
            this.a = list;
        }

        @Override
        public final AtomicValue asAtomic() {
            throw new UnsupportedOperationException();
        }

        public final boolean equals(Object list) {
            if (list instanceof a && ((a)((Object)list)).a.size() == this.a.size()) {
                list = ((a)((Object)list)).a;
                for (int i2 = 0; i2 < this.a.size(); ++i2) {
                    if (this.a.get(i2).equals(list.get(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public final int hashCode() {
            int n2 = -1968014122;
            for (AtomicMatchKey atomicMatchKey : this.a) {
                n2 ^= atomicMatchKey.hashCode();
                n2 <<= 1;
            }
            return n2;
        }
    }

    public static enum Status {
        UNDER_CONSTRUCTION,
        BUILT,
        FAILED;

    }
}

