/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.functions.IsIdRef;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyIndex;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntHashMap;

public class KeyManager {
    private PackageData a;
    private HashMap<StructuredQName, KeyDefinitionSet> b;
    private transient WeakHashMap<TreeInfo, WeakReference<IntHashMap<KeyIndex>>> c;

    public KeyManager(Configuration configuration, PackageData packageData) {
        this.a = packageData;
        this.b = new HashMap(10);
        this.c = new WeakHashMap(10);
        this.a(configuration);
    }

    private synchronized void a(Configuration configuration) {
        StructuredQName structuredQName = StandardNames.getStructuredQName(562);
        Object object = new SymbolicName(165, structuredQName);
        if (this.getKeyDefinitionSet(structuredQName) == null) {
            BasePatternWithPredicate basePatternWithPredicate = new BasePatternWithPredicate(new NodeTestPattern(new MultipleNodeKindTest(UType.ELEMENT_OR_ATTRIBUTE)), IntegratedFunctionLibrary.makeFunctionCall(new IsIdRef(), new Expression[0]));
            try {
                Object object2 = new IndependentContext(configuration);
                ((AbstractStaticContext)object2).setPackageData(this.a);
                ((AbstractStaticContext)object2).setXPathLanguageLevel(31);
                object2 = new RetainedStaticContext((StaticContext)object2);
                Expression expression = SystemFunction.makeCall("string", (RetainedStaticContext)object2, new ContextItemExpression());
                object2 = SystemFunction.makeCall("tokenize", (RetainedStaticContext)object2, expression);
                object = new KeyDefinition((SymbolicName)object, basePatternWithPredicate, (Expression)object2, null, null);
                ((Actor)object).setPackageData(this.a);
                ((KeyDefinition)object).setIndexedItemType(BuiltInAtomicType.STRING);
                this.addKeyDefinition(structuredQName, (KeyDefinition)object, true, configuration);
                return;
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)xPathException);
            }
        }
    }

    public synchronized void preRegisterKeyDefinition(StructuredQName structuredQName) {
        KeyDefinitionSet keyDefinitionSet = this.b.get(structuredQName);
        if (keyDefinitionSet == null) {
            keyDefinitionSet = new KeyDefinitionSet(structuredQName, this.b.size());
            this.b.put(structuredQName, keyDefinitionSet);
        }
    }

    public synchronized void addKeyDefinition(StructuredQName structuredQName, KeyDefinition keyDefinition, boolean bl2, Configuration configuration) {
        boolean bl3;
        KeyDefinitionSet keyDefinitionSet = this.b.get(structuredQName);
        if (keyDefinitionSet == null) {
            keyDefinitionSet = new KeyDefinitionSet(structuredQName, this.b.size());
            this.b.put(structuredQName, keyDefinitionSet);
        }
        keyDefinitionSet.addKeyDefinition(keyDefinition);
        if (!bl2) {
            keyDefinitionSet.setReusable(false);
        }
        if (bl3 = keyDefinitionSet.isBackwardsCompatible()) {
            Object object = keyDefinitionSet.getKeyDefinitions();
            object = object.iterator();
            while (object.hasNext()) {
                keyDefinition = (KeyDefinition)object.next();
                keyDefinition.setBackwardsCompatible(true);
                if (keyDefinition.getBody().getItemType().equals(BuiltInAtomicType.STRING)) continue;
                AtomicSequenceConverter atomicSequenceConverter = new AtomicSequenceConverter(keyDefinition.getBody(), BuiltInAtomicType.STRING);
                atomicSequenceConverter.allocateConverterStatically(configuration, false);
                keyDefinition.setBody(atomicSequenceConverter);
            }
        }
    }

    public KeyDefinitionSet getKeyDefinitionSet(StructuredQName structuredQName) {
        return this.b.get(structuredQName);
    }

    public KeyDefinitionSet findKeyDefinition(Pattern pattern, Expression expression, String string) {
        for (KeyDefinitionSet keyDefinitionSet : this.b.values()) {
            if (keyDefinitionSet.getKeyDefinitions().size() != 1) continue;
            for (KeyDefinition keyDefinition : keyDefinitionSet.getKeyDefinitions()) {
                if (!keyDefinition.getMatch().isEqual(pattern) || !keyDefinition.getUse().isEqual(expression) || !keyDefinition.getCollationName().equals(string)) continue;
                return keyDefinitionSet;
            }
        }
        return null;
    }

    public SequenceIterator<NodeInfo> selectByKey(KeyDefinitionSet object, TreeInfo treeInfo, AtomicValue atomicValue, XPathContext xPathContext) {
        Object object2;
        if (atomicValue == null) {
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        if (((KeyDefinitionSet)object).isBackwardsCompatible()) {
            object2 = xPathContext.getConfiguration().getConversionRules();
            atomicValue = Converter.convert(atomicValue, BuiltInAtomicType.STRING, (ConversionRules)object2).asAtomic();
        } else {
            object2 = atomicValue.getPrimitiveType();
            if (((BuiltInAtomicType)object2).equals(BuiltInAtomicType.INTEGER) || ((BuiltInAtomicType)object2).equals(BuiltInAtomicType.DECIMAL) || ((BuiltInAtomicType)object2).equals(BuiltInAtomicType.FLOAT)) {
                atomicValue = new DoubleValue(((NumericValue)atomicValue).getDoubleValue());
            }
        }
        object2 = this.obtainIndex((KeyDefinitionSet)object, treeInfo, xPathContext);
        object = ((KeyIndex)object2).get(atomicValue);
        if (object == null) {
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        return new ListIterator<NodeInfo>((List<NodeInfo>)object);
    }

    public SequenceIterator selectByCompositeKey(KeyDefinitionSet list, TreeInfo treeInfo, SequenceIterator<?> sequenceIterator, XPathContext xPathContext) {
        list = this.obtainIndex((KeyDefinitionSet)((Object)list), treeInfo, xPathContext);
        if ((list = ((KeyIndex)((Object)list)).getComposite(sequenceIterator)) == null) {
            return EmptyIterator.emptyIterator();
        }
        return new ListIterator<NodeInfo>(list);
    }

    public KeyIndex obtainIndex(KeyDefinitionSet keyDefinitionSet, TreeInfo treeInfo, XPathContext xPathContext) {
        if (keyDefinitionSet.isReusable()) {
            return this.a(keyDefinitionSet, treeInfo, xPathContext);
        }
        return this.b(keyDefinitionSet, treeInfo, xPathContext);
    }

    private KeyIndex a(KeyDefinitionSet object, TreeInfo treeInfo, XPathContext xPathContext) {
        Object object2;
        block12: {
            Object object3;
            int n2 = ((KeyDefinitionSet)object).getKeySetNumber();
            object2 = this.a(treeInfo, n2);
            if (object2 != null) {
                object3 = ((KeyIndex)object2).getStatus();
                if (object3 == KeyIndex.Status.UNDER_CONSTRUCTION) {
                    if (((KeyIndex)object2).isCreatedInThisThread()) {
                        object2 = new XPathException("Key definition " + ((KeyDefinitionSet)object).getKeyName().getDisplayName() + " is circular");
                        ((XPathException)object2).setXPathContext(xPathContext);
                        ((XPathException)object2).setErrorCode("XTDE0640");
                        throw object2;
                    }
                    object2 = null;
                } else if (object3 == KeyIndex.Status.FAILED) {
                    throw new XPathException("Construction of index for key " + ((KeyDefinitionSet)object).getKeyName().getDisplayName() + " was unsuccessful");
                }
            }
            if (object2 != null) break block12;
            object2 = new KeyIndex(((KeyDefinitionSet)object).isRangeKey());
            object3 = this;
            synchronized (object3) {
                block11: {
                    ((KeyIndex)object2).setStatus(KeyIndex.Status.UNDER_CONSTRUCTION);
                    object2 = this.a(treeInfo, n2, (KeyIndex)object2, xPathContext);
                    if (((KeyIndex)object2).getStatus() != KeyIndex.Status.BUILT) break block11;
                    return object2;
                }
            }
            XPathContext xPathContext2 = xPathContext;
            TreeInfo treeInfo2 = treeInfo;
            object3 = object;
            object = object2;
            ((KeyIndex)object).buildIndex((KeyDefinitionSet)object3, treeInfo2, xPathContext2);
            object3 = this;
            synchronized (object3) {
                ((KeyIndex)object2).setStatus(KeyIndex.Status.BUILT);
                object2 = this.a(treeInfo, n2, (KeyIndex)object2, xPathContext);
            }
        }
        return object2;
    }

    private KeyIndex b(KeyDefinitionSet object, TreeInfo treeInfo, XPathContext xPathContext) {
        Object object2;
        block12: {
            Object object3;
            int n2 = ((KeyDefinitionSet)object).getKeySetNumber();
            object2 = this.a(treeInfo, n2, xPathContext);
            if (object2 != null) {
                object3 = ((KeyIndex)object2).getStatus();
                if (object3 == KeyIndex.Status.UNDER_CONSTRUCTION) {
                    if (((KeyIndex)object2).isCreatedInThisThread()) {
                        object2 = new XPathException("Key definition " + ((KeyDefinitionSet)object).getKeyName().getDisplayName() + " is circular");
                        ((XPathException)object2).setXPathContext(xPathContext);
                        ((XPathException)object2).setErrorCode("XTDE0640");
                        throw object2;
                    }
                    object2 = null;
                } else if (object3 == KeyIndex.Status.FAILED) {
                    throw new XPathException("Construction of index for key " + ((KeyDefinitionSet)object).getKeyName().getDisplayName() + " was unsuccessful");
                }
            }
            if (object2 != null) break block12;
            object2 = new KeyIndex(((KeyDefinitionSet)object).isRangeKey());
            object3 = this;
            synchronized (object3) {
                block11: {
                    ((KeyIndex)object2).setStatus(KeyIndex.Status.UNDER_CONSTRUCTION);
                    object2 = this.b(treeInfo, n2, (KeyIndex)object2, xPathContext);
                    if (((KeyIndex)object2).getStatus() != KeyIndex.Status.BUILT) break block11;
                    return object2;
                }
            }
            XPathContext xPathContext2 = xPathContext;
            TreeInfo treeInfo2 = treeInfo;
            object3 = object;
            object = object2;
            ((KeyIndex)object).buildIndex((KeyDefinitionSet)object3, treeInfo2, xPathContext2);
            object3 = this;
            synchronized (object3) {
                ((KeyIndex)object2).setStatus(KeyIndex.Status.BUILT);
                object2 = this.b(treeInfo, n2, (KeyIndex)object2, xPathContext);
            }
        }
        return object2;
    }

    private synchronized KeyIndex a(TreeInfo treeInfo, int n2, KeyIndex keyIndex, XPathContext xPathContext) {
        Object object;
        Object object2;
        if (this.c == null) {
            this.c = new WeakHashMap(10);
        }
        if ((object2 = this.c.get(treeInfo)) == null || ((Reference)object2).get() == null) {
            object2 = new IntHashMap(10);
            object = xPathContext.getController();
            if (((Controller)object).getDocumentPool().contains(treeInfo)) {
                xPathContext.getController().setUserData(treeInfo, "saxon:key-index-list", object2);
            } else {
                treeInfo.setUserData("saxon:key-index-list", object2);
            }
            this.c.put(treeInfo, new WeakReference<Object>(object2));
        } else {
            object2 = (IntHashMap)((Reference)object2).get();
        }
        object = (KeyIndex)((IntHashMap)object2).get(n2);
        if (object == null || ((KeyIndex)object).getStatus() != KeyIndex.Status.BUILT) {
            ((IntHashMap)object2).put(n2, keyIndex);
            object = keyIndex;
        }
        return object;
    }

    private synchronized KeyIndex b(TreeInfo treeInfo, int n2, KeyIndex keyIndex, XPathContext intHashMap) {
        KeyIndex keyIndex2;
        intHashMap = intHashMap.getController();
        Map<Long, KeyIndex> map = (intHashMap = ((Controller)((Object)intHashMap)).getLocalIndexes()).get(n2);
        if (map == null) {
            map = new HashMap<Long, KeyIndex>();
            intHashMap.put(n2, map);
        }
        if ((keyIndex2 = map.get(treeInfo.getDocumentNumber())) == null || keyIndex2.getStatus() != KeyIndex.Status.BUILT) {
            map.put(treeInfo.getDocumentNumber(), keyIndex);
            keyIndex2 = keyIndex;
        }
        return keyIndex2;
    }

    private synchronized KeyIndex a(TreeInfo object, int n2) {
        if (this.c == null) {
            this.c = new WeakHashMap(10);
        }
        if ((object = this.c.get(object)) == null) {
            return null;
        }
        if ((object = (IntHashMap)((Reference)object).get()) == null) {
            return null;
        }
        return (KeyIndex)((IntHashMap)object).get(n2);
    }

    private synchronized KeyIndex a(TreeInfo treeInfo, int n2, XPathContext intHashMap) {
        intHashMap = intHashMap.getController();
        Map<Long, KeyIndex> map = (intHashMap = ((Controller)((Object)intHashMap)).getLocalIndexes()).get(n2);
        if (map == null) {
            return null;
        }
        return map.get(treeInfo.getDocumentNumber());
    }

    public synchronized void clearDocumentIndexes(TreeInfo treeInfo) {
        this.c.remove(treeInfo);
    }

    public Collection<KeyDefinitionSet> getAllKeyDefinitionSets() {
        return this.b.values();
    }

    public int getNumberOfKeyDefinitions() {
        return this.b.size();
    }

    public void exportKeys(ExpressionPresenter expressionPresenter, Map<Component, Integer> map) {
        for (Map.Entry<StructuredQName, KeyDefinitionSet> entry : this.b.entrySet()) {
            boolean bl2 = entry.getValue().isReusable();
            List<KeyDefinition> list = entry.getValue().getKeyDefinitions();
            for (KeyDefinition keyDefinition : list) {
                if (keyDefinition.getObjectName().equals(StandardNames.getStructuredQName(562))) continue;
                keyDefinition.export(expressionPresenter, bl2, map);
            }
        }
    }
}

