/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.Collections;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.TraceListener2;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.ModeTraceListener;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.DeepCopyRuleSet;
import net.sf.saxon.trans.rules.DeepSkipRuleSet;
import net.sf.saxon.trans.rules.FailRuleSet;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleSetWithWarnings;
import net.sf.saxon.trans.rules.ShallowCopyRuleSet;
import net.sf.saxon.trans.rules.ShallowSkipRuleSet;
import net.sf.saxon.trans.rules.TextOnlyCopyRuleSet;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;

public abstract class Mode
extends Actor {
    public static final StructuredQName OMNI_MODE = new StructuredQName("saxon", "http://saxon.sf.net/", "_omniMode");
    public static final StructuredQName UNNAMED_MODE_NAME = new StructuredQName("xsl", "http://www.w3.org/1999/XSL/Transform", "unnamed");
    public static final StructuredQName DEFAULT_MODE_NAME = new StructuredQName("xsl", "http://www.w3.org/1999/XSL/Transform", "default");
    protected StructuredQName modeName;
    private boolean c;
    private int d = 1;
    public boolean mustBeTyped = false;
    public boolean mustBeUntyped = false;
    boolean a = false;
    boolean b = false;
    private boolean e = false;
    private Set<? extends Accumulator> f;

    public Mode(StructuredQName structuredQName) {
        this.modeName = structuredQName;
    }

    @Override
    public Component.M getDeclaringComponent() {
        return (Component.M)super.getDeclaringComponent();
    }

    public abstract BuiltInRuleSet getBuiltInRuleSet();

    public boolean isUnnamedMode() {
        return this.modeName.equals(UNNAMED_MODE_NAME);
    }

    public StructuredQName getModeName() {
        return this.modeName;
    }

    public abstract SimpleMode getActivePart();

    public abstract int getMaxPrecedence();

    public abstract int getMaxRank();

    public abstract void computeRankings(int var1);

    public String getModeTitle() {
        if (this.isUnnamedMode()) {
            return "The unnamed mode";
        }
        return "Mode " + this.getModeName().getDisplayName();
    }

    public void setModeTracing(boolean bl2) {
        this.e = bl2;
    }

    public boolean isModeTracing() {
        return this.e;
    }

    public Set<? extends Accumulator> getAccumulators() {
        if (this.f == null) {
            return Collections.emptySet();
        }
        return this.f;
    }

    public void setAccumulators(Set<? extends Accumulator> set) {
        this.f = set;
    }

    @Override
    public int getComponentKind() {
        return 174;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(174, this.getModeName());
    }

    @Override
    public int getConstructType() {
        return 174;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getModeName();
    }

    public abstract boolean isEmpty();

    public void setRecoveryPolicy(int n2) {
        this.d = n2;
    }

    public void setHasRules(boolean bl2) {
        this.a = bl2;
    }

    public int getRecoveryPolicy() {
        return this.d;
    }

    public void setStreamable(boolean bl2) {
        this.c = bl2;
    }

    public boolean isDeclaredStreamable() {
        return this.c;
    }

    public abstract Set<String> getExplicitNamespaces(NamePool var1);

    public abstract void processRules(RuleAction var1);

    public XPathContext makeNewContext(XPathContext xPathContext) {
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(xPathContext.getController());
        xPathContextMajor.openStackFrame(this.getStackFrameSlotsNeeded());
        if (!(xPathContext.getCurrentComponent().getActor() instanceof Accumulator)) {
            xPathContextMajor.setCurrentComponent(xPathContext.getCurrentMode());
        }
        return xPathContextMajor;
    }

    public abstract Rule getRule(Item var1, XPathContext var2);

    public abstract Rule getRule(Item var1, XPathContext var2, RuleFilter var3);

    public Rule getRule(Item item, int n2, int n3, XPathContext xPathContext) {
        RuleFilter ruleFilter = rule -> {
            int n4 = rule.getPrecedence();
            return n4 >= n2 && n4 <= n3;
        };
        return this.getRule(item, xPathContext, ruleFilter);
    }

    public Rule getNextMatchRule(Item item, Rule object, XPathContext xPathContext) {
        object = arg_0 -> Mode.a((Rule)object, arg_0);
        return this.getRule(item, xPathContext, (RuleFilter)object);
    }

    public abstract void exportTemplateRules(ExpressionPresenter var1);

    public abstract void explainTemplateRules(ExpressionPresenter var1);

    public TailCall applyTemplates(ParameterSet parameterSet, ParameterSet parameterSet2, XPathContextMajor xPathContextMajor, Location location) {
        Controller controller = xPathContextMajor.getController();
        boolean bl2 = this.e || controller.isTracing();
        xPathContextMajor.getReceiver().getPipelineConfiguration();
        FocusIterator<?> focusIterator = xPathContextMajor.getCurrentIterator();
        TailCall tailCall = null;
        TraceListener traceListener = null;
        if (bl2 && (traceListener = controller.getTraceListener()) == null) {
            traceListener = new ModeTraceListener();
            controller.setTraceListener(traceListener);
            traceListener.open(controller);
        }
        boolean bl3 = (focusIterator.getProperties() & 4) != 0;
        Object object = null;
        while (true) {
            int n2;
            Object object2;
            Object t2;
            if (tailCall != null) {
                if (bl3 && !((LookaheadIterator)((Object)focusIterator)).hasNext()) break;
                while ((tailCall = tailCall.processLeavingTail()) != null) {
                }
            }
            if ((t2 = focusIterator.next()) == null) break;
            if (this.mustBeTyped) {
                int n3;
                if (!(!(t2 instanceof NodeInfo) || (n3 = ((NodeInfo)t2).getNodeKind()) != 1 && n3 != 2 || (object2 = ((NodeInfo)t2).getSchemaType()) != Untyped.getInstance() && object2 != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    throw new XPathException(this.getModeTitle() + " requires typed nodes, but the input is untyped", "XTTE3100");
                }
            } else if (this.mustBeUntyped && t2 instanceof NodeInfo && ((n2 = ((NodeInfo)t2).getNodeKind()) == 1 || n2 == 2) && (object2 = ((NodeInfo)t2).getSchemaType()) != Untyped.getInstance() && object2 != BuiltInAtomicType.UNTYPED_ATOMIC) {
                throw new XPathException(this.getModeTitle() + " requires untyped nodes, but the input is typed", "XTTE3110");
            }
            if (bl2 && traceListener instanceof TraceListener2) {
                ((TraceListener2)traceListener).startRuleSearch();
            }
            Rule rule = this.getRule((Item)t2, xPathContextMajor);
            if (bl2 && traceListener instanceof TraceListener2) {
                ((TraceListener2)traceListener).endRuleSearch(rule != null ? rule : this.getBuiltInRuleSet(), this, (Item)t2);
            }
            if (rule == null) {
                this.getBuiltInRuleSet().process((Item)t2, parameterSet, parameterSet2, xPathContextMajor, location);
                continue;
            }
            object2 = (TemplateRule)rule.getAction();
            if (object2 != object) {
                object = object2;
                ((TemplateRule)object2).initialize();
                xPathContextMajor.openStackFrame(((TemplateRule)object2).getStackFrameMap());
                xPathContextMajor.setLocalParameters(parameterSet);
                xPathContextMajor.setTunnelParameters(parameterSet2);
                xPathContextMajor.setCurrentMergeGroupIterator(null);
            }
            xPathContextMajor.setCurrentTemplateRule(rule);
            if (bl2) {
                traceListener.startCurrentItem((Item)t2);
                if (this.e) {
                    traceListener.enter((InstructionInfo)object2, xPathContextMajor);
                }
                if ((tailCall = ((TemplateRule)object2).applyLeavingTail(xPathContextMajor)) != null) {
                    while ((tailCall = tailCall.processLeavingTail()) != null) {
                    }
                }
                if (this.e) {
                    traceListener.leave((InstructionInfo)object2);
                }
                traceListener.endCurrentItem((Item)t2);
                continue;
            }
            tailCall = ((TemplateRule)object2).applyLeavingTail(xPathContextMajor);
        }
        return tailCall;
    }

    public abstract int getStackFrameSlotsNeeded();

    public String getCodeForBuiltInRuleSet(BuiltInRuleSet builtInRuleSet) {
        if (builtInRuleSet instanceof ShallowCopyRuleSet) {
            return "SC";
        }
        if (builtInRuleSet instanceof ShallowSkipRuleSet) {
            return "SS";
        }
        if (builtInRuleSet instanceof DeepCopyRuleSet) {
            return "DC";
        }
        if (builtInRuleSet instanceof DeepSkipRuleSet) {
            return "DS";
        }
        if (builtInRuleSet instanceof FailRuleSet) {
            return "FF";
        }
        if (builtInRuleSet instanceof TextOnlyCopyRuleSet) {
            return "TC";
        }
        if (builtInRuleSet instanceof RuleSetWithWarnings) {
            return this.getCodeForBuiltInRuleSet(((RuleSetWithWarnings)builtInRuleSet).getBaseRuleSet()) + "+W";
        }
        return "???";
    }

    public BuiltInRuleSet getBuiltInRuleSetForCode(String string) {
        BuiltInRuleSet builtInRuleSet;
        if (string.startsWith("SC")) {
            builtInRuleSet = ShallowCopyRuleSet.getInstance();
        } else if (string.startsWith("SS")) {
            builtInRuleSet = ShallowSkipRuleSet.getInstance();
        } else if (string.startsWith("DC")) {
            builtInRuleSet = DeepCopyRuleSet.getInstance();
        } else if (string.startsWith("DS")) {
            builtInRuleSet = DeepSkipRuleSet.getInstance();
        } else if (string.startsWith("FF")) {
            builtInRuleSet = FailRuleSet.getInstance();
        } else if (string.startsWith("TC")) {
            builtInRuleSet = TextOnlyCopyRuleSet.getInstance();
        } else {
            throw new IllegalArgumentException(string);
        }
        if (string.endsWith("+W")) {
            builtInRuleSet = new RuleSetWithWarnings(builtInRuleSet);
        }
        return builtInRuleSet;
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        int n2 = expressionPresenter.startElement("mode");
        if (!this.isUnnamedMode()) {
            expressionPresenter.emitAttribute("name", this.getModeName());
        }
        Mode mode = this;
        expressionPresenter.emitAttribute("onNo", mode.getCodeForBuiltInRuleSet(mode.getBuiltInRuleSet()));
        String string = "";
        if (this.isDeclaredStreamable()) {
            string = string + "s";
        }
        if (this.isUnnamedMode()) {
            string = string + "d";
        }
        if (this.mustBeTyped) {
            string = string + "t";
        }
        if (this.mustBeUntyped) {
            string = string + "u";
        }
        if (this.d == 2) {
            string = string + "F";
        } else if (this.d == 1) {
            string = string + "W";
        }
        if (!this.a) {
            string = string + "e";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        this.exportUseAccumulators(expressionPresenter);
        expressionPresenter.emitAttribute("patternSlots", "" + this.getStackFrameSlotsNeeded());
        this.exportTemplateRules(expressionPresenter);
        int n3 = expressionPresenter.endElement();
        if (n2 != n3) {
            throw new IllegalStateException("Export tree unbalanced for mode " + this.getModeName());
        }
    }

    protected void exportUseAccumulators(ExpressionPresenter expressionPresenter) {
    }

    public boolean isMustBeTyped() {
        return this.mustBeTyped;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        int n2 = expressionPresenter.startElement("mode");
        if (!this.isUnnamedMode()) {
            expressionPresenter.emitAttribute("name", this.getModeName());
        }
        Mode mode = this;
        expressionPresenter.emitAttribute("onNo", mode.getCodeForBuiltInRuleSet(mode.getBuiltInRuleSet()));
        String string = "";
        if (this.isDeclaredStreamable()) {
            string = string + "s";
        }
        if (this.isUnnamedMode()) {
            string = string + "d";
        }
        if (this.mustBeTyped) {
            string = string + "t";
        }
        if (this.mustBeUntyped) {
            string = string + "u";
        }
        if (this.d == 2) {
            string = string + "F";
        } else if (this.d == 1) {
            string = string + "W";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        expressionPresenter.emitAttribute("patternSlots", "" + this.getStackFrameSlotsNeeded());
        this.explainTemplateRules(expressionPresenter);
        int n3 = expressionPresenter.endElement();
        if (n2 != n3) {
            throw new IllegalStateException("tree unbalanced");
        }
    }

    private static /* synthetic */ boolean a(Rule rule, Rule rule2) {
        int n2 = rule2.compareRank(rule);
        if (n2 < 0) {
            return true;
        }
        if (n2 == 0) {
            n2 = Integer.compare(rule2.getSequence(), rule.getSequence());
            if (n2 < 0) {
                return true;
            }
            if (n2 == 0) {
                return rule2.getPartNumber() < rule.getPartNumber();
            }
        }
        return false;
    }

    public static interface RuleAction {
        public void processRule(Rule var1);
    }

    protected static interface RuleFilter {
        public boolean testRule(Rule var1);
    }
}

