/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.function.Supplier;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.accum.AccumulatorManager;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.OutputURIResolverWrapper;
import net.sf.saxon.lib.ResultDocumentResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.MessageEmitter;
import net.sf.saxon.serialize.PrincipalOutputGatekeeper;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.SpaceStrippedNode;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;

public class XsltController
extends Controller {
    private final Map<StructuredQName, Integer> a = new HashMap<StructuredQName, Integer>();
    private Receiver b = null;
    private Supplier<Receiver> c = MessageEmitter::new;
    private boolean d = true;
    private ResultDocumentResolver e;
    private HashSet<DocumentURI> f;
    private Component.M g = null;
    private Function h = null;
    private int i;
    private Map<StructuredQName, Sequence<?>> j;
    private Map<StructuredQName, Sequence<?>> k;
    private Map<Long, Stack<AttributeSet>> l = new HashMap<Long, Stack<AttributeSet>>();
    private AccumulatorManager m = new AccumulatorManager();
    private PrincipalOutputGatekeeper n = null;
    private Destination o;

    public XsltController(Configuration configuration, PreparedStylesheet preparedStylesheet) {
        super(configuration, preparedStylesheet);
    }

    @Override
    public void reset() {
        Object object;
        super.reset();
        Configuration configuration = this.getConfiguration();
        this.setErrorListener(configuration.getErrorListener());
        this.i = configuration.getRecoveryPolicy();
        this.validationMode = configuration.getSchemaValidationMode();
        this.m = new AccumulatorManager();
        if (this.errorListener instanceof StandardErrorListener) {
            object = ((StandardErrorListener)this.errorListener).getLogger();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setLogger((Logger)object);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.i);
        }
        this.traceListener = null;
        try {
            object = configuration.makeTraceListener();
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
        if (object != null) {
            this.addTraceListener((TraceListener)object);
        }
        this.setModel(configuration.getParseOptions().getModel());
        this.globalContextItem = null;
        this.g = null;
        this.clearPerTransformationData();
    }

    @Override
    protected synchronized void clearPerTransformationData() {
        super.clearPerTransformationData();
        this.principalResult = null;
        this.f = null;
        if (this.a != null) {
            this.a.clear();
        }
    }

    public void setInitialMode(StructuredQName structuredQName) {
        if (structuredQName == null || structuredQName.equals(Mode.UNNAMED_MODE_NAME)) {
            Mode mode = ((PreparedStylesheet)this.executable).getRuleManager().obtainMode(Mode.UNNAMED_MODE_NAME, true);
            this.g = mode.getDeclaringComponent();
            return;
        }
        StylesheetPackage stylesheetPackage = (StylesheetPackage)this.executable.getTopLevelPackage();
        if (structuredQName.equals(Mode.DEFAULT_MODE_NAME)) {
            StructuredQName structuredQName2 = stylesheetPackage.getDefaultMode();
            if (!structuredQName.equals(structuredQName2)) {
                this.setInitialMode(structuredQName2);
            }
            return;
        }
        boolean bl2 = stylesheetPackage.isDeclaredModes();
        Object object = new SymbolicName(174, structuredQName);
        if ((object = (Component.M)stylesheetPackage.getComponent((SymbolicName)object)) == null) {
            throw new XPathException("Requested initial mode " + structuredQName + " is not defined in the stylesheet", "XTDE0045");
        }
        if (!((PreparedStylesheet)this.executable).isEligibleInitialMode((Component.M)object)) {
            throw new XPathException("Requested initial mode " + structuredQName + " is private in the top-level package", "XTDE0045");
        }
        this.g = object;
        if (!bl2 && this.g.getActor().isEmpty() && !structuredQName.equals(stylesheetPackage.getDefaultMode())) {
            throw new XPathException("Requested initial mode " + structuredQName + " contains no template rules", "XTDE0045");
        }
    }

    public StructuredQName getInitialModeName() {
        if (this.g == null) {
            return null;
        }
        return this.g.getActor().getModeName();
    }

    public Mode getInitialMode() {
        if (this.g == null) {
            Object object = (StylesheetPackage)this.executable.getTopLevelPackage();
            StructuredQName structuredQName = ((StylesheetPackage)object).getDefaultMode();
            if (structuredQName == null) {
                structuredQName = Mode.UNNAMED_MODE_NAME;
            }
            this.g = object = (Component.M)((StylesheetPackage)object).getComponent(new SymbolicName(174, structuredQName));
            return ((Component.M)object).getActor();
        }
        return this.g.getActor();
    }

    public AccumulatorManager getAccumulatorManager() {
        return this.m;
    }

    public synchronized boolean checkUniqueOutputDestination(DocumentURI documentURI) {
        if (documentURI == null) {
            return true;
        }
        if (this.f == null) {
            this.f = new HashSet(20);
        }
        return !this.f.contains(documentURI);
    }

    public void addUnavailableOutputDestination(DocumentURI documentURI) {
        if (this.f == null) {
            this.f = new HashSet(20);
        }
        this.f.add(documentURI);
    }

    public void removeUnavailableOutputDestination(DocumentURI documentURI) {
        if (this.f != null) {
            this.f.remove(documentURI);
        }
    }

    public boolean isUnusedOutputDestination(DocumentURI documentURI) {
        return this.f == null || !this.f.contains(documentURI);
    }

    public void setInitialTemplateParameters(Map<StructuredQName, Sequence<?>> map, boolean bl2) {
        if (bl2) {
            this.k = map;
            return;
        }
        this.j = map;
    }

    public Map<StructuredQName, Sequence<?>> getInitialTemplateParameters(boolean bl2) {
        if (bl2) {
            return this.k;
        }
        return this.j;
    }

    public void setMessageFactory(Supplier<Receiver> supplier) {
        this.c = supplier;
    }

    public void setMessageReceiverClassName(String string) {
        if (!string.equals(MessageEmitter.class.getName())) {
            this.c = () -> {
                try {
                    Object object = this.getConfiguration().getInstance(string, null);
                    if (!(object instanceof Receiver)) {
                        throw new XPathException(string + " is not a Receiver");
                    }
                    return (Receiver)object;
                }
                catch (XPathException xPathException) {
                    throw new UncheckedXPathException(xPathException);
                }
            };
        }
    }

    public Receiver makeMessageReceiver() {
        return this.c.get();
    }

    public void setMessageEmitter(Receiver receiver) {
        if (this.getConfiguration().getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            throw new IllegalStateException("XsltController#setMessageEmitter() is not supported for a configuration that allows multi-threading. Use setMessageFactory() instead");
        }
        Receiver receiver2 = this.b = receiver;
        receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        if (receiver instanceof Emitter && ((Emitter)receiver).getOutputProperties() == null) {
            try {
                Properties properties = new Properties();
                properties.setProperty("method", "xml");
                properties.setProperty("indent", "yes");
                properties.setProperty("omit-xml-declaration", "yes");
                ((Emitter)receiver).setOutputProperties(properties);
            }
            catch (XPathException xPathException) {}
        }
        XsltController xsltController = this;
        xsltController.setMessageFactory(() -> new ProxyReceiver(this, receiver2){
            private /* synthetic */ XsltController a;
            {
                this.a = xsltController;
                super(receiver);
            }

            @Override
            public final void close() {
            }
        });
    }

    public Receiver getMessageEmitter() {
        return this.b;
    }

    public void incrementMessageCounter(StructuredQName structuredQName) {
        Map<StructuredQName, Integer> map = this.a;
        synchronized (map) {
            Integer n2 = this.a.get(structuredQName);
            int n3 = n2 == null ? 1 : n2 + 1;
            this.a.put(structuredQName, n3);
            return;
        }
    }

    public Map<StructuredQName, Integer> getMessageCounters() {
        Map<StructuredQName, Integer> map = this.a;
        synchronized (map) {
            return new HashMap<StructuredQName, Integer>(this.a);
        }
    }

    public void setRecoveryPolicy(int n2) {
        this.i = n2;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(n2);
        }
    }

    public int getRecoveryPolicy() {
        return this.i;
    }

    @Override
    public void recoverableError(XPathException xPathException) {
        if (this.i == 2) {
            throw xPathException;
        }
        this.errorListener.warning(xPathException);
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        outputURIResolver = outputURIResolver == null ? this.getConfiguration().getOutputURIResolver() : outputURIResolver;
        this.setResultDocumentResolver(new OutputURIResolverWrapper(outputURIResolver));
    }

    public ResultDocumentResolver getResultDocumentResolver() {
        return this.e;
    }

    public void setResultDocumentResolver(ResultDocumentResolver resultDocumentResolver) {
        this.e = resultDocumentResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.e instanceof OutputURIResolverWrapper) {
            return ((OutputURIResolverWrapper)this.e).getOutputURIResolver();
        }
        return this.getConfiguration().getOutputURIResolver();
    }

    public void setPrincipalDestination(Destination destination) {
        this.o = destination;
    }

    public Destination getPrincipalDestination() {
        return this.o;
    }

    public boolean isAssertionsEnabled() {
        return this.d;
    }

    public void setAssertionsEnabled(boolean bl2) {
        this.d = bl2;
    }

    @Override
    public void preEvaluateGlobals(XPathContext xPathContext) {
        this.a();
        super.preEvaluateGlobals(xPathContext);
        this.b();
    }

    public void applyTemplates(Sequence<?> object, Receiver receiver) {
        this.checkReadiness();
        this.a();
        try {
            receiver = this.a(receiver);
            XPathContextMajor xPathContextMajor = this.newXPathContext();
            xPathContextMajor.createThreadManager();
            xPathContextMajor.setOrigin(this);
            xPathContextMajor.setReceiver(receiver);
            Mode mode = this.getInitialMode();
            if (mode == null) {
                throw new XPathException("Requested initial mode " + (this.g == null ? "#unnamed" : this.g.getActor().getModeName().getDisplayName()) + " does not exist", "XTDE0045");
            }
            if (!((PreparedStylesheet)this.executable).isEligibleInitialMode(this.g)) {
                throw new XPathException("Requested initial mode " + mode.getModeName().getDisplayName() + " is not public or final", "XTDE0045");
            }
            Mode mode2 = mode;
            Object object2 = this;
            if (mode2.isDeclaredStreamable()) {
                ((Controller)object2).warning((((XsltController)object2).g == null ? "" : ((XsltController)object2).getInitialMode().getModeTitle()) + " is streamable, but the input is not supplied as a stream", null, null);
            }
            ParameterSet parameterSet = null;
            if (this.j != null) {
                parameterSet = new ParameterSet(this.j);
            }
            ParameterSet parameterSet2 = null;
            if (this.k != null) {
                parameterSet2 = new ParameterSet(this.k);
            }
            object = object.iterate();
            mode2 = mode;
            object2 = this;
            object2 = item -> {
                if (item instanceof NodeInfo) {
                    Object object;
                    if ((item = (NodeInfo)item).getConfiguration() == null) {
                        throw new XPathException("The supplied source document must be associated with a Configuration");
                    }
                    if (!item.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                        throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                    }
                    if (item.getTreeInfo().isTyped() && !this.executable.isSchemaAware()) {
                        throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                    }
                    if (this.isStylesheetStrippingTypeAnnotations() && item != this.globalContextItem && (object = item.getTreeInfo()).isTyped()) {
                        object = new TypeStrippedDocument((TreeInfo)object);
                        item = ((TypeStrippedDocument)object).wrap((NodeInfo)item);
                    }
                    object = this.getSpaceStrippingRule();
                    if (this.isStylesheetContainingStripSpace() && this.isStripSourceTree() && !(item instanceof SpaceStrippedNode) && item != this.globalContextItem && item.getTreeInfo().getSpaceStrippingRule() != object) {
                        object = new SpaceStrippedDocument(item.getTreeInfo(), (SpaceStrippingRule)object);
                        if (!SpaceStrippedNode.isPreservedNode((NodeInfo)item, (SpaceStrippedDocument)object, item.getParent())) {
                            return EmptyIterator.emptyIterator();
                        }
                        item = ((SpaceStrippedDocument)object).wrap((NodeInfo)item);
                    }
                    if (this.getAccumulatorManager() != null) {
                        this.getAccumulatorManager().setApplicableAccumulators(item.getTreeInfo(), mode2.getAccumulators());
                    }
                    return SingletonIterator.makeIterator(item);
                }
                return SingletonIterator.makeIterator(item);
            };
            object = new MappingIterator(object, object2);
            xPathContextMajor.trackFocus(object);
            xPathContextMajor.setCurrentMode(this.g);
            xPathContextMajor.setCurrentComponent(this.g);
            for (object = mode.applyTemplates(parameterSet, parameterSet2, xPathContextMajor, ExplicitLocation.UNKNOWN_LOCATION); object != null; object = object.processLeavingTail()) {
            }
            ((XPathContextMinor)xPathContextMajor).waitForChildThreads();
            receiver.close();
            return;
        }
        catch (TerminationException terminationException) {
            TerminationException terminationException2 = terminationException;
            if (!terminationException.hasBeenReported()) {
                this.reportFatalError(terminationException2);
            }
            throw terminationException2;
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            this.handleXPathException(uncheckedXPathException.getXPathException());
            return;
        }
        catch (XPathException xPathException) {
            this.handleXPathException(xPathException);
            return;
        }
        finally {
            this.inUse = false;
            this.b();
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            this.principalResultURI = null;
        }
    }

    private SequenceReceiver a(Receiver receiver) {
        this.principalResult = receiver;
        if (this.principalResultURI == null) {
            this.principalResultURI = receiver.getSystemId();
        }
        SequenceReceiver sequenceReceiver = new NamespaceReducer(receiver);
        sequenceReceiver = new ComplexContentOutputter(sequenceReceiver);
        ((SequenceReceiver)sequenceReceiver).setSystemId(receiver.getSystemId());
        receiver = sequenceReceiver;
        if (this.getExecutable().createsSecondaryResult()) {
            this.n = new PrincipalOutputGatekeeper(this, receiver);
            receiver = this.n;
        }
        receiver.open();
        return receiver;
    }

    public PrincipalOutputGatekeeper getGatekeeper() {
        return this.n;
    }

    public void callTemplate(StructuredQName object, Receiver receiver) {
        this.checkReadiness();
        this.a();
        try {
            Object object2;
            Component component;
            receiver = this.a(receiver);
            XPathContextMajor xPathContextMajor = this.newXPathContext();
            xPathContextMajor.createThreadManager();
            xPathContextMajor.setOrigin(this);
            xPathContextMajor.setReceiver(receiver);
            if (this.globalContextItem != null) {
                xPathContextMajor.setCurrentIterator(new ManualIterator(this.globalContextItem));
            }
            ParameterSet parameterSet = null;
            if (this.j != null) {
                parameterSet = new ParameterSet(this.j);
            }
            ParameterSet parameterSet2 = null;
            if (this.k != null) {
                parameterSet2 = new ParameterSet(this.k);
            }
            if ((component = ((StylesheetPackage)(object2 = (StylesheetPackage)this.executable.getTopLevelPackage())).getComponent(new SymbolicName(200, (StructuredQName)object))) == null) {
                throw new XPathException("Template " + ((StructuredQName)object).getDisplayName() + " does not exist", "XTDE0040");
            }
            if (!((StylesheetPackage)object2).isImplicitPackage() && component.getVisibility() != Visibility.PUBLIC && component.getVisibility() != Visibility.FINAL) {
                throw new XPathException("Template " + ((StructuredQName)object).getDisplayName() + " is " + component.getVisibility().show(), "XTDE0040");
            }
            object = (NamedTemplate)component.getActor();
            object2 = ((XPathContextMinor)xPathContextMajor).newContext();
            xPathContextMajor.setOrigin(this);
            ((XPathContextMajor)object2).setCurrentComponent(component);
            ((XPathContextMajor)object2).openStackFrame(((Actor)object).getStackFrameMap());
            ((XPathContextMajor)object2).setLocalParameters(parameterSet);
            ((XPathContextMajor)object2).setTunnelParameters(parameterSet2);
            for (object = ((NamedTemplate)object).expand((XPathContext)object2); object != null; object = object.processLeavingTail()) {
            }
            ((XPathContextMinor)xPathContextMajor).waitForChildThreads();
            receiver.close();
            return;
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            this.handleXPathException(uncheckedXPathException.getXPathException());
            return;
        }
        catch (XPathException xPathException) {
            this.handleXPathException(xPathException);
            return;
        }
        finally {
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            this.b();
            this.inUse = false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applyStreamingTemplates(Source source, Receiver object) {
        this.checkReadiness();
        this.a();
        object = this.a((Receiver)object);
        boolean bl2 = false;
        try {
            Object object2;
            block20: {
                this.getSchemaValidationMode();
                object2 = source;
                if (source instanceof AugmentedSource) {
                    bl2 = ((AugmentedSource)source).isPleaseCloseAfterUse();
                    ((AugmentedSource)source).getSchemaValidation();
                    object2 = ((AugmentedSource)source).getContainedSource();
                }
                Object object3 = this.getConfiguration();
                ((Configuration)object3).getSourceResolver().resolveSource((Source)object2, (Configuration)object3);
                if (!(source instanceof SAXSource || source instanceof StreamSource || source instanceof EventSource)) {
                    throw new IllegalArgumentException("Streaming requires a SAXSource, StreamSource, or EventSource");
                }
                if (!this.g.getActor().isDeclaredStreamable()) {
                    throw new IllegalArgumentException("Initial mode is not streamable");
                }
                if (source instanceof SAXSource && ((Configuration)object3).getBooleanProperty(Feature.IGNORE_SAX_SOURCE_PARSER)) {
                    ((SAXSource)source).setXMLReader(null);
                }
                object2 = this.newXPathContext();
                ((XPathContextMajor)object2).createThreadManager();
                ((XPathContextMajor)object2).setOrigin(this);
                ((XPathContextMinor)object2).setReceiver((Receiver)object);
                Object object4 = null;
                if (this.j != null) {
                    object4 = new ParameterSet(this.j);
                }
                ParameterSet parameterSet = null;
                if (this.k != null) {
                    parameterSet = new ParameterSet(this.k);
                }
                object4 = ((Configuration)object3).makeStreamingTransformer((XPathContext)object2, this.g.getActor(), (ParameterSet)object4, parameterSet);
                if (((Configuration)object3).isStripsAllWhiteSpace() || this.isStylesheetContainingStripSpace()) {
                    object4 = this.makeStripper((Receiver)object4);
                }
                object3 = object4.getPipelineConfiguration();
                ((PipelineConfiguration)object3).getParseOptions().setSchemaValidationMode(this.validationMode);
                boolean bl3 = this.getConfiguration().isTiming();
                if (bl3) {
                    this.getConfiguration().getLogger().info("Streaming " + source.getSystemId());
                }
                try {
                    Sender.send(source, (Receiver)object4, null);
                }
                catch (QuitParsingException quitParsingException) {
                    if (!bl3) break block20;
                    this.getConfiguration().getLogger().info("Streaming " + source.getSystemId() + " : early exit");
                }
            }
            ((XPathContextMinor)object2).waitForChildThreads();
            object.close();
            this.inUse = false;
        }
        catch (TerminationException terminationException) {
            object = terminationException;
            if (terminationException.hasBeenReported()) throw object;
            this.reportFatalError((XPathException)object);
            throw object;
            catch (UncheckedXPathException uncheckedXPathException) {
                this.handleXPathException(uncheckedXPathException.getXPathException());
                return;
            }
            catch (XPathException xPathException) {
                this.handleXPathException(xPathException);
                return;
            }
        }
        finally {
            this.inUse = false;
            if (bl2 && source instanceof AugmentedSource) {
                ((AugmentedSource)source).close();
            }
            if (this.traceListener == null) return;
            this.traceListener.close();
        }
        if (bl2 && source instanceof AugmentedSource) {
            ((AugmentedSource)source).close();
        }
        if (this.traceListener == null) return;
        this.traceListener.close();
        return;
    }

    public Receiver getStreamingReceiver(Mode object, Receiver receiver) {
        this.checkReadiness();
        this.a();
        receiver = this.a(receiver);
        XPathContextMajor xPathContextMajor = this.newXPathContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setReceiver(receiver);
        this.globalContextItem = null;
        if (!((Mode)object).isDeclaredStreamable()) {
            throw new XPathException("mode supplied to getStreamingReceiver() must be streamable");
        }
        Configuration configuration = this.getConfiguration();
        object = configuration.makeStreamingTransformer(xPathContextMajor, (Mode)object, null, null);
        if (object == null) {
            throw new XPathException("Streaming requires Saxon-EE");
        }
        if (configuration.isStripsAllWhiteSpace() || this.isStylesheetContainingStripSpace()) {
            object = this.makeStripper((Receiver)object);
        }
        object.setPipelineConfiguration(this.makePipelineConfiguration());
        return new ProxyReceiver(this, (Receiver)object, receiver){
            private /* synthetic */ Receiver a;
            private /* synthetic */ XsltController b;
            {
                this.b = xsltController;
                this.a = receiver2;
                super(receiver);
            }

            @Override
            public final void close() {
                if (this.b.traceListener != null) {
                    this.b.traceListener.close();
                }
                this.b.b();
                this.a.close();
                XsltController.a(this.b, false);
            }
        };
    }

    private void a() {
        if (this.b != null) {
            this.b.open();
            if (this.b instanceof Emitter && ((Emitter)this.b).getWriter() == null) {
                ((Emitter)this.b).setStreamResult(this.getConfiguration().getLogger().asStreamResult());
            }
        }
    }

    private void b() {
        if (this.b != null) {
            this.b.close();
        }
    }

    public synchronized Stack<AttributeSet> getAttributeSetEvaluationStack() {
        long l3 = Thread.currentThread().getId();
        return this.l.computeIfAbsent(l3, l2 -> new Stack());
    }

    public synchronized void releaseAttributeSetEvaluationStack() {
        long l2 = Thread.currentThread().getId();
        this.l.remove(l2);
    }

    static /* synthetic */ boolean a(XsltController xsltController, boolean bl2) {
        xsltController.inUse = false;
        return false;
    }
}

