/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.packages;

import java.io.File;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class PackageInspector
extends ProxyReceiver {
    private boolean a;
    private String b;
    private String c = "1";
    private int d = 0;

    private PackageInspector(PipelineConfiguration pipelineConfiguration) {
        super(new Sink(pipelineConfiguration));
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        if (this.d++ > 0) {
            throw new XPathException("#start#");
        }
        this.a = nodeName.hasURI("http://ns.saxonica.com/xslt/export");
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        if (nodeName.getLocalPart().equals("name")) {
            this.b = charSequence.toString();
            return;
        }
        if (nodeName.getLocalPart().equals("package-version") || nodeName.getLocalPart().equals("packageVersion")) {
            this.c = charSequence.toString();
            return;
        }
        if (nodeName.getLocalPart().equals("saxonVersion") && charSequence.toString().startsWith("1")) {
            throw new XPathException("Saxon " + Version.getProductVersion() + " cannot load a SEF file created using version " + charSequence);
        }
    }

    private VersionedPackageName a() {
        if (this.b == null) {
            return null;
        }
        try {
            return new VersionedPackageName(this.b, this.c);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public static PackageDetails getPackageDetails(File file, Configuration object) {
        Object object2;
        block5: {
            object = new PackageInspector(((Configuration)object).makePipelineConfiguration());
            try {
                Sender.send(new StreamSource(file), (Receiver)object, new ParseOptions());
            }
            catch (XPathException xPathException) {
                object2 = xPathException;
                if (xPathException.getMessage().equals("#start#")) break block5;
                throw object2;
            }
        }
        object2 = super.a();
        if (object2 == null) {
            return null;
        }
        PackageDetails packageDetails = new PackageDetails();
        new PackageDetails().nameAndVersion = object2;
        if (((PackageInspector)object).a) {
            packageDetails.exportLocation = new StreamSource(file);
        } else {
            packageDetails.sourceLocation = new StreamSource(file);
        }
        return packageDetails;
    }
}

