/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.packages;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageInspector;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.tree.util.FastStringBuffer;

public class PackageLibrary {
    private final Configuration a;
    private final CompilerInfo b;
    private Map<String, List<PackageVersion>> c = new HashMap<String, List<PackageVersion>>();
    private Map<VersionedPackageName, PackageDetails> d = new HashMap<VersionedPackageName, PackageDetails>();

    public PackageLibrary(CompilerInfo compilerInfo) {
        this.b = compilerInfo;
        this.a = compilerInfo.getConfiguration();
    }

    public CompilerInfo getCompilerInfo() {
        return this.b;
    }

    public PackageLibrary(PackageLibrary packageLibrary) {
        this.c = new HashMap<String, List<PackageVersion>>(packageLibrary.c);
        this.d = new HashMap<VersionedPackageName, PackageDetails>(packageLibrary.d);
        this.b = packageLibrary.b;
        this.a = packageLibrary.a;
    }

    public PackageLibrary(CompilerInfo object, Set<File> object2) {
        this.b = object;
        this.a = ((CompilerInfo)object).getConfiguration();
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (File)object.next();
            PackageDetails packageDetails = PackageInspector.getPackageDetails((File)object2, this.a);
            if (packageDetails == null) {
                throw new XPathException("Unable to get package name and version for file " + ((File)object2).getName());
            }
            this.addPackage(packageDetails);
        }
    }

    public synchronized void addPackage(StylesheetPackage stylesheetPackage) {
        Object object = stylesheetPackage.getPackageName();
        Object object2 = stylesheetPackage.getPackageVersion();
        object = new VersionedPackageName((String)object, (PackageVersion)object2);
        object2 = new PackageDetails();
        new PackageDetails().nameAndVersion = object;
        ((PackageDetails)object2).loadedPackage = stylesheetPackage;
        this.d.put((VersionedPackageName)object, (PackageDetails)object2);
        this.addPackage((PackageDetails)object2);
    }

    public synchronized void addPackage(PackageDetails packageDetails) {
        VersionedPackageName versionedPackageName = packageDetails.nameAndVersion;
        Object object = versionedPackageName.packageName;
        PackageVersion packageVersion = versionedPackageName.packageVersion;
        object = this.c.computeIfAbsent((String)object, string -> new ArrayList());
        object.add(packageVersion);
        this.d.put(versionedPackageName, packageDetails);
    }

    public void addPackage(File file) {
        PackageDetails packageDetails = PackageInspector.getPackageDetails(file, this.a);
        if (packageDetails == null) {
            throw new XPathException("Unable to get package name and version for file " + file.getName());
        }
        this.addPackage(packageDetails);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized PackageDetails findPackage(String object, PackageVersionRanges object2) {
        void var6_12;
        HashSet hashSet = new HashSet();
        List<PackageVersion> list = this.c.get(object);
        if (list == null) {
            return null;
        }
        int n2 = Integer.MIN_VALUE;
        for (PackageVersion object32 : list) {
            Iterator iterator = this.d.get(new VersionedPackageName((String)object, object32));
            if (!((PackageVersionRanges)object2).contains(object32)) continue;
            hashSet.add(iterator);
            Integer n3 = ((PackageDetails)((Object)iterator)).priority;
            if (n3 == null || n3 <= n2) continue;
            n2 = n3;
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        if (hashSet.size() == 1) {
            return (PackageDetails)hashSet.iterator().next();
        }
        new HashSet();
        Object var6_7 = null;
        if (n2 == Integer.MIN_VALUE) {
            for (PackageDetails packageDetails : hashSet) {
                void var6_8;
                if (var6_8 != null && packageDetails.nameAndVersion.packageVersion.compareTo(var6_8.nameAndVersion.packageVersion) <= 0) continue;
                PackageDetails packageDetails2 = packageDetails;
            }
        } else {
            for (PackageDetails packageDetails : hashSet) {
                void var6_10;
                object = packageDetails.priority;
                object2 = packageDetails.nameAndVersion.packageVersion;
                if (object == null || (Integer)object != n2 || var6_10 != null && ((PackageVersion)object2).compareTo(var6_10.nameAndVersion.packageVersion) <= 0) continue;
                PackageDetails packageDetails3 = packageDetails;
            }
        }
        return var6_12;
    }

    public synchronized PackageDetails findDetailsForAlias(String string) {
        assert (string != null);
        PackageDetails packageDetails = null;
        for (PackageDetails packageDetails2 : this.d.values()) {
            if (!string.equals(packageDetails2.shortName)) continue;
            if (packageDetails == null) {
                packageDetails = packageDetails2;
                continue;
            }
            throw new IllegalStateException("Non-unique shortName in package library: " + string);
        }
        return packageDetails;
    }

    public StylesheetPackage obtainLoadedPackage(PackageDetails packageDetails, List<VersionedPackageName> object) {
        if (packageDetails.loadedPackage != null) {
            return packageDetails.loadedPackage;
        }
        if (packageDetails.exportLocation != null) {
            PackageLibrary.a(packageDetails, (List<VersionedPackageName>)object);
            packageDetails.beingProcessed = Thread.currentThread();
            Source source = packageDetails.exportLocation;
            object = this.a.makePackageLoader();
            StylesheetPackage stylesheetPackage = object.loadPackage(source);
            PackageLibrary.a(stylesheetPackage, packageDetails);
            packageDetails.loadedPackage = stylesheetPackage;
            packageDetails.beingProcessed = null;
            return stylesheetPackage;
        }
        if (packageDetails.sourceLocation != null) {
            PackageLibrary.a(packageDetails, (List<VersionedPackageName>)object);
            packageDetails.beingProcessed = Thread.currentThread();
            Compilation compilation = new Compilation(this.a, this.b);
            compilation.setUsingPackages((List<VersionedPackageName>)object);
            compilation.setExpectedNameAndVersion(packageDetails.nameAndVersion);
            compilation.clearParameters();
            compilation.setLibraryPackage(true);
            if (packageDetails.staticParams != null) {
                for (Map.Entry object22 : packageDetails.staticParams.entrySet()) {
                    compilation.setParameter((StructuredQName)object22.getKey(), (GroundedValue)object22.getValue());
                }
            }
            object = compilation.compilePackage(packageDetails.sourceLocation);
            packageDetails.beingProcessed = null;
            if (compilation.getErrorCount() > 0) {
                throw new XPathException("Errors found in package " + packageDetails.nameAndVersion.packageName);
            }
            StylesheetPackage stylesheetPackage = ((PrincipalStylesheetModule)object).getStylesheetPackage();
            PackageLibrary.a(stylesheetPackage, packageDetails);
            packageDetails.loadedPackage = stylesheetPackage;
            return stylesheetPackage;
        }
        return null;
    }

    private static void a(PackageDetails packageDetails, List<VersionedPackageName> object) {
        if (packageDetails.beingProcessed == Thread.currentThread()) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(1024);
            object = object.iterator();
            while (object.hasNext()) {
                VersionedPackageName versionedPackageName = (VersionedPackageName)object.next();
                fastStringBuffer.append(versionedPackageName.packageName);
                fastStringBuffer.append(", ");
            }
            fastStringBuffer.append("and ");
            fastStringBuffer.append(packageDetails.nameAndVersion.packageName);
            throw new XPathException("There is a cycle of package dependencies involving " + fastStringBuffer, "XTSE3005");
        }
    }

    private static void a(StylesheetPackage object, PackageDetails packageDetails) {
        String string = ((StylesheetPackage)object).getPackageName();
        if (packageDetails.baseName != null) {
            if (!packageDetails.baseName.equals(string)) {
                throw new XPathException("Base name of package (" + packageDetails.baseName + ") does not match the value in the XSLT source (" + string + ")");
            }
        } else if (!packageDetails.nameAndVersion.packageName.equals(string)) {
            throw new XPathException("Registered name of package (" + packageDetails.nameAndVersion.packageName + ") does not match the value in the XSLT source (" + string + ")");
        }
        if (!((PackageVersion)(object = ((StylesheetPackage)object).getPackageVersion())).equals(packageDetails.nameAndVersion.packageVersion)) {
            throw new XPathException("Registered version number of package (" + packageDetails.nameAndVersion.packageVersion + ") does not match the value in the XSLT source (" + object + ")");
        }
    }

    public synchronized List<StylesheetPackage> getPackages() {
        ArrayList<StylesheetPackage> arrayList = new ArrayList<StylesheetPackage>();
        for (PackageDetails packageDetails : this.d.values()) {
            if (packageDetails.loadedPackage == null) continue;
            arrayList.add(packageDetails.loadedPackage);
        }
        return arrayList;
    }
}

