/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.rules.RuleTarget;

public class Rule {
    protected Pattern pattern;
    protected RuleTarget action;
    protected int precedence;
    protected int minImportPrecedence;
    protected double priority;
    protected Rule next;
    protected int sequence;
    protected int part;
    private boolean a;
    private int b;

    public Rule() {
    }

    public Rule(Pattern pattern, RuleTarget ruleTarget, int n2, int n3, double d2, int n4, int n5) {
        this.pattern = pattern;
        this.action = ruleTarget;
        this.precedence = n2;
        this.minImportPrecedence = n3;
        this.priority = d2;
        this.next = null;
        this.sequence = n4;
        this.part = n5;
        ruleTarget.registerRule(this);
    }

    protected void copyFrom(Rule rule, boolean bl2) {
        this.pattern = rule.pattern.copy(new RebindingMap());
        this.action = rule.action instanceof TemplateRule ? ((TemplateRule)rule.action).copy() : rule.action;
        this.precedence = rule.precedence;
        this.minImportPrecedence = rule.minImportPrecedence;
        this.priority = rule.priority;
        this.sequence = rule.sequence;
        this.part = rule.part;
        this.next = rule.next == null || !bl2 ? null : rule.next.copy(true);
        this.action.registerRule(this);
    }

    public Rule copy(boolean bl2) {
        Rule rule = new Rule();
        rule.copyFrom(this, bl2);
        return rule;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getPartNumber() {
        return this.part;
    }

    public void setAction(RuleTarget ruleTarget) {
        this.action = ruleTarget;
    }

    public RuleTarget getAction() {
        return this.action;
    }

    public Rule getNext() {
        return this.next;
    }

    public void setNext(Rule rule) {
        this.next = rule;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setAlwaysMatches(boolean bl2) {
        this.a = bl2;
    }

    public boolean isAlwaysMatches() {
        return this.a;
    }

    public void setRank(int n2) {
        this.b = n2;
    }

    public int getRank() {
        return this.b;
    }

    public void export(ExpressionPresenter expressionPresenter, boolean bl2) {
        RuleTarget ruleTarget = this.getAction();
        if (ruleTarget instanceof TemplateRule) {
            int n2;
            ruleTarget = (TemplateRule)ruleTarget;
            int n3 = expressionPresenter.startElement("templateRule");
            expressionPresenter.emitAttribute("prec", "" + this.getPrecedence());
            expressionPresenter.emitAttribute("prio", "" + this.getPriority());
            expressionPresenter.emitAttribute("seq", "" + this.getSequence());
            if (this.part != 0) {
                expressionPresenter.emitAttribute("part", "" + this.part);
            }
            expressionPresenter.emitAttribute("rank", "" + this.getRank());
            expressionPresenter.emitAttribute("minImp", "" + this.getMinImportPrecedence());
            expressionPresenter.emitAttribute("slots", "" + ((TemplateRule)ruleTarget).getStackFrameMap().getNumberOfVariables());
            ((TemplateRule)ruleTarget).explainProperties(expressionPresenter);
            this.exportOtherProperties(expressionPresenter);
            expressionPresenter.setChildRole("match");
            ((Expression)this.getPattern()).export(expressionPresenter);
            if (((TemplateRule)ruleTarget).getBody() != null) {
                expressionPresenter.setChildRole("action");
                ((TemplateRule)ruleTarget).getBody().export(expressionPresenter);
            }
            if (n3 != (n2 = expressionPresenter.endElement())) {
                throw new IllegalStateException("exported expression tree unbalanced in template at line " + (ruleTarget != null ? ((TemplateRule)ruleTarget).getLineNumber() + " of " + ((TemplateRule)ruleTarget).getSystemId() : ""));
            }
            return;
        }
        ruleTarget.export(expressionPresenter);
    }

    public void exportOtherProperties(ExpressionPresenter expressionPresenter) {
    }

    public int compareRank(Rule rule) {
        return this.b - rule.b;
    }

    public int compareComputedRank(Rule rule) {
        if (this.precedence == rule.precedence) {
            return Double.compare(this.priority, rule.priority);
        }
        if (this.precedence < rule.precedence) {
            return -1;
        }
        return 1;
    }

    public boolean matches(Item item, XPathContextMajor xPathContextMajor) {
        return this.a || this.pattern.matches(item, xPathContextMajor);
    }
}

