/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.rules.Rule;

public final class RuleManager {
    private StylesheetPackage a;
    private Configuration b;
    private SimpleMode c;
    private HashMap<StructuredQName, Mode> d;
    private SimpleMode e;
    private int f;
    private boolean g;
    private CompilerInfo h;
    private int i;

    public RuleManager(StylesheetPackage stylesheetPackage) {
        StylesheetPackage stylesheetPackage2 = stylesheetPackage;
        this(stylesheetPackage2, stylesheetPackage2.getConfiguration().getDefaultXsltCompilerInfo());
    }

    public RuleManager(StylesheetPackage object, CompilerInfo compilerInfo) {
        this.e = null;
        this.i = 0;
        this.a = object;
        this.b = ((PackageData)object).getConfiguration();
        this.h = compilerInfo;
        this.c = this.b.makeMode(Mode.UNNAMED_MODE_NAME, this.h);
        object = this.c.makeDeclaringComponent(Visibility.PRIVATE, this.a);
        ((Component)object).setVisibility(Visibility.PRIVATE, VisibilityProvenance.DEFAULTED);
        this.a.addComponent((Component)object);
        this.c.setRecoveryPolicy(this.f);
        this.d = new HashMap(5);
    }

    public final void setUnnamedModeExplicit(boolean bl2) {
        this.g = bl2;
    }

    public final boolean isUnnamedModeExplicit() {
        return this.g;
    }

    public final void setCompilerInfo(CompilerInfo compilerInfo) {
        this.h = compilerInfo;
    }

    public final void setRecoveryPolicy(int n2) {
        this.f = n2;
        this.c.setRecoveryPolicy(n2);
    }

    public final int getRecoveryPolicy() {
        return this.f;
    }

    public final Collection<Mode> getAllNamedModes() {
        return this.d.values();
    }

    public final SimpleMode getUnnamedMode() {
        return this.c;
    }

    public final Mode obtainMode(StructuredQName object, boolean bl2) {
        if (object == null || ((StructuredQName)object).equals(Mode.UNNAMED_MODE_NAME)) {
            return this.c;
        }
        if (((StructuredQName)object).equals(Mode.OMNI_MODE)) {
            if (this.e == null) {
                this.e = this.b.makeMode((StructuredQName)object, this.h);
                this.e.setRecoveryPolicy(this.f);
            }
            return this.e;
        }
        Mode mode = this.d.get(object);
        if (mode == null && bl2) {
            mode = this.b.makeMode((StructuredQName)object, this.h);
            mode.setRecoveryPolicy(this.f);
            this.d.put((StructuredQName)object, mode);
            object = mode.makeDeclaringComponent(Visibility.PRIVATE, this.a);
            ((Component)object).setVisibility(Visibility.PRIVATE, VisibilityProvenance.DEFAULTED);
            this.a.addComponent((Component)object);
        }
        return mode;
    }

    public final void registerMode(Mode mode) {
        this.d.put(mode.getModeName(), mode);
    }

    public final boolean existsOmniMode() {
        return this.e != null;
    }

    public final int allocateSequenceNumber() {
        return this.i++;
    }

    public final int registerRule(Pattern pattern, TemplateRule templateRule, Mode mode, StylesheetModule stylesheetModule, double d2, int n2, int n3) {
        if (pattern instanceof UnionPattern) {
            Pattern pattern2 = (UnionPattern)pattern;
            Pattern pattern3 = pattern2.getLHS();
            pattern2 = pattern2.getRHS();
            n3 = this.registerRule(pattern3, templateRule, mode, stylesheetModule, d2, n2, n3);
            int n4 = this.registerRule(pattern2, templateRule, mode, stylesheetModule, d2, n2, n3);
            return n3 + n4;
        }
        if (pattern instanceof NodeTestPattern && ((Expression)pattern).getItemType() instanceof CombinedNodeTest && ((CombinedNodeTest)((Expression)pattern).getItemType()).getOperator() == 1) {
            Object object = (CombinedNodeTest)((Expression)pattern).getItemType();
            NodeTest[] nodeTestArray = ((CombinedNodeTest)object).getComponentNodeTests();
            object = new NodeTestPattern(nodeTestArray[0]);
            ExpressionTool.copyLocationInfo(pattern, (Expression)object);
            n3 = this.registerRule((Pattern)object, templateRule, mode, stylesheetModule, d2, n2, n3);
            object = new NodeTestPattern(nodeTestArray[1]);
            ExpressionTool.copyLocationInfo(pattern, (Expression)object);
            int n5 = this.registerRule((Pattern)object, templateRule, mode, stylesheetModule, d2, n2, n3);
            return n3 + n5;
        }
        if (Double.isNaN(d2)) {
            d2 = pattern.getDefaultPriority();
        } else {
            n3 = 0;
        }
        if (mode instanceof SimpleMode) {
            StylesheetModule stylesheetModule2 = stylesheetModule;
            ((SimpleMode)mode).addRule(pattern, templateRule, stylesheetModule2, stylesheetModule2.getPrecedence(), d2, n2, n3);
        } else {
            mode.getActivePart().addRule(pattern, templateRule, stylesheetModule, mode.getMaxPrecedence(), d2, n2, n3);
        }
        return 1;
    }

    public final Rule getTemplateRule(Item item, Mode mode, int n2, int n3, XPathContext xPathContext) {
        if (mode == null) {
            mode = this.c;
        }
        return mode.getRule(item, n2, n3, xPathContext);
    }

    public final void computeRankings() {
        ((Mode)this.c).computeRankings(0);
        for (Mode mode : this.d.values()) {
            mode.computeRankings(0);
        }
    }

    public final void invertStreamableTemplates() {
        this.c.invertStreamableTemplates();
        for (Mode mode : this.d.values()) {
            mode.getActivePart().invertStreamableTemplates();
        }
    }

    public final void checkConsistency() {
        this.c.checkForConflictingProperties();
        for (Mode mode : this.d.values()) {
            mode.getActivePart().checkForConflictingProperties();
        }
    }

    public final void explainTemplateRules(ExpressionPresenter expressionPresenter) {
        this.c.explain(expressionPresenter);
        for (Mode mode : this.d.values()) {
            mode.explain(expressionPresenter);
        }
    }

    public final void optimizeRules() {
        this.c.optimizeRules();
        for (Mode mode : this.d.values()) {
            mode.getActivePart().optimizeRules();
        }
    }
}

