/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;

public class NamespaceNode
implements NodeInfo {
    private NodeInfo a;
    private NamespaceBinding b;
    private int c;
    private int d;

    public NamespaceNode(NodeInfo nodeInfo, NamespaceBinding namespaceBinding, int n2) {
        this.a = nodeInfo;
        this.b = namespaceBinding;
        this.c = n2;
        this.d = -1;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.a.getTreeInfo();
    }

    @Override
    public NodeInfo head() {
        return this;
    }

    @Override
    public UnfailingIterator<NodeInfo> iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public int getNodeKind() {
        return 13;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NamespaceNode && this.a.equals(((NamespaceNode)object).a) && this.b.equals(((NamespaceNode)object).b);
    }

    @Override
    public int hashCode() {
        return this.a.hashCode() ^ this.c << 13;
    }

    @Override
    public String getSystemId() {
        return this.a.getSystemId();
    }

    @Override
    public String getPublicId() {
        return this.a.getPublicId();
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.a.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.a.getColumnNumber();
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof NamespaceNode && this.a.equals(((NamespaceNode)nodeInfo).a)) {
            int n2 = this.c - ((NamespaceNode)nodeInfo).c;
            return Integer.compare(n2, 0);
        }
        if (this.a.equals(nodeInfo)) {
            return 1;
        }
        return this.a.compareOrder(nodeInfo);
    }

    @Override
    public String getStringValue() {
        return this.b.getURI();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    @Override
    public boolean hasFingerprint() {
        return true;
    }

    @Override
    public int getFingerprint() {
        if (this.d == -1) {
            if (this.b.getPrefix().isEmpty()) {
                return -1;
            }
            this.d = this.a.getConfiguration().getNamePool().allocateFingerprint("", this.b.getPrefix());
        }
        return this.d;
    }

    @Override
    public String getLocalPart() {
        return this.b.getPrefix();
    }

    @Override
    public String getURI() {
        return "";
    }

    @Override
    public String getDisplayName() {
        return this.getLocalPart();
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public Configuration getConfiguration() {
        return this.a.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    @Override
    public SchemaType getSchemaType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public NodeInfo getParent() {
        return this.a;
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return this.a.iterateAxis((byte)1, nodeTest);
            }
            case 1: {
                if (nodeTest.matchesNode(this)) {
                    NamespaceNode namespaceNode = this;
                    return new PrependAxisIterator(namespaceNode, namespaceNode.a.iterateAxis((byte)1, nodeTest));
                }
                return this.a.iterateAxis((byte)1, nodeTest);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.a, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.a.getRoot();
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        this.a.generateId(fastStringBuffer);
        fastStringBuffer.append("n");
        fastStringBuffer.append(Integer.toString(this.c));
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        receiver.namespace(this.b, 32);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return null;
    }

    @Override
    public void setSystemId(String string) {
    }

    @Override
    public AtomicSequence atomize() {
        return new StringValue(this.getStringValueCS());
    }

    @Override
    public boolean isStreamed() {
        return this.a.isStreamed();
    }

    public static AxisIterator makeIterator(NodeInfo nodeInfo, NodeTest nodeTest) {
        NamespaceNode namespaceNode;
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
        Iterator<NamespaceBinding> iterator = NamespaceIterator.iterateNamespaces(nodeInfo);
        int n2 = 0;
        while (iterator.hasNext()) {
            namespaceNode = new NamespaceNode(nodeInfo, iterator.next(), n2++);
            if (!nodeTest.matchesNode(namespaceNode)) continue;
            arrayList.add(namespaceNode);
        }
        namespaceNode = new NamespaceNode(nodeInfo, NamespaceBinding.XML, n2);
        if (nodeTest.matchesNode(namespaceNode)) {
            arrayList.add(namespaceNode);
        }
        return new ListIterator.OfNodes((List<NodeInfo>)arrayList);
    }
}

