/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;

public class AdjacentTextNodeMergingIterator
implements LookaheadIterator<Item<?>> {
    private SequenceIterator<?> a;
    private Item<?> b;

    public AdjacentTextNodeMergingIterator(SequenceIterator<?> sequenceIterator) {
        this.a = sequenceIterator;
        this.b = sequenceIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.b != null;
    }

    @Override
    public Item next() {
        Orphan orphan = this.b;
        if (orphan == null) {
            return null;
        }
        this.b = this.a.next();
        if (AdjacentTextNodeMerger.isTextNode(orphan)) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
            fastStringBuffer.append(orphan.getStringValueCS());
            while (AdjacentTextNodeMerger.isTextNode(this.b)) {
                fastStringBuffer.append(this.b.getStringValueCS());
                this.b = this.a.next();
            }
            if (fastStringBuffer.isEmpty()) {
                return this.next();
            }
            orphan = new Orphan(((NodeInfo)orphan).getConfiguration());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(fastStringBuffer);
            return orphan;
        }
        return orphan;
    }

    @Override
    public void close() {
        this.a.close();
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

