/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.Arrays;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SequenceExtent;

public class ArrayIterator<T extends Item<?>>
implements LastPositionFinder,
GroundedIterator<T>,
LookaheadIterator<T>,
UnfailingIterator<T> {
    protected T[] items;
    private int a;
    protected int start;
    protected int end;

    public ArrayIterator(T[] TArray) {
        this.items = TArray;
        this.start = 0;
        this.end = TArray.length;
        this.a = 0;
    }

    public ArrayIterator(T[] TArray, int n2, int n3) {
        this.items = TArray;
        this.end = n3;
        this.start = n2;
        this.a = n2;
    }

    public SequenceIterator<T> makeSliceIterator(int n2, int n3) {
        int n4;
        Item[] itemArray = this.getArray();
        int n5 = this.getStartPosition();
        int n6 = this.getEndPosition();
        if (n2 <= 0) {
            n2 = 1;
        }
        if ((n4 = n5 + (n2 - 1)) < n5) {
            n4 = n5;
        }
        if ((n2 = n3 == Integer.MAX_VALUE ? n6 : n4 + n3 - n2 + 1) > n6) {
            n2 = n6;
        }
        if (n2 <= n4) {
            return EmptyIterator.emptyIterator();
        }
        return new ArrayIterator(itemArray, n4, n2);
    }

    @Override
    public boolean hasNext() {
        return this.a < this.end;
    }

    @Override
    public T next() {
        if (this.a >= this.end) {
            this.a = this.end + 1;
            return null;
        }
        return this.items[this.a++];
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    public T[] getArray() {
        return this.items;
    }

    public int getStartPosition() {
        return this.start;
    }

    public int getEndPosition() {
        return this.end;
    }

    @Override
    public GroundedValue<T> materialize() {
        Iterable<Object> iterable;
        if (this.start == 0 && this.end == this.items.length) {
            iterable = new SequenceExtent(this.items);
        } else {
            iterable = Arrays.asList(this.items).subList(this.start, this.end);
            iterable = new SequenceExtent<T>(iterable);
        }
        return ((SequenceExtent)iterable).reduce();
    }

    @Override
    public GroundedValue<T> getResidue() {
        Iterable<Object> iterable;
        if (this.start == 0 && this.a == 0 && this.end == this.items.length) {
            iterable = new SequenceExtent(this.items);
        } else {
            iterable = Arrays.asList(this.items).subList(this.start + this.a, this.end);
            iterable = new SequenceExtent<T>(iterable);
        }
        return ((SequenceExtent)iterable).reduce();
    }

    @Override
    public int getProperties() {
        return 7;
    }

    public static class OfNodes
    extends ArrayIterator<NodeInfo>
    implements AxisIterator {
        public OfNodes(NodeInfo[] nodeInfoArray) {
            super((Item[])nodeInfoArray);
        }
    }
}

