/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

public class ListIterator<T extends Item<?>>
implements LastPositionFinder,
GroundedIterator<T>,
LookaheadIterator<T>,
ReversibleIterator<T>,
UnfailingIterator<T> {
    private int a = 0;
    protected List<T> list;

    public ListIterator(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.a < this.list.size();
    }

    @Override
    public T next() {
        if (this.a >= this.list.size()) {
            return null;
        }
        return (T)((Item)this.list.get(this.a++));
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public GroundedValue<T> materialize() {
        return SequenceExtent.makeSequenceExtent(this.list);
    }

    @Override
    public GroundedValue<T> getResidue() {
        List<T> list = this.list;
        if (this.a != 0) {
            list = list.subList(this.a, list.size());
        }
        return SequenceExtent.makeSequenceExtent(list);
    }

    @Override
    public SequenceIterator<T> getReverseIterator() {
        return new ReverseListIterator<T>(this.list);
    }

    public static class OfNodes
    extends ListIterator<NodeInfo>
    implements AxisIterator {
        public OfNodes(List<NodeInfo> list) {
            super(list);
        }

        @Override
        public NodeInfo next() {
            return (NodeInfo)super.next();
        }
    }

    public static class Atomic
    extends ListIterator<AtomicValue>
    implements AtomicIterator {
        public Atomic(List<AtomicValue> list) {
            super(list);
        }
    }
}

