/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.util.function.IntPredicate;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public abstract class TextLinesIterator
implements SequenceIterator<StringValue> {
    protected LineNumberReader reader;
    protected IntPredicate checker;
    private StringValue a = null;
    private int b = 0;
    protected Location location;
    protected URI uri;

    protected TextLinesIterator() {
    }

    public TextLinesIterator(LineNumberReader lineNumberReader, Location location, URI uRI, IntPredicate intPredicate) {
        this.reader = lineNumberReader;
        this.location = location;
        this.uri = uRI;
        this.checker = intPredicate;
    }

    @Override
    public StringValue next() {
        if (this.b < 0) {
            this.close();
            return null;
        }
        try {
            String string = this.reader.readLine();
            if (string == null) {
                this.a = null;
                this.b = -1;
                this.close();
                return null;
            }
            if (this.b == 0 && string.startsWith("\ufeff")) {
                string = string.substring(1);
            }
            TextLinesIterator textLinesIterator = this;
            String string2 = string;
            IntPredicate intPredicate = textLinesIterator.checker;
            TextLinesIterator textLinesIterator2 = textLinesIterator;
            int n2 = 0;
            while (n2 < string2.length()) {
                int n3;
                if (UTF16CharacterSet.isHighSurrogate(n3 = string2.charAt(n2++))) {
                    char c2 = string2.charAt(n2++);
                    n3 = UTF16CharacterSet.combinePair((char)n3, c2);
                }
                if (intPredicate.test(n3)) continue;
                XPathException xPathException = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + textLinesIterator2.b + " column=" + (n2 + 1) + " value=hex " + Integer.toHexString(n3) + ')');
                xPathException.setErrorCode("FOUT1190");
                xPathException.setLocator(textLinesIterator2.location);
                throw xPathException;
            }
            this.a = new StringValue(string);
            ++this.b;
            return this.a;
        }
        catch (IOException iOException) {
            this.close();
            XPathException xPathException = UnparsedTextFunction.handleIOError(this.uri, iOException, null);
            if (this.location != null) {
                xPathException.setLocator(this.location);
            }
            throw xPathException;
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

