/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.SequenceExtent;

public interface UnfailingIterator<T extends Item<?>>
extends SequenceIterator<T> {
    @Override
    public T next();

    default public void forEach(Consumer<T> consumer) {
        T t2;
        while ((t2 = this.next()) != null) {
            consumer.accept(t2);
        }
    }

    default public Optional<T> firstWith(Predicate<? super T> predicate) {
        T t2;
        while ((t2 = this.next()) != null) {
            if (!predicate.test(t2)) continue;
            this.close();
            return Optional.of(t2);
        }
        return Optional.empty();
    }

    default public List<T> toList() {
        ArrayList arrayList = new ArrayList();
        this.forEach(arrayList::add);
        return arrayList;
    }

    default public GroundedValue<T> toGroundedValue() {
        return SequenceExtent.makeSequenceExtent(this.toList());
    }
}

