/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.f;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class AttributeImpl
extends NodeImpl {
    public AttributeImpl(ElementImpl elementImpl, int n2) {
        this.setRawParent(elementImpl);
        this.setSiblingPosition(n2);
    }

    @Override
    public NodeName getNodeName() {
        if (this.getRawParent() == null || this.getSiblingPosition() == -1) {
            return null;
        }
        return ((ElementImpl)this.getRawParent()).getAttributeList().getNodeName(this.getSiblingPosition());
    }

    @Override
    public int getFingerprint() {
        if (this.getRawParent() == null || this.getSiblingPosition() == -1) {
            return -1;
        }
        return ((ElementImpl)this.getRawParent()).getAttributeList().getFingerprint(this.getSiblingPosition());
    }

    @Override
    public SchemaType getSchemaType() {
        return ((ElementImpl)this.getRawParent()).getAttributeList().getTypeAnnotation(this.getSiblingPosition());
    }

    @Override
    public boolean isId() {
        try {
            return ((NodeImpl)this).getFingerprint() == 388 || ((NodeImpl)this).getSchemaType().isIdType();
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
    }

    @Override
    public boolean isIdref() {
        AttributeCollection attributeCollection = ((ElementImpl)this.getRawParent()).getAttributeList();
        if ((attributeCollection.getProperties(this.getSiblingPosition()) & 0x1000) != 0) {
            return true;
        }
        return ElementImpl.a(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AttributeImpl)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        object = (AttributeImpl)object;
        return this.getRawParent().equals(((NodeImpl)object).getRawParent()) && this.getSiblingPosition() == ((NodeImpl)object).getSiblingPosition();
    }

    @Override
    public int hashCode() {
        return this.getRawParent().hashCode() ^ this.getSiblingPosition() << 16;
    }

    @Override
    protected long getSequenceNumber() {
        long l2 = this.getRawParent().getSequenceNumber();
        if (l2 == -1L) {
            return l2;
        }
        return l2 + 32768L + (long)this.getSiblingPosition();
    }

    @Override
    public final int getNodeKind() {
        return 2;
    }

    @Override
    public String getStringValue() {
        return ((ElementImpl)this.getRawParent()).getAttributeList().getValue(this.getSiblingPosition());
    }

    @Override
    public NodeImpl getNextSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousSibling() {
        return null;
    }

    @Override
    public NodeImpl getPreviousInDocument() {
        return this.getParent();
    }

    @Override
    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (nodeImpl == this) {
            return null;
        }
        return this.getParent().getNextInDocument(nodeImpl);
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        this.getParent().generateId(fastStringBuffer);
        fastStringBuffer.append('a');
        fastStringBuffer.append(Integer.toString(this.getSiblingPosition()));
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        BuiltInAtomicType builtInAtomicType = CopyOptions.includes(n2, 4) ? (SimpleType)((NodeImpl)this).getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
        receiver.attribute(NameOfNode.makeName(this), builtInAtomicType, this.getStringValue(), location, 0);
    }

    @Override
    public void delete() {
        if (this.getRawParent() != null) {
            this.getRawParent().removeAttribute(this);
        }
        this.setRawParent(null);
        this.setSiblingPosition(-1);
    }

    @Override
    public boolean isDeleted() {
        return this.getSiblingPosition() == -1 || ((NodeImpl)this).getFingerprint() == -1 || this.getRawParent() != null && this.getRawParent().isDeleted();
    }

    @Override
    public void replace(NodeInfo[] nodeInfoArray, boolean bl2) {
        if (((NodeImpl)this).isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.getParent() == null) {
            throw new IllegalStateException("Cannot replace a parentless node");
        }
        f f2 = this.getRawParent();
        ((NodeImpl)this).delete();
        for (NodeInfo nodeInfo : nodeInfoArray) {
            if (nodeInfo.getNodeKind() != 2) {
                throw new IllegalArgumentException("Replacement nodes must be attributes");
            }
            f2.addAttribute(NameOfNode.makeName(nodeInfo), BuiltInAtomicType.UNTYPED_ATOMIC, nodeInfo.getStringValue(), 0);
        }
    }

    @Override
    public void rename(NodeName object) {
        if (this.getRawParent() != null) {
            ((AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList()).renameAttribute(this.getSiblingPosition(), (NodeName)object);
            String string = object.getURI();
            if (!string.isEmpty()) {
                object = object.getPrefix();
                NamespaceBinding namespaceBinding = new NamespaceBinding((String)object, string);
                object = ((ElementImpl)this.getRawParent()).getURIForPrefix((String)object, false);
                if (object == null) {
                    this.getRawParent().addNamespace(namespaceBinding, false);
                    return;
                }
                if (!((String)object).equals(string)) {
                    throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
                }
            }
        }
    }

    @Override
    public void replaceStringValue(CharSequence charSequence) {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl attributeCollectionImpl = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            attributeCollectionImpl.replaceAttribute(this.getSiblingPosition(), charSequence);
        }
    }

    @Override
    public void removeTypeAnnotation() {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl attributeCollectionImpl = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            attributeCollectionImpl.setTypeAnnotation(this.getSiblingPosition(), BuiltInAtomicType.UNTYPED_ATOMIC);
            this.getRawParent().removeTypeAnnotation();
        }
    }

    @Override
    public void setTypeAnnotation(SchemaType schemaType) {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl attributeCollectionImpl = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            attributeCollectionImpl.setTypeAnnotation(this.getSiblingPosition(), (SimpleType)schemaType);
        }
    }
}

