/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.MutableDocumentInfo;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.LineNumberMap;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.SystemIdMap;
import net.sf.saxon.tree.linked.f;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;

public final class DocumentImpl
extends f
implements MutableDocumentInfo,
TreeInfo {
    private ElementImpl a;
    private HashMap<String, NodeInfo> b;
    private long c;
    private String d;
    private HashMap<String, String[]> e;
    private Set<ElementImpl> f;
    private Set<ElementImpl> g;
    private IntHashMap<List<NodeInfo>> h;
    private HashMap<String, Object> i;
    private Configuration j;
    private LineNumberMap k;
    private SystemIdMap l = new SystemIdMap();
    private boolean m;
    private SpaceStrippingRule n = NoElementsSpaceStrippingRule.getInstance();

    public DocumentImpl() {
        this.setRawParent(null);
    }

    @Override
    public final NodeInfo getRootNode() {
        return this;
    }

    public final void setConfiguration(Configuration configuration) {
        this.j = configuration;
        this.c = configuration.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public final Configuration getConfiguration() {
        return this.j;
    }

    @Override
    public final NamePool getNamePool() {
        return this.j.getNamePool();
    }

    @Override
    public final Builder newBuilder() {
        LinkedTreeBuilder linkedTreeBuilder = new LinkedTreeBuilder(this.j.makePipelineConfiguration());
        linkedTreeBuilder.setAllocateSequenceNumbers(false);
        return linkedTreeBuilder;
    }

    public final void setImaginary(boolean bl2) {
        this.m = bl2;
    }

    public final boolean isImaginary() {
        return this.m;
    }

    @Override
    public final boolean isTyped() {
        return this.a != null && ((NodeImpl)this.a).getSchemaType() != Untyped.getInstance();
    }

    @Override
    public final long getDocumentNumber() {
        return this.c;
    }

    public final void setDocumentElement(ElementImpl elementImpl) {
        this.a = elementImpl;
    }

    public final void graftLocationMap(DocumentImpl documentImpl) {
        this.l = documentImpl.l;
        this.k = documentImpl.k;
    }

    @Override
    public final void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.l.setSystemId(this.getRawSequenceNumber(), string);
    }

    @Override
    public final String getSystemId() {
        return this.l.getSystemId(this.getRawSequenceNumber());
    }

    public final void setBaseURI(String string) {
        this.d = string;
    }

    @Override
    public final String getBaseURI() {
        if (this.d != null) {
            return this.d;
        }
        return ((NodeImpl)this).getSystemId();
    }

    final void a(int n2, String string) {
        if (string == null) {
            string = "";
        }
        this.l.setSystemId(n2, string);
    }

    final String a(int n2) {
        return this.l.getSystemId(n2);
    }

    public final void setLineNumbering() {
        this.k = new LineNumberMap();
        this.k.setLineAndColumn(this.getRawSequenceNumber(), 0, -1);
    }

    final void a(int n2, int n3, int n4) {
        if (this.k != null && n2 >= 0) {
            this.k.setLineAndColumn(n2, n3, n4);
        }
    }

    final int b(int n2) {
        if (this.k != null && n2 >= 0) {
            return this.k.getLineNumber(n2);
        }
        return -1;
    }

    final int c(int n2) {
        if (this.k != null && n2 >= 0) {
            return this.k.getColumnNumber(n2);
        }
        return -1;
    }

    public final void addNilledElement(ElementImpl elementImpl) {
        if (this.f == null) {
            this.f = new HashSet<ElementImpl>();
        }
        this.f.add(elementImpl);
    }

    final boolean a(ElementImpl elementImpl) {
        return this.f != null && this.f.contains(elementImpl);
    }

    public final void markTopWithinEntity(ElementImpl elementImpl) {
        if (this.g == null) {
            this.g = new HashSet<ElementImpl>();
        }
        this.g.add(elementImpl);
    }

    public final boolean isTopWithinEntity(ElementImpl elementImpl) {
        return this.g != null && this.g.contains(elementImpl);
    }

    @Override
    public final int getLineNumber() {
        return 0;
    }

    @Override
    public final int getNodeKind() {
        return 9;
    }

    @Override
    public final NodeImpl getNextSibling() {
        return null;
    }

    @Override
    public final NodeImpl getPreviousSibling() {
        return null;
    }

    public final ElementImpl getDocumentElement() {
        return this.a;
    }

    @Override
    public final NodeInfo getRoot() {
        return this;
    }

    @Override
    public final DocumentImpl getPhysicalRoot() {
        return this;
    }

    @Override
    public final void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append('d');
        fastStringBuffer.append(Long.toString(this.c));
    }

    final ListIterator.OfNodes d(int n2) {
        IntHashMap<List<NodeInfo>> intHashMap;
        List<NodeInfo> list;
        if (this.h == null) {
            this.h = new IntHashMap(500);
        }
        if ((list = (intHashMap = this.h).get(n2)) == null) {
            list = new ArrayList<NodeInfo>(500);
            DocumentImpl documentImpl = this;
            for (NodeImpl nodeImpl = (v515744).getNextInDocument(v515744); nodeImpl != null; nodeImpl = nodeImpl.getNextInDocument(this)) {
                if (nodeImpl.getNodeKind() != 1 || nodeImpl.getFingerprint() != n2) continue;
                list.add(nodeImpl);
            }
            intHashMap.put(n2, list);
        }
        return new ListIterator.OfNodes(list);
    }

    public final void deIndex(NodeImpl nodeImpl) {
        if (nodeImpl instanceof ElementImpl) {
            IntHashMap<List<NodeInfo>> intHashMap = this.h;
            if (intHashMap != null) {
                if ((intHashMap = intHashMap.get(nodeImpl.getFingerprint())) == null) {
                    return;
                }
                intHashMap.remove(nodeImpl);
            }
            if (nodeImpl.isId()) {
                this.deregisterID(nodeImpl.getStringValue());
            }
            return;
        }
        if (nodeImpl instanceof AttributeImpl && nodeImpl.isId()) {
            this.deregisterID(nodeImpl.getStringValue());
        }
    }

    protected final void registerID(NodeInfo nodeInfo, String string) {
        if (this.b == null) {
            this.b = new HashMap(256);
        }
        HashMap<String, NodeInfo> hashMap = this.b;
        hashMap.putIfAbsent(string, nodeInfo);
    }

    @Override
    public final NodeInfo selectID(String string, boolean bl2) {
        NodeInfo nodeInfo;
        if (this.b == null) {
            nodeInfo = this;
            if (((DocumentImpl)nodeInfo).b == null) {
                NodeInfo nodeInfo2;
                ((DocumentImpl)nodeInfo).b = new HashMap(256);
                NodeInfo nodeInfo3 = nodeInfo2 = nodeInfo;
                while (nodeInfo2 != null) {
                    if (nodeInfo2.getNodeKind() == 1) {
                        ElementImpl elementImpl = (ElementImpl)nodeInfo2;
                        if (elementImpl.isId()) {
                            ElementImpl elementImpl2 = elementImpl;
                            ((DocumentImpl)nodeInfo).registerID(elementImpl2, Whitespace.trim(((NodeImpl)elementImpl2).getStringValueCS()));
                        }
                        AttributeCollectionImpl attributeCollectionImpl = (AttributeCollectionImpl)elementImpl.getAttributeList();
                        for (int i2 = 0; i2 < attributeCollectionImpl.getLength(); ++i2) {
                            if (attributeCollectionImpl.isDeleted(i2) || !attributeCollectionImpl.isId(i2) || !NameChecker.isValidNCName(Whitespace.trim(attributeCollectionImpl.getValue(i2)))) continue;
                            ((DocumentImpl)nodeInfo).registerID(elementImpl, Whitespace.trim(attributeCollectionImpl.getValue(i2)));
                        }
                    }
                    nodeInfo2 = ((NodeImpl)nodeInfo2).getNextInDocument((NodeImpl)nodeInfo3);
                }
            }
        }
        assert (this.b != null);
        nodeInfo = this.b.get(string);
        if (nodeInfo != null && bl2 && nodeInfo.isId() && nodeInfo.getStringValue().equals(string)) {
            nodeInfo = nodeInfo.getParent();
        }
        return nodeInfo;
    }

    protected final void deregisterID(String string) {
        string = Whitespace.trim(string);
        if (this.b != null) {
            this.b.remove(string);
        }
    }

    public final void setUnparsedEntity(String string, String string2, String string3) {
        if (this.e == null) {
            this.e = new HashMap(10);
        }
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = string2;
        stringArray2[1] = string3;
        this.e.put(string, stringArray2);
    }

    @Override
    public final Iterator<String> getUnparsedEntityNames() {
        if (this.e == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.e.keySet().iterator();
    }

    @Override
    public final String[] getUnparsedEntity(String string) {
        if (this.e == null) {
            return null;
        }
        return this.e.get(string);
    }

    @Override
    public final SchemaType getSchemaType() {
        if (this.a == null || ((NodeImpl)this.a).getSchemaType() == Untyped.getInstance()) {
            return Untyped.getInstance();
        }
        return AnyType.getInstance();
    }

    @Override
    public final void copy(Receiver receiver, int n2, Location location) {
        receiver.startDocument(CopyOptions.getStartDocumentProperties(n2));
        Object object = this.getUnparsedEntityNames();
        while (object.hasNext()) {
            String string = object.next();
            String[] stringArray = this.getUnparsedEntity(string);
            assert (stringArray != null);
            receiver.setUnparsedEntity(string, stringArray[0], stringArray[1]);
        }
        for (object = ((NodeImpl)this).getFirstChild(); object != null; object = ((NodeImpl)object).getNextSibling()) {
            object.copy(receiver, n2, location);
        }
        receiver.endDocument();
    }

    @Override
    public final void replaceStringValue(CharSequence charSequence) {
        throw new UnsupportedOperationException("Cannot replace the value of a document node");
    }

    @Override
    public final void resetIndexes() {
        this.b = null;
        this.h = null;
    }

    @Override
    public final void setSpaceStrippingRule(SpaceStrippingRule spaceStrippingRule) {
        this.n = spaceStrippingRule;
    }

    @Override
    public final SpaceStrippingRule getSpaceStrippingRule() {
        return this.n;
    }

    @Override
    public final void setUserData(String string, Object object) {
        if (this.i == null) {
            this.i = new HashMap(4);
        }
        if (object == null) {
            this.i.remove(string);
            return;
        }
        this.i.put(string, object);
    }

    @Override
    public final Object getUserData(String string) {
        if (this.i == null) {
            return null;
        }
        return this.i.get(string);
    }
}

