/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.linked.f;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class ElementImpl
extends f
implements NamespaceResolver {
    private NodeName a;
    private SchemaType b = Untyped.getInstance();
    private AttributeCollection c;
    private NamespaceBinding[] d = null;

    public void setAttributeList(AttributeCollection attributeCollection) {
        this.c = attributeCollection;
    }

    public void setNamespaceList(NamespaceBinding[] namespaceBindingArray) {
        this.d = namespaceBindingArray;
    }

    public void setNodeName(NodeName nodeName) {
        this.a = nodeName;
    }

    public void initialise(NodeName nodeName, SchemaType schemaType, AttributeCollectionImpl attributeCollectionImpl, NodeInfo nodeInfo, int n2) {
        this.a = nodeName;
        this.b = schemaType;
        this.setRawParent((f)nodeInfo);
        this.setRawSequenceNumber(n2);
        this.c = attributeCollectionImpl;
    }

    @Override
    public NodeName getNodeName() {
        return this.a;
    }

    public void setLocation(String string, int n2, int n3) {
        DocumentImpl documentImpl = this.getRawParent().getPhysicalRoot();
        documentImpl.a(this.getRawSequenceNumber(), n2, n3);
        documentImpl.a(this.getRawSequenceNumber(), string);
    }

    @Override
    public void setSystemId(String string) {
        this.getPhysicalRoot().a(this.getRawSequenceNumber(), string);
    }

    @Override
    public NodeInfo getRoot() {
        f f2 = this.getRawParent();
        if (f2 == null || f2 instanceof DocumentImpl && ((DocumentImpl)f2).isImaginary()) {
            return this;
        }
        return f2.getRoot();
    }

    @Override
    public final String getSystemId() {
        DocumentImpl documentImpl = this.getPhysicalRoot();
        if (documentImpl == null) {
            return null;
        }
        return documentImpl.a(this.getRawSequenceNumber());
    }

    @Override
    public String getBaseURI() {
        ElementImpl elementImpl = this;
        return Navigator.getBaseURI(elementImpl, nodeInfo -> this.getPhysicalRoot().isTopWithinEntity((ElementImpl)nodeInfo));
    }

    public AttributeCollection gsetAttributeCollection() {
        return this.c;
    }

    @Override
    public boolean isNilled() {
        return this.getPhysicalRoot().a(this);
    }

    @Override
    public void setTypeAnnotation(SchemaType schemaType) {
        this.b = schemaType;
    }

    public void setNilled() {
        this.getPhysicalRoot().addNilledElement(this);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.b;
    }

    @Override
    public int getLineNumber() {
        DocumentImpl documentImpl = this.getPhysicalRoot();
        if (documentImpl == null) {
            return -1;
        }
        return documentImpl.b(this.getRawSequenceNumber());
    }

    @Override
    public int getColumnNumber() {
        DocumentImpl documentImpl = this.getPhysicalRoot();
        if (documentImpl == null) {
            return -1;
        }
        return documentImpl.c(this.getRawSequenceNumber());
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        int n2 = this.getRawSequenceNumber();
        if (n2 >= 0) {
            ((NodeImpl)this.getPhysicalRoot()).generateId(fastStringBuffer);
            fastStringBuffer.append("e");
            fastStringBuffer.append(Integer.toString(n2));
            return;
        }
        this.getRawParent().generateId(fastStringBuffer);
        fastStringBuffer.append("f");
        fastStringBuffer.append(Integer.toString(this.getSiblingPosition()));
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        Object object = CopyOptions.includes(n2, 4) ? ((NodeImpl)this).getSchemaType() : Untyped.getInstance();
        CopyInformee copyInformee = (CopyInformee)receiver.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        if (copyInformee != null && (copyInformee = copyInformee.notifyElementNode(this)) instanceof Location) {
            location = (Location)((Object)copyInformee);
        }
        receiver.startElement(NameOfNode.makeName(this), (SchemaType)object, location, 0);
        int n3 = n2 & 0xFFFFFFFD;
        if ((n2 & 1) != 0) {
            NamespaceBinding namespaceBinding;
            NamespaceBinding[] namespaceBindingArray;
            object = namespaceBindingArray = ((NodeImpl)this).getDeclaredNamespaces(null);
            n2 = namespaceBindingArray.length;
            for (int i2 = 0; i2 < n2 && (namespaceBinding = object[i2]) != null; ++i2) {
                receiver.namespace(namespaceBinding, 0);
            }
        } else if ((n2 & 2) != 0) {
            NamespaceIterator.sendNamespaces(this, receiver);
            n3 |= 1;
        }
        if (this.c != null) {
            for (n2 = 0; n2 < this.c.getLength(); ++n2) {
                object = this.c.getNodeName(n2);
                if (object == null) continue;
                receiver.attribute((NodeName)object, BuiltInAtomicType.UNTYPED_ATOMIC, this.c.getValue(n2), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
        }
        receiver.startContent();
        for (NodeImpl nodeImpl = ((NodeImpl)this).getFirstChild(); nodeImpl != null; nodeImpl = nodeImpl.getNextSibling()) {
            nodeImpl.copy(receiver, n3, location);
        }
        receiver.endElement();
    }

    @Override
    public void delete() {
        DocumentImpl documentImpl = this.getPhysicalRoot();
        super.delete();
        if (documentImpl != null) {
            AxisIterator axisIterator = this.iterateAxis((byte)5, NodeKindTest.ELEMENT);
            while (true) {
                ElementImpl elementImpl = (ElementImpl)axisIterator.next();
                int n2 = this.c.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!this.c.isId(i2)) continue;
                    documentImpl.deregisterID(this.c.getValue(i2));
                }
                if (elementImpl == null) break;
                documentImpl.deIndex(elementImpl);
            }
        }
    }

    @Override
    public void rename(NodeName nodeName) {
        String string = nodeName.getPrefix();
        String string2 = nodeName.getURI();
        NamespaceBinding namespaceBinding = new NamespaceBinding(string, string2);
        if ((string = this.getURIForPrefix(string, true)) == null) {
            string = "";
        }
        if (!string.equals(string2)) {
            if (string.isEmpty()) {
                ((NodeImpl)this).addNamespace(namespaceBinding, false);
            } else {
                throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
            }
        }
        this.a = nodeName;
    }

    @Override
    public void addNamespace(NamespaceBinding namespaceBinding, boolean bl2) {
        block5: {
            int n2;
            if (namespaceBinding.getURI().isEmpty()) {
                throw new IllegalArgumentException("Cannot add a namespace undeclaration");
            }
            boolean bl3 = true;
            NamespaceBinding namespaceBinding2 = namespaceBinding;
            ElementImpl elementImpl = this;
            if (elementImpl.d == null) {
                elementImpl.d = new NamespaceBinding[]{namespaceBinding2};
                return;
            }
            NamespaceBinding[] namespaceBindingArray = elementImpl.d;
            for (n2 = 0; n2 < namespaceBindingArray.length; ++n2) {
                if (!namespaceBindingArray[n2].equals(namespaceBinding2)) {
                    if (!namespaceBindingArray[n2].getPrefix().equals(namespaceBinding2.getPrefix())) continue;
                    if (namespaceBindingArray[n2].getURI().isEmpty()) {
                        namespaceBindingArray[n2] = namespaceBinding2;
                        return;
                    }
                    throw new IllegalArgumentException("New namespace conflicts with existing namespace binding");
                }
                break block5;
            }
            n2 = namespaceBindingArray.length;
            NamespaceBinding[] namespaceBindingArray2 = new NamespaceBinding[n2 + 1];
            System.arraycopy(namespaceBindingArray, 0, namespaceBindingArray2, 0, n2);
            namespaceBindingArray2[n2] = namespaceBinding2;
            elementImpl.d = namespaceBindingArray2;
        }
    }

    @Override
    public void replaceStringValue(CharSequence object) {
        if (object.length() == 0) {
            this.setChildren(null);
            return;
        }
        object = new TextImpl(object.toString());
        ((NodeImpl)object).setRawParent(this);
        this.setChildren(object);
    }

    @Override
    public void addAttribute(NodeName object, SimpleType object2, CharSequence charSequence, int n2) {
        AttributeCollectionImpl attributeCollectionImpl;
        int n3;
        if (this.c == null || this.c.getLength() == 0) {
            this.c = new AttributeCollectionImpl(this.getConfiguration());
        }
        if ((n3 = (attributeCollectionImpl = (AttributeCollectionImpl)this.c).findByNodeName((NodeName)object)) != -1) {
            throw new IllegalStateException("Cannot add an attribute to an element as it already has an attribute with the specified name");
        }
        attributeCollectionImpl.addAttribute((NodeName)object, (SimpleType)object2, charSequence.toString(), ExplicitLocation.UNKNOWN_LOCATION, 0);
        if (!object.hasURI("")) {
            object = object.getNamespaceBinding();
            object2 = ((NamespaceBinding)object).getPrefix();
            if ((object2 = this.getURIForPrefix((String)object2, false)) == null) {
                ((NodeImpl)this).addNamespace((NamespaceBinding)object, false);
            } else if (!((String)object2).equals(((NamespaceBinding)object).getURI())) {
                throw new IllegalStateException("Namespace binding of new name conflicts with existing namespace binding");
            }
        }
        if ((n2 & 0x800) != 0 && (object = this.getPhysicalRoot()) != null) {
            ((DocumentImpl)object).registerID(this, Whitespace.trim(charSequence));
        }
    }

    @Override
    public void removeAttribute(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AttributeImpl)) {
            return;
        }
        AttributeCollectionImpl attributeCollectionImpl = (AttributeCollectionImpl)this.getAttributeList();
        int n2 = ((AttributeImpl)nodeInfo).getSiblingPosition();
        if (n2 >= 0 && attributeCollectionImpl.isId(n2)) {
            DocumentImpl documentImpl = this.getPhysicalRoot();
            documentImpl.deregisterID(attributeCollectionImpl.getValue(n2));
        }
        attributeCollectionImpl.removeAttribute(n2);
        ((AttributeImpl)nodeInfo).setRawParent(null);
    }

    @Override
    public void removeTypeAnnotation() {
        if (((NodeImpl)this).getSchemaType() != Untyped.getInstance()) {
            this.b = AnyType.getInstance();
            this.getRawParent().removeTypeAnnotation();
        }
    }

    public void setNamespaceDeclarations(NamespaceBinding[] namespaceBindingArray, int n2) {
        this.d = new NamespaceBinding[n2];
        System.arraycopy(namespaceBindingArray, 0, this.d, 0, n2);
    }

    @Override
    public String getURIForPrefix(String string, boolean bl2) {
        Object object;
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.isEmpty() && !bl2) {
            return "";
        }
        if (this.d != null) {
            object = this.d;
            int n2 = this.d.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                NamespaceBinding namespaceBinding = object[i2];
                if (!namespaceBinding.getPrefix().equals(string)) continue;
                String string2 = namespaceBinding.getURI();
                if (string2.isEmpty() && !string.isEmpty()) {
                    return null;
                }
                return string2;
            }
        }
        if ((object = this.getRawParent()).getNodeKind() == 9) {
            if (string.isEmpty()) {
                return "";
            }
            return null;
        }
        return ((ElementImpl)object).getURIForPrefix(string, bl2);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        return new Iterator<String>(this){
            private NamePool a = null;
            private Iterator<NamespaceBinding> b = NamespaceIterator.iterateNamespaces(this.c);
            private /* synthetic */ ElementImpl c;
            {
                this.c = elementImpl;
            }

            @Override
            public final boolean hasNext() {
                return this.a == null || this.b.hasNext();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public final /* synthetic */ Object next() {
                1 var1_1 = this;
                if (var1_1.a == null) {
                    var1_1.a = var1_1.c.getNamePool();
                    return "xml";
                }
                return var1_1.b.next().getPrefix();
            }
        };
    }

    public boolean isInScopeNamespace(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        NamespaceBinding[] namespaceBindingArray = this.d;
        int n2 = this.d.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NamespaceBinding namespaceBinding = namespaceBindingArray[i2];
            if (!namespaceBinding.getURI().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        if (this.d == null) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        return this.d;
    }

    protected void fixupInsertedNamespaces(boolean bl2) {
        Object object;
        int n2;
        if (this.getRawParent().getNodeKind() == 9) {
            return;
        }
        HashSet<NamespaceBinding> hashSet = new HashSet<NamespaceBinding>();
        if (this.d != null) {
            hashSet.addAll(Arrays.asList(this.d));
        }
        InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(this.getRawParent());
        if (this.getURI().isEmpty() && !inscopeNamespaceResolver.getURIForPrefix("", true).isEmpty()) {
            hashSet.add(NamespaceBinding.DEFAULT_UNDECLARATION);
        }
        if (!bl2) {
            Iterator<String> iterator = inscopeNamespaceResolver.iteratePrefixes();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string.equals("xml")) continue;
                n2 = 0;
                if (this.d != null) {
                    NamespaceBinding[] namespaceBindingArray4 = this.d;
                    int n3 = this.d.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        object = namespaceBindingArray4[i2];
                        if (!((NamespaceBinding)object).getPrefix().equals(string)) continue;
                        n2 = 1;
                        break;
                    }
                }
                if (n2 != 0) continue;
                hashSet.add(new NamespaceBinding(string, ""));
            }
        }
        if (this.d != null) {
            NamespaceBinding[] namespaceBindingArray2 = this.d;
            int n4 = this.d.length;
            for (n2 = 0; n2 < n4; ++n2) {
                NamespaceBinding namespaceBinding = namespaceBindingArray2[n2];
                String string = namespaceBinding.getPrefix();
                String string2 = namespaceBinding.getURI();
                object = inscopeNamespaceResolver.getURIForPrefix(string, true);
                if (object == null || !((String)object).equals(string2)) continue;
                hashSet.remove(namespaceBinding);
            }
        }
        NamespaceBinding[] namespaceBindingArray3 = new NamespaceBinding[hashSet.size()];
        int n5 = 0;
        for (NamespaceBinding namespaceBinding : hashSet) {
            namespaceBindingArray3[n5++] = namespaceBinding;
        }
        this.d = namespaceBindingArray3;
    }

    public AttributeCollection getAttributeList() {
        if (this.c == null) {
            return AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
        }
        return this.c;
    }

    public NamespaceBinding[] getNamespaceList() {
        return this.d;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        if (this.c == null) {
            return null;
        }
        return this.c.getValue(string, string2);
    }

    @Override
    public boolean isId() {
        try {
            SchemaType schemaType = ((NodeImpl)this).getSchemaType();
            return schemaType.getFingerprint() == 560 || schemaType.isIdType() && NameChecker.isValidNCName(((NodeImpl)this).getStringValueCS());
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
    }

    @Override
    public boolean isIdref() {
        return ElementImpl.a(this);
    }

    static boolean a(NodeImpl object) {
        Object object22 = ((NodeImpl)object).getSchemaType();
        try {
            if (object22.isIdRefType()) {
                if (object22 == BuiltInAtomicType.IDREF || object22 == BuiltInListType.IDREFS) {
                    return true;
                }
                try {
                    for (Object object22 : ((NodeImpl)object).atomize()) {
                        if (!((AtomicValue)object22).getItemType().isIdRefType()) continue;
                        return true;
                    }
                }
                catch (XPathException xPathException) {}
            }
        }
        catch (MissingComponentException missingComponentException) {
            return false;
        }
        return false;
    }
}

