/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.a;
import net.sf.saxon.tree.linked.b;
import net.sf.saxon.tree.linked.d;
import net.sf.saxon.tree.linked.e;
import net.sf.saxon.tree.linked.f;
import net.sf.saxon.tree.linked.g;
import net.sf.saxon.tree.linked.h;
import net.sf.saxon.tree.linked.i;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.SteppingNavigator;
import net.sf.saxon.tree.util.SteppingNode;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class NodeImpl
implements SourceLocator,
MutableNodeInfo,
SteppingNode<NodeImpl>,
SiblingCountingNode {
    private f a;
    private int b;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    @Override
    public NodeImpl head() {
        return this;
    }

    @Override
    public UnfailingIterator<NodeInfo> iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.getPhysicalRoot();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    @Override
    public SchemaType getSchemaType() {
        return Untyped.getInstance();
    }

    @Override
    public int getColumnNumber() {
        if (this.a == null) {
            return -1;
        }
        return this.a.getColumnNumber();
    }

    @Override
    public final int getSiblingPosition() {
        return this.b;
    }

    protected final void setSiblingPosition(int n2) {
        this.b = n2;
    }

    @Override
    public AtomicSequence atomize() {
        SchemaType schemaType = this.getSchemaType();
        if (schemaType == Untyped.getInstance() || schemaType == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return new UntypedAtomicValue(this.getStringValueCS());
        }
        return schemaType.atomize(this);
    }

    @Override
    public void setSystemId(String string) {
        NodeImpl nodeImpl = this.getParent();
        if (nodeImpl != null) {
            nodeImpl.setSystemId(string);
        }
    }

    public boolean equals(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public NodeName getNodeName() {
        return null;
    }

    @Override
    public boolean hasFingerprint() {
        return true;
    }

    @Override
    public int getFingerprint() {
        NodeName nodeName = this.getNodeName();
        if (nodeName == null) {
            return -1;
        }
        return nodeName.obtainFingerprint(this.getConfiguration().getNamePool());
    }

    @Override
    public void generateId(FastStringBuffer fastStringBuffer) {
        long l2 = this.getSequenceNumber();
        if (l2 == -1L) {
            ((NodeImpl)this.getPhysicalRoot()).generateId(fastStringBuffer);
            fastStringBuffer.append(NODE_LETTER[this.getNodeKind()]);
            fastStringBuffer.append(Long.toString(l2) + "h" + this.hashCode());
            return;
        }
        this.a.generateId(fastStringBuffer);
        fastStringBuffer.append(NODE_LETTER[this.getNodeKind()]);
        fastStringBuffer.append(Integer.toString(this.b));
    }

    @Override
    public String getSystemId() {
        return this.a.getSystemId();
    }

    @Override
    public String getBaseURI() {
        return this.a.getBaseURI();
    }

    protected long getSequenceNumber() {
        NodeImpl nodeImpl = this;
        int n2 = 0;
        while (true) {
            if (nodeImpl instanceof f) {
                long l2 = nodeImpl.getSequenceNumber();
                if (l2 == -1L) {
                    return l2;
                }
                return l2 + 65536L + (long)n2;
            }
            assert (nodeImpl != null);
            nodeImpl = nodeImpl.getPreviousInDocument();
            ++n2;
        }
    }

    @Override
    public final int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof NamespaceNode) {
            return 0 - nodeInfo.compareOrder(this);
        }
        long l2 = this.getSequenceNumber();
        long l3 = ((NodeImpl)nodeInfo).getSequenceNumber();
        if (l2 == -1L || l3 == -1L) {
            return Navigator.compareOrder(this, (NodeImpl)nodeInfo);
        }
        return Long.compare(l2, l3);
    }

    @Override
    public Configuration getConfiguration() {
        return ((NodeImpl)this.getPhysicalRoot()).getConfiguration();
    }

    public NamePool getNamePool() {
        return ((NodeImpl)this.getPhysicalRoot()).getNamePool();
    }

    @Override
    public String getPrefix() {
        NodeName nodeName = this.getNodeName();
        if (nodeName == null) {
            return "";
        }
        return nodeName.getPrefix();
    }

    @Override
    public String getURI() {
        NodeName nodeName = this.getNodeName();
        if (nodeName == null) {
            return "";
        }
        return nodeName.getURI();
    }

    @Override
    public String getDisplayName() {
        NodeName nodeName = this.getNodeName();
        if (nodeName == null) {
            return "";
        }
        return nodeName.getDisplayName();
    }

    @Override
    public String getLocalPart() {
        NodeName nodeName = this.getNodeName();
        if (nodeName == null) {
            return "";
        }
        return nodeName.getLocalPart();
    }

    @Override
    public int getLineNumber() {
        return this.a.getLineNumber();
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public final NodeImpl getParent() {
        if (this.a instanceof DocumentImpl && ((DocumentImpl)this.a).isImaginary()) {
            return null;
        }
        return this.a;
    }

    protected final f getRawParent() {
        return this.a;
    }

    protected final void setRawParent(f f2) {
        this.a = f2;
    }

    @Override
    public NodeImpl getPreviousSibling() {
        if (this.a == null) {
            return null;
        }
        return this.a.getNthChild(this.b - 1);
    }

    @Override
    public NodeImpl getNextSibling() {
        if (this.a == null) {
            return null;
        }
        return this.a.getNthChild(this.b + 1);
    }

    @Override
    public NodeImpl getFirstChild() {
        return null;
    }

    public NodeInfo getLastChild() {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        if (by == 3) {
            if (this instanceof f) {
                return ((f)this).iterateChildren(null);
            }
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return new a(this, nodeTest, false);
            }
            case 1: {
                return new a(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new b(this, nodeTest);
            }
            case 3: {
                if (this instanceof f) {
                    return ((f)this).iterateChildren(nodeTest);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 4: {
                if (this.getNodeKind() == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((DocumentImpl)this).d(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new SteppingNavigator.DescendantAxisIterator<NodeImpl>(this, false, nodeTest);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 5: {
                return new SteppingNavigator.DescendantAxisIterator<NodeImpl>(this, true, nodeTest);
            }
            case 6: {
                return new d(this, nodeTest);
            }
            case 7: {
                return new e(this, nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                NodeImpl nodeImpl = this.getParent();
                if (nodeImpl == null) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return Navigator.filteredSingleton(nodeImpl, nodeTest);
            }
            case 10: {
                return new g(this, nodeTest);
            }
            case 11: {
                return new i(this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new h(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        NodeImpl nodeImpl = this.getParent();
        if (nodeImpl == null) {
            return this;
        }
        return nodeImpl.getRoot();
    }

    public DocumentImpl getPhysicalRoot() {
        f f2;
        for (f2 = this.a; f2 != null && !(f2 instanceof DocumentImpl); f2 = f2.getRawParent()) {
        }
        return (DocumentImpl)f2;
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        NodeImpl nodeImpl2 = this.getFirstChild();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        if (this == nodeImpl) {
            return null;
        }
        nodeImpl2 = this.getNextSibling();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        NodeImpl nodeImpl3 = this;
        do {
            if ((nodeImpl3 = nodeImpl3.getParent()) == null) {
                return null;
            }
            if (nodeImpl3 != nodeImpl) continue;
            return null;
        } while ((nodeImpl2 = nodeImpl3.getNextSibling()) == null);
        return nodeImpl2;
    }

    @Override
    public NodeImpl getSuccessorElement(NodeImpl nodeImpl, String string, String string2) {
        NodeImpl nodeImpl2;
        for (nodeImpl2 = this.getNextInDocument(nodeImpl); nodeImpl2 != null && (nodeImpl2.getNodeKind() != 1 || string != null && !string.equals(nodeImpl2.getURI()) || string2 != null && !string2.equals(nodeImpl2.getLocalPart())); nodeImpl2 = nodeImpl2.getNextInDocument(nodeImpl)) {
        }
        return nodeImpl2;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl nodeImpl = this.getPreviousSibling();
        if (nodeImpl != null) {
            return nodeImpl.a();
        }
        return this.getParent();
    }

    private NodeImpl a() {
        NodeImpl nodeImpl;
        while ((nodeImpl = (NodeImpl)nodeImpl2.getLastChild()) != null) {
            NodeImpl nodeImpl2 = nodeImpl;
        }
        return nodeImpl2;
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public void setTypeAnnotation(SchemaType schemaType) {
    }

    @Override
    public void delete() {
        if (this.a != null) {
            this.a.removeChild(this);
            DocumentImpl documentImpl = new DocumentImpl();
            documentImpl.setConfiguration(this.getConfiguration());
            documentImpl.setImaginary(true);
            this.a = documentImpl;
        }
        this.b = -1;
    }

    @Override
    public boolean isDeleted() {
        return this.b == -1 || this.a != null && this.a.isDeleted();
    }

    @Override
    public void removeAttribute(NodeInfo nodeInfo) {
    }

    @Override
    public void addAttribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2) {
    }

    @Override
    public void rename(NodeName nodeName) {
    }

    @Override
    public void addNamespace(NamespaceBinding namespaceBinding, boolean bl2) {
    }

    @Override
    public void replace(NodeInfo[] nodeInfoArray, boolean bl2) {
        if (this.isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.getParent() == null) {
            throw new IllegalStateException("Cannot replace a parentless node");
        }
        assert (this.a != null);
        this.a.replaceChildrenAt(nodeInfoArray, this.b, bl2);
        this.a = null;
        this.b = -1;
    }

    @Override
    public void insertChildren(NodeInfo[] nodeInfoArray, boolean bl2, boolean bl3) {
    }

    @Override
    public void insertSiblings(NodeInfo[] nodeInfoArray, boolean bl2, boolean bl3) {
        if (this.a == null) {
            throw new IllegalStateException("Cannot add siblings if there is no parent");
        }
        this.a.insertChildrenAt(nodeInfoArray, bl2 ? this.b : this.b + 1, bl3);
    }

    @Override
    public void removeTypeAnnotation() {
    }

    @Override
    public Builder newBuilder() {
        return ((NodeImpl)this.getPhysicalRoot()).newBuilder();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return true;
    }
}

