/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.io.Writer;
import net.sf.saxon.tree.util.FastStringBuffer;

public class CompressedWhitespace
implements CharSequence {
    private static char[] a = new char[]{'\t', '\n', '\r', ' '};
    private static int[] b = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, -1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3};
    private long c;

    public CompressedWhitespace(long l2) {
        this.c = l2;
    }

    public static CharSequence compress(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        if (n3 == 0) {
            return charSequence;
        }
        int n4 = 1;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = charSequence.charAt(n2);
            if (c2 <= ' ' && b[c2] >= 0) {
                if (n2 == n3 - 1 || c2 != charSequence.charAt(n2 + 1) || n4 == 63) {
                    n4 = 1;
                    if (++n5 <= 8) continue;
                    return charSequence;
                }
                ++n4;
                continue;
            }
            return charSequence;
        }
        n2 = 0;
        n4 = 1;
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < n3; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (i2 == n3 - 1 || c3 != charSequence.charAt(i2 + 1) || n4 == 63) {
                nArray[n2++] = b[c3] << 6 | n4;
                n4 = 1;
                continue;
            }
            ++n4;
        }
        long l2 = 0L;
        for (int i3 = 0; i3 < n5; ++i3) {
            l2 = l2 << 8 | (long)nArray[i3];
        }
        return new CompressedWhitespace(l2 <<= 8 * (8 - n5));
    }

    public FastStringBuffer uncompress(FastStringBuffer fastStringBuffer) {
        if (fastStringBuffer == null) {
            fastStringBuffer = new FastStringBuffer(this.length());
        }
        CompressedWhitespace.uncompress(this.c, fastStringBuffer);
        return fastStringBuffer;
    }

    public static void uncompress(long l2, FastStringBuffer fastStringBuffer) {
        int n2;
        for (int i2 = 56; i2 >= 0 && (n2 = (int)((int)(l2 >>> i2 & 0xFFL))) != 0; i2 -= 8) {
            char c2 = a[n2 >>> 6 & 3];
            fastStringBuffer.ensureCapacity(n2 &= 0x3F);
            for (int i3 = 0; i3 < n2; ++i3) {
                fastStringBuffer.append(c2);
            }
        }
    }

    public long getCompressedValue() {
        return this.c;
    }

    @Override
    public int length() {
        int n2;
        int n3 = 0;
        long l2 = this.c;
        for (int i2 = 56; i2 >= 0 && (n2 = (int)(l2 >>> i2 & 0x3FL)) != 0; i2 -= 8) {
            n3 += n2;
        }
        return n3;
    }

    @Override
    public char charAt(int n2) {
        byte by;
        int n3 = 0;
        long l2 = this.c;
        for (int i2 = 56; i2 >= 0 && (by = (byte)(l2 >>> i2 & 0xFFL)) != 0; i2 -= 8) {
            if ((n3 += by & 0x3F) <= n2) continue;
            return a[by >>> 6 & 3];
        }
        throw new IndexOutOfBoundsException("" + n2);
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        return this.uncompress(null).subSequence(n2, n3);
    }

    public boolean equals(Object object) {
        if (object instanceof CompressedWhitespace) {
            return this.c == ((CompressedWhitespace)object).c;
        }
        return this.uncompress(null).equals(object);
    }

    public int hashCode() {
        return this.uncompress(null).hashCode();
    }

    @Override
    public String toString() {
        return this.uncompress(null).toString();
    }

    public void write(Writer writer) {
        int n2;
        long l2 = this.c;
        for (int i2 = 56; i2 >= 0 && (n2 = (int)((int)(l2 >>> i2 & 0xFFL))) != 0; i2 -= 8) {
            char c2 = a[n2 >>> 6 & 3];
            n2 &= 0x3F;
            for (int i3 = 0; i3 < n2; ++i3) {
                writer.write(c2);
            }
        }
    }

    public void writeEscape(boolean[] blArray, Writer writer) {
        int n2;
        long l2 = this.c;
        for (int i2 = 56; i2 >= 0 && (n2 = (int)((int)(l2 >>> i2 & 0xFFL))) != 0; i2 -= 8) {
            int n3 = a[n2 >>> 6 & 3];
            n2 &= 0x3F;
            if (blArray[n3]) {
                String string = "";
                if (n3 == 10) {
                    string = "&#xA;";
                } else if (n3 == 13) {
                    string = "&#xD;";
                } else if (n3 == 9) {
                    string = "&#x9;";
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    writer.write(string);
                }
                continue;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                writer.write(n3);
            }
        }
    }
}

