/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.Optional;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualCopy;

public class GraftedElement
extends TinyElementImpl {
    private NodeInfo a;
    private VirtualCopy b;
    private Optional<Boolean> c = Optional.empty();

    public GraftedElement(TinyTree tinyTree, int n2, NodeInfo nodeInfo, boolean bl2) {
        super(tinyTree, n2);
        this.a = nodeInfo;
        this.b = VirtualCopy.makeVirtualCopy(nodeInfo, this);
        this.b.setDropNamespaces(!bl2);
    }

    public NodeInfo getExternalNode() {
        return this.a;
    }

    @Override
    public boolean hasChildNodes() {
        return this.b.hasChildNodes();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.a.getStringValueCS();
    }

    @Override
    public String getStringValue() {
        return this.a.getStringValue();
    }

    @Override
    public AtomicSequence atomize() {
        return this.a.atomize();
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        this.b.copy(receiver, n2, location);
    }

    @Override
    public AxisIterator iterateAxis(byte by) {
        return ((TinyNodeImpl)this).iterateAxis(by, AnyNodeTest.getInstance());
    }

    @Override
    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return super.iterateAxis(by, nodeTest);
            }
            case 1: {
                return super.iterateAxis(by, nodeTest);
            }
            case 2: {
                return this.b.iterateAxis(by, nodeTest);
            }
            case 3: {
                return this.b.iterateAxis(by, nodeTest);
            }
            case 4: {
                return this.b.iterateAxis(by, nodeTest);
            }
            case 5: {
                return this.b.iterateAxis(by, nodeTest);
            }
            case 6: {
                return super.iterateAxis(by, nodeTest);
            }
            case 7: {
                return super.iterateAxis(by, nodeTest);
            }
            case 8: {
                return this.b.iterateAxis(by, nodeTest);
            }
            case 9: {
                return super.iterateAxis(by, nodeTest);
            }
            case 10: {
                return super.iterateAxis(by, nodeTest);
            }
            case 11: {
                return super.iterateAxis(by, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return super.iterateAxis(by, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    @Override
    public String getAttributeValue(int n2) {
        NodeInfo nodeInfo = this.b.getOriginalNode();
        if (nodeInfo instanceof TinyElementImpl) {
            return ((TinyElementImpl)nodeInfo).getAttributeValue(n2);
        }
        StructuredQName structuredQName = this.getNamePool().getStructuredQName(n2);
        return nodeInfo.getAttributeValue(structuredQName.getURI(), structuredQName.getLocalPart());
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.a.getAttributeValue(string, string2);
    }

    public boolean hasDefaultNamespace() {
        if (!this.c.isPresent()) {
            this.c = Optional.of(!new InscopeNamespaceResolver(this.getParent()).getURIForPrefix("", true).isEmpty());
        }
        return this.c.get();
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return this.b.getDeclaredNamespaces(namespaceBindingArray);
    }
}

