/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public final class TinyAttributeImpl
extends TinyNodeImpl {
    public TinyAttributeImpl(TinyTree tinyTree, int n2) {
        this.tree = tinyTree;
        this.nodeNr = n2;
    }

    @Override
    public final void setSystemId(String string) {
    }

    @Override
    public final String getSystemId() {
        TinyNodeImpl tinyNodeImpl = ((TinyNodeImpl)this).getParent();
        if (tinyNodeImpl == null) {
            return null;
        }
        return ((TinyNodeImpl)this).getParent().getSystemId();
    }

    @Override
    public final TinyNodeImpl getParent() {
        return this.tree.getNode(this.tree.attParent[this.nodeNr]);
    }

    @Override
    public final NodeInfo getRoot() {
        TinyNodeImpl tinyNodeImpl = ((TinyNodeImpl)this).getParent();
        if (tinyNodeImpl == null) {
            return this;
        }
        return tinyNodeImpl.getRoot();
    }

    @Override
    protected final long getSequenceNumber() {
        return ((TinyNodeImpl)this).getParent().getSequenceNumber() + 32768L + (long)(this.nodeNr - this.tree.alpha[this.tree.attParent[this.nodeNr]]);
    }

    @Override
    public final int getNodeKind() {
        return 2;
    }

    @Override
    public final CharSequence getStringValueCS() {
        return this.tree.attValue[this.nodeNr];
    }

    @Override
    public final String getStringValue() {
        return this.tree.attValue[this.nodeNr].toString();
    }

    @Override
    public final int getFingerprint() {
        return this.tree.attCode[this.nodeNr] & 0xFFFFF;
    }

    public final int getNameCode() {
        return this.tree.attCode[this.nodeNr];
    }

    @Override
    public final String getPrefix() {
        int n2 = this.tree.attCode[this.nodeNr];
        if (!NamePool.isPrefixed(n2)) {
            return "";
        }
        return this.tree.prefixPool.getPrefix(n2 >> 20);
    }

    @Override
    public final String getDisplayName() {
        int n2 = this.tree.attCode[this.nodeNr];
        if (n2 < 0) {
            return "";
        }
        if (NamePool.isPrefixed(n2)) {
            return ((TinyNodeImpl)this).getPrefix() + ":" + ((TinyNodeImpl)this).getLocalPart();
        }
        return ((TinyNodeImpl)this).getLocalPart();
    }

    @Override
    public final String getLocalPart() {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public final String getURI() {
        int n2 = this.tree.attCode[this.nodeNr];
        if (!NamePool.isPrefixed(n2)) {
            return "";
        }
        return this.tree.getNamePool().getURI(n2);
    }

    @Override
    public final SchemaType getSchemaType() {
        if (this.tree.attType == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.tree.c(this.nodeNr);
    }

    @Override
    public final AtomicSequence atomize() {
        TinyAttributeImpl tinyAttributeImpl = this;
        return this.tree.getTypedValueOfAttribute(tinyAttributeImpl, tinyAttributeImpl.nodeNr);
    }

    @Override
    public final void generateId(FastStringBuffer fastStringBuffer) {
        ((TinyNodeImpl)this).getParent().generateId(fastStringBuffer);
        fastStringBuffer.append("a");
        fastStringBuffer.append(Integer.toString(this.tree.attCode[this.nodeNr]));
    }

    @Override
    public final void copy(Receiver receiver, int n2, Location location) {
        BuiltInAtomicType builtInAtomicType = CopyOptions.includes(n2, 4) ? (SimpleType)((TinyNodeImpl)this).getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
        receiver.attribute(NameOfNode.makeName(this), builtInAtomicType, this.getStringValue(), location, 0);
    }

    @Override
    public final int getLineNumber() {
        return ((TinyNodeImpl)this).getParent().getLineNumber();
    }

    @Override
    public final int getColumnNumber() {
        return ((TinyNodeImpl)this).getParent().getColumnNumber();
    }

    @Override
    public final boolean isId() {
        return this.tree.isIdAttribute(this.nodeNr);
    }

    @Override
    public final boolean isIdref() {
        return this.tree.isIdrefAttribute(this.nodeNr);
    }

    public final boolean isDefaultedAttribute() {
        return this.tree.isDefaultedAttribute(this.nodeNr);
    }

    @Override
    public final int hashCode() {
        return (int)(this.tree.getDocumentNumber() & 0x3FFL) << 20 ^ this.nodeNr ^ 0xE0000;
    }
}

