/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.Arrays;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilderMonitor;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TinyBuilder
extends Builder {
    public static final int PARENT_POINTER_INTERVAL = 10;
    private TinyTree a;
    private int b = 0;
    private int c = 0;
    private boolean d = false;
    private Statistics e;
    private boolean f = false;
    private int g = 0;
    private int[] h = new int[100];
    private int[] i = new int[100];
    private boolean j = false;

    public TinyBuilder(PipelineConfiguration object) {
        super((PipelineConfiguration)object);
        object = ((PipelineConfiguration)object).getConfiguration();
        this.e = ((Configuration)object).getTreeStatistics().TEMPORARY_TREE_STATISTICS;
        this.f = ((Configuration)object).isExpandAttributeDefaults() && ((Configuration)object).getBooleanProperty(Feature.MARK_DEFAULTED_ATTRIBUTES);
    }

    public void setStatistics(Statistics statistics) {
        this.e = statistics;
    }

    public TinyTree getTree() {
        return this.a;
    }

    public int getCurrentDepth() {
        return this.b;
    }

    @Override
    public void open() {
        if (this.started) {
            return;
        }
        if (this.a == null) {
            this.a = new TinyTree(this.config, this.e);
            this.b = 0;
            if (this.lineNumbering) {
                this.a.setLineNumbering();
            }
        }
        super.open();
    }

    @Override
    public void startDocument(int n2) {
        int n3;
        if (this.started && !this.d || this.b > 0) {
            return;
        }
        this.started = true;
        this.d = false;
        TinyTree tinyTree = this.a;
        assert (tinyTree != null);
        this.currentRoot = new TinyDocumentImpl(tinyTree);
        Source source = (TinyDocumentImpl)this.currentRoot;
        ((TinyNodeImpl)source).setSystemId(this.getSystemId());
        ((TinyDocumentImpl)source).setBaseURI(this.getBaseURI());
        this.b = 0;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentRoot;
        source = tinyTree;
        ((GenericTreeInfo)source).setRootNode(tinyDocumentImpl);
        this.h[0] = n3 = ((TinyTree)source).a((short)9, 0, 0, 0, -1);
        this.h[1] = -1;
        this.i[0] = 0;
        this.i[1] = 0;
        tinyTree.next[n3] = -1;
        ++this.b;
    }

    @Override
    public void endDocument() {
        this.a.a((short)11, 0, 0, 0, -1);
        --this.a.numberOfNodes;
        if (this.b > 1) {
            return;
        }
        if (this.d) {
            return;
        }
        this.d = true;
        this.h[this.b] = -1;
        --this.b;
    }

    @Override
    public void reset() {
        super.reset();
        this.a = null;
        this.b = 0;
        this.c = 0;
        this.d = false;
        this.e = this.config.getTreeStatistics().TEMPORARY_TREE_STATISTICS;
    }

    @Override
    public void close() {
        TinyTree tinyTree = this.a;
        if (tinyTree != null) {
            tinyTree.a((short)11, 0, 0, 0, -1);
            tinyTree.a(this.e);
        }
        super.close();
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        int n3;
        TinyTree tinyTree = this.a;
        assert (tinyTree != null);
        this.g = 0;
        if (this.i[this.b] > 10) {
            this.c = tinyTree.a((short)12, this.b, this.h[this.b - 1], 0, 0);
            n3 = this.h[this.b];
            if (n3 > 0) {
                tinyTree.next[n3] = this.c;
            }
            tinyTree.next[this.c] = this.h[this.b - 1];
            this.h[this.b] = this.c;
            this.i[this.b] = 0;
        }
        n3 = nodeName.obtainFingerprint(this.namePool);
        int n4 = this.a.prefixPool.obtainPrefixCode(nodeName.getPrefix());
        n4 = n4 << 20 | n3;
        this.c = tinyTree.a((short)1, this.b, -1, -1, n4);
        this.j = (n2 & 0x800) != 0;
        n4 = schemaType.getFingerprint();
        if (n4 != 630) {
            tinyTree.a(this.c, schemaType);
            if ((n2 & 0x10) != 0) {
                tinyTree.setNilled(this.c);
            }
            if (!this.j && schemaType.isIdType()) {
                this.j = true;
            }
        }
        if (this.b == 0) {
            this.h[0] = this.c;
            this.h[1] = -1;
            this.currentRoot = tinyTree.getNode(this.c);
        } else {
            n4 = this.h[this.b];
            if (n4 > 0) {
                tinyTree.next[n4] = this.c;
            }
            tinyTree.next[this.c] = this.h[this.b - 1];
            this.h[this.b] = this.c;
            int n5 = this.b;
            this.i[n5] = this.i[n5] + 1;
        }
        ++this.b;
        if (this.b == this.h.length) {
            this.h = Arrays.copyOf(this.h, this.b << 1);
            this.i = Arrays.copyOf(this.i, this.b << 1);
        }
        this.h[this.b] = -1;
        this.i[this.b] = 0;
        if (this.isUseEventLocation() && location.getSystemId() != null) {
            tinyTree.a(this.c, location.getSystemId());
        } else if (this.b == 1) {
            tinyTree.a(this.c, this.systemId);
        }
        if (this.lineNumbering) {
            tinyTree.a(this.c, location.getLineNumber(), location.getColumnNumber());
        }
        if (location instanceof ReceivingContentHandler.LocalLocator && ((ReceivingContentHandler.LocalLocator)location).levelInEntity == 0 && this.b > 0) {
            tinyTree.markTopWithinEntity(this.c);
        }
    }

    @Override
    public void namespace(NamespaceBindingSet object, int n2) {
        assert (this.a != null);
        object = object.iterator();
        while (object.hasNext()) {
            NamespaceBinding namespaceBinding = (NamespaceBinding)object.next();
            this.a.a(this.c, namespaceBinding);
        }
    }

    @Override
    public void attribute(NodeName object, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        int n3;
        int n4 = object.obtainFingerprint(this.namePool);
        int n5 = n3 = ((String)(object = object.getPrefix())).isEmpty() ? n4 : this.a.prefixPool.obtainPrefixCode((String)object) << 20 | n4;
        assert (this.a != null);
        assert (this.currentRoot != null);
        this.a.a(this.currentRoot, this.c, n3, simpleType, charSequence, n2);
        if (this.f && (n2 & 8) != 0) {
            this.a.markDefaultedAttribute(this.a.numberOfAttributes - 1);
        }
    }

    @Override
    public void startContent() {
        ++this.c;
        this.g = 1;
    }

    @Override
    public void endElement() {
        assert (this.a != null);
        boolean bl2 = this.g == 2;
        this.g = 0;
        this.h[this.b] = -1;
        this.i[this.b] = 0;
        --this.b;
        if (this.j) {
            this.a.indexIDElement(this.currentRoot, this.h[this.b]);
            this.j = false;
            return;
        }
        if (bl2 && this.a.nodeKind[this.c] == 3 && this.a.nodeKind[this.c - 1] == 1 && this.a.alpha[this.c - 1] == -1 && this.a.beta[this.c - 1] == -1) {
            this.a.nodeKind[this.c - 1] = 17;
            this.a.alpha[this.c - 1] = this.a.alpha[this.c];
            this.a.beta[this.c - 1] = this.a.beta[this.c];
            --this.c;
            --this.a.numberOfNodes;
            if (this.b == 0) {
                this.currentRoot = this.a.getNode(this.c);
            }
        }
    }

    public TinyNodeImpl getLastCompletedElement() {
        if (this.a == null) {
            return null;
        }
        return this.a.getNode(this.b >= 0 ? this.h[this.b] : 0);
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        if (charSequence instanceof CompressedWhitespace && (n2 & 0x400) != 0) {
            TinyTree tinyTree = this.a;
            assert (tinyTree != null);
            long l2 = ((CompressedWhitespace)charSequence).getCompressedValue();
            this.c = tinyTree.a((short)4, this.b, (int)(l2 >> 32), (int)l2, -1);
            int n3 = this.h[this.b];
            if (n3 > 0) {
                tinyTree.next[n3] = this.c;
            }
            tinyTree.next[this.c] = this.h[this.b - 1];
            this.h[this.b] = this.c;
            int n4 = this.b;
            this.i[n4] = this.i[n4] + 1;
            if (this.lineNumbering) {
                tinyTree.a(this.c, location.getLineNumber(), location.getColumnNumber());
            }
            return;
        }
        n2 = charSequence.length();
        if (n2 > 0) {
            this.c = this.makeTextNode(charSequence, n2);
            if (this.lineNumbering) {
                this.a.a(this.c, location.getLineNumber(), location.getColumnNumber());
            }
            this.g = this.g == 1 ? 2 : 0;
        }
    }

    protected int makeTextNode(CharSequence charSequence, int n2) {
        TinyTree tinyTree = this.a;
        assert (tinyTree != null);
        int n3 = tinyTree.getCharacterBuffer().length();
        tinyTree.a(charSequence);
        int n4 = tinyTree.numberOfNodes - 1;
        if (tinyTree.nodeKind[n4] == 3 && tinyTree.depth[n4] == this.b) {
            int n5 = n4;
            tinyTree.beta[n5] = tinyTree.beta[n5] + n2;
        } else {
            this.c = tinyTree.a((short)3, this.b, n3, n2, -1);
            n4 = this.h[this.b];
            if (n4 > 0) {
                tinyTree.next[n4] = this.c;
            }
            tinyTree.next[this.c] = this.h[this.b - 1];
            this.h[this.b] = this.c;
            int n6 = this.b;
            this.i[n6] = this.i[n6] + 1;
        }
        return this.c;
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        TinyTree tinyTree = this.a;
        assert (tinyTree != null);
        this.g = 0;
        if (tinyTree.commentBuffer == null) {
            tinyTree.commentBuffer = new FastStringBuffer(256);
        }
        int n3 = tinyTree.commentBuffer.length();
        tinyTree.commentBuffer.append(charSequence.toString());
        int n4 = this.namePool.allocateFingerprint("", string);
        this.c = tinyTree.a((short)7, this.b, n3, charSequence.length(), n4);
        n4 = this.h[this.b];
        if (n4 > 0) {
            tinyTree.next[n4] = this.c;
        }
        tinyTree.next[this.c] = this.h[this.b - 1];
        this.h[this.b] = this.c;
        int n5 = this.b;
        this.i[n5] = this.i[n5] + 1;
        tinyTree.a(this.c, location.getSystemId());
        if (this.lineNumbering) {
            tinyTree.a(this.c, location.getLineNumber(), location.getColumnNumber());
        }
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        TinyTree tinyTree = this.a;
        assert (tinyTree != null);
        this.g = 0;
        if (tinyTree.commentBuffer == null) {
            tinyTree.commentBuffer = new FastStringBuffer(256);
        }
        int n3 = tinyTree.commentBuffer.length();
        tinyTree.commentBuffer.append(charSequence.toString());
        this.c = tinyTree.a((short)8, this.b, n3, charSequence.length(), -1);
        int n4 = this.h[this.b];
        if (n4 > 0) {
            tinyTree.next[n4] = this.c;
        }
        tinyTree.next[this.c] = this.h[this.b - 1];
        this.h[this.b] = this.c;
        int n5 = this.b;
        this.i[n5] = this.i[n5] + 1;
        if (this.lineNumbering) {
            tinyTree.a(this.c, location.getLineNumber(), location.getColumnNumber());
        }
    }

    @Override
    public void setUnparsedEntity(String string, String string2, String string3) {
        if (((GenericTreeInfo)this.a).getUnparsedEntity(string) == null) {
            this.a.a(string, string2, string3);
        }
    }

    @Override
    public BuilderMonitor getBuilderMonitor() {
        return new TinyBuilderMonitor(this);
    }

    public boolean isPositionedAtElement() {
        return this.a.numberOfNodes > 0 && (this.a.nodeKind[this.a.numberOfNodes - 1] & 0xF) == 1;
    }

    public void bulkCopy(TinyElementImpl tinyElementImpl, boolean bl2) {
        TinyTree tinyTree = tinyElementImpl.tree;
        int n2 = tinyElementImpl.nodeNr;
        int n3 = this.a.numberOfNodes;
        this.a.bulkCopy(tinyTree, n2, this.h, this.b);
        n2 = this.h[this.b];
        if (n2 > 0) {
            this.a.next[n2] = n3;
        }
        this.a.next[n3] = this.h[this.b - 1];
        this.h[this.b] = n3;
        int n4 = this.b;
        this.i[n4] = this.i[n4] + 1;
    }

    public void graft(NodeInfo nodeInfo, boolean bl2) {
        int n2 = this.a.numberOfNodes;
        this.a.graft(nodeInfo, n2, this.b, bl2);
        int n3 = this.h[this.b];
        if (n3 > 0) {
            this.a.next[n3] = n2;
        }
        this.a.next[n2] = this.h[this.b - 1];
        this.h[this.b] = n2;
        int n4 = this.b;
        this.i[n4] = this.i[n4] + 1;
    }
}

