/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.Arrays;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.z.IntHashMap;

public class TinyBuilderCondensed
extends TinyBuilder {
    public IntHashMap<int[]> textValues = new IntHashMap(100);

    public TinyBuilderCondensed(PipelineConfiguration pipelineConfiguration) {
        super(pipelineConfiguration);
    }

    @Override
    public void endElement() {
        TinyTree tinyTree = this.getTree();
        super.endElement();
        int n2 = tinyTree.numberOfNodes - 1;
        boolean bl2 = tinyTree.depth[n2] == this.getCurrentDepth();
        if (bl2) {
            int n3;
            bl2 = tinyTree.nodeKind[n2] == 17;
            int n4 = n3 = tinyTree.nodeKind[n2] == 3 ? 1 : 0;
            if ((bl2 || n3 != 0) && tinyTree.beta[n2] <= 256) {
                CharSequence charSequence = TinyTextImpl.getStringValue(tinyTree, n2);
                n3 = charSequence.hashCode();
                int[] nArray = this.textValues.get(n3);
                if (nArray != null) {
                    int n5;
                    int n6 = nArray[0];
                    for (int i2 = 1; i2 < n6 && (n5 = nArray[i2]) != 0; ++i2) {
                        CharSequence charSequence2 = TinyTextImpl.getStringValue(tinyTree, n5);
                        CharSequence charSequence3 = charSequence;
                        if (!(charSequence3.getClass() == charSequence2.getClass() ? charSequence3.equals(charSequence2) : charSequence3.toString().equals(charSequence2.toString()))) continue;
                        int n7 = tinyTree.alpha[n2];
                        tinyTree.alpha[n2] = tinyTree.alpha[n5];
                        tinyTree.beta[n2] = tinyTree.beta[n5];
                        tinyTree.getCharacterBuffer().setLength(n7);
                        return;
                    }
                } else {
                    int[] nArray2 = new int[4];
                    nArray = nArray2;
                    nArray2[0] = 1;
                    this.textValues.put(n3, nArray);
                }
                if (nArray[0] + 1 > nArray.length) {
                    int[] nArray3 = Arrays.copyOf(nArray, nArray.length << 1);
                    this.textValues.put(n3, nArray3);
                    nArray = nArray3;
                }
                int[] nArray4 = nArray;
                int n8 = nArray4[0];
                nArray4[0] = n8 + 1;
                nArray[n8] = n2;
            }
        }
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        super.attribute(nodeName, simpleType, charSequence.toString().intern(), location, n2);
    }
}

