/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntHashMap;

public final class TinyDocumentImpl
extends TinyParentNodeImpl {
    private IntHashMap<List<NodeInfo>> a;
    private String b;

    public TinyDocumentImpl(TinyTree tinyTree) {
        this.tree = tinyTree;
        this.nodeNr = 0;
    }

    @Override
    public final TinyTree getTree() {
        return this.tree;
    }

    public final NodeInfo getRootNode() {
        return this;
    }

    @Override
    public final Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    @Override
    public final void setSystemId(String string) {
        this.tree.a(this.nodeNr, string);
    }

    @Override
    public final String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public final void setBaseURI(String string) {
        this.b = string;
    }

    @Override
    public final String getBaseURI() {
        if (this.b != null) {
            return this.b;
        }
        return ((TinyNodeImpl)this).getSystemId();
    }

    @Override
    public final int getLineNumber() {
        return 0;
    }

    public final boolean isTyped() {
        return this.tree.getTypeArray() != null;
    }

    @Override
    public final int getNodeKind() {
        return 9;
    }

    @Override
    public final TinyNodeImpl getParent() {
        return null;
    }

    @Override
    public final NodeInfo getRoot() {
        return this;
    }

    @Override
    public final void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append('d');
        fastStringBuffer.append(Long.toString(this.getTreeInfo().getDocumentNumber()));
    }

    @Override
    public final AtomicSequence atomize() {
        return new UntypedAtomicValue(((TinyNodeImpl)this).getStringValueCS());
    }

    final ListIterator.OfNodes a(int n2) {
        List<NodeInfo> list;
        if (this.a == null) {
            this.a = new IntHashMap(20);
        }
        if ((list = this.a.get(n2)) == null) {
            list = this.b(n2);
            this.a.put(n2, list);
        }
        return new ListIterator.OfNodes(list);
    }

    private List<NodeInfo> b(int n2) {
        int n3 = this.tree.getNumberOfNodes() / 20;
        if (n3 > 100) {
            n3 = 100;
        }
        if (n3 < 20) {
            n3 = 20;
        }
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>(n3);
        int n4 = this.nodeNr + 1;
        try {
            while (this.tree.depth[n4] != 0) {
                byte by = this.tree.nodeKind[n4];
                if ((by & 0xF) == 1 && (this.tree.nameCode[n4] & 0xFFFFF) == n2) {
                    arrayList.add(this.tree.getNode(n4));
                } else if (by == 33) {
                    NodeInfo nodeInfo;
                    AxisIterator axisIterator = ((TinyNodeImpl)this.tree.externalNodes.get(this.tree.alpha[n4])).iterateAxis((byte)4, new NameTest(1, n2, this.getNamePool()));
                    while ((nodeInfo = axisIterator.next()) != null) {
                        arrayList.add(nodeInfo);
                    }
                }
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return arrayList;
        }
        arrayList.trimToSize();
        return arrayList;
    }

    @Override
    public final SchemaType getSchemaType() {
        Object object = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        if ((object = object.next()) == null || object.getSchemaType() == Untyped.getInstance()) {
            return Untyped.getInstance();
        }
        return AnyType.getInstance();
    }

    @Override
    public final void copy(Receiver receiver, int n2, Location location) {
        receiver.startDocument(CopyOptions.getStartDocumentProperties(n2));
        if (this.tree.entityTable != null) {
            for (Map.Entry<String, String[]> entry : this.tree.entityTable.entrySet()) {
                String string = entry.getKey();
                String[] stringArray = entry.getValue();
                String string2 = stringArray[0];
                String object = stringArray[1];
                receiver.setUnparsedEntity(string, string2, object);
            }
        }
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> nodeInfo.copy(receiver, n2, location));
        receiver.endDocument();
    }

    public final void showSize() {
        this.tree.showSize();
    }

    @Override
    public final int hashCode() {
        return (int)this.tree.getDocumentNumber();
    }

    public final boolean containsGraftedNodes() {
        return this.tree.externalNodes != null && !this.tree.externalNodes.isEmpty();
    }
}

