/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.z.IntHashMap;

public class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tinyTree, int n2) {
        this.tree = tinyTree;
        this.nodeNr = n2;
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    @Override
    public String getBaseURI() {
        TinyTree tinyTree = this.tree;
        synchronized (tinyTree) {
            String string;
            if (this.tree.knownBaseUris == null) {
                this.tree.knownBaseUris = new IntHashMap();
            }
            if ((string = this.tree.knownBaseUris.get(this.nodeNr)) == null) {
                TinyElementImpl tinyElementImpl = this;
                string = Navigator.getBaseURI(tinyElementImpl, nodeInfo -> this.tree.isTopWithinEntity(((TinyElementImpl)nodeInfo).getNodeNumber()));
                this.tree.knownBaseUris.put(this.nodeNr, string);
            }
            return string;
        }
    }

    @Override
    public SchemaType getSchemaType() {
        return this.tree.getSchemaType(this.nodeNr);
    }

    @Override
    public AtomicSequence atomize() {
        return this.tree.getTypedValueOfElement(this);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, namespaceBindingArray);
    }

    public static NamespaceBinding[] getDeclaredNamespaces(TinyTree tinyTree, int n2, NamespaceBinding[] namespaceBindingArray) {
        int n3 = tinyTree.beta[n2];
        if (n3 > 0) {
            int n4 = 0;
            while (n3 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n3] == n2) {
                ++n4;
                ++n3;
            }
            if (n4 == 0) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            if (namespaceBindingArray != null && n4 <= namespaceBindingArray.length) {
                System.arraycopy(tinyTree.namespaceBinding, tinyTree.beta[n2], namespaceBindingArray, 0, n4);
                if (n4 < namespaceBindingArray.length) {
                    namespaceBindingArray[n4] = null;
                }
                return namespaceBindingArray;
            }
            namespaceBindingArray = new NamespaceBinding[n4];
            System.arraycopy(tinyTree.namespaceBinding, tinyTree.beta[n2], namespaceBindingArray, 0, n4);
            return namespaceBindingArray;
        }
        return NamespaceBinding.EMPTY_ARRAY;
    }

    public boolean hasUniformNamespaces() {
        block7: {
            block6: {
                int n2 = this.nodeNr;
                int n3 = this.tree.beta[n2];
                TinyNodeImpl tinyNodeImpl = this;
                while (n3 == -1) {
                    if ((tinyNodeImpl = tinyNodeImpl.getParent()) instanceof TinyDocumentImpl) {
                        return !this.tree.usesNamespaces;
                    }
                    n2 = tinyNodeImpl.nodeNr;
                    n3 = this.tree.beta[n2];
                }
                while (n3 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n3] == n2) {
                    ++n3;
                }
                if (n3 >= this.tree.numberOfNamespaces) break block6;
                TinyElementImpl tinyElementImpl = this;
                if (tinyElementImpl.isAncestorOrSelf(tinyElementImpl.tree.getNode(this.tree.namespaceParent[n3]))) break block7;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        int n2 = this.tree.alpha[this.nodeNr];
        if (n2 < 0) {
            return null;
        }
        NamePool namePool = this.getNamePool();
        while (n2 < this.tree.numberOfAttributes && this.tree.attParent[n2] == this.nodeNr) {
            int n3 = this.tree.attCode[n2];
            StructuredQName structuredQName = namePool.getUnprefixedQName(n3);
            if (structuredQName.getLocalPart().equals(string2) && structuredQName.hasURI(string)) {
                return this.tree.attValue[n2].toString();
            }
            ++n2;
        }
        return null;
    }

    public String getAttributeValue(int n2) {
        int n3 = this.tree.alpha[this.nodeNr];
        if (n3 < 0) {
            return null;
        }
        while (n3 < this.tree.numberOfAttributes && this.tree.attParent[n3] == this.nodeNr) {
            if (n2 == (this.tree.attCode[n3] & 0xFFFFF)) {
                return this.tree.attValue[n3].toString();
            }
            ++n3;
        }
        return null;
    }

    @Override
    public void copy(Receiver receiver, int n2, Location location) {
        boolean bl2 = CopyOptions.includes(n2, 4);
        int n3 = -1;
        int n4 = 0;
        short s2 = this.tree.depth[this.nodeNr];
        int n5 = 1;
        boolean bl3 = (n2 & 4) != 0 && (n2 & 3) == 0;
        Object object = this.tree.getConfiguration();
        object = ((Configuration)object).getNamePool();
        int n6 = this.nodeNr;
        CopyInformee copyInformee = (CopyInformee)receiver.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        SchemaType schemaType = Untyped.getInstance();
        SimpleType simpleType = BuiltInAtomicType.UNTYPED_ATOMIC;
        do {
            int n7 = this.tree.depth[n6];
            if (n4 != 0) {
                n3 = (short)(n3 + 1);
            }
            while (n3 > n7) {
                receiver.endElement();
                n3 = (short)(n3 - 1);
            }
            n3 = n7;
            n7 = this.tree.nodeKind[n6];
            switch (n7) {
                case 1: 
                case 17: {
                    CharSequence charSequence;
                    Location location2;
                    if (bl2) {
                        schemaType = this.tree.getSchemaType(n6);
                        if (bl3) {
                            try {
                                this.checkNotNamespaceSensitiveElement(schemaType, n6);
                            }
                            catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                                int n8 = receiver.getPipelineConfiguration().getHostLanguage();
                                copyNamespaceSensitiveException.setErrorCode(n8 == 50 ? "XTTE0950" : "XQTY0086");
                                throw copyNamespaceSensitiveException;
                            }
                        }
                    }
                    if (copyInformee != null && (location2 = (Location)copyInformee.notifyElementNode(this.tree.getNode(n6))) != null) {
                        location = location2;
                    }
                    int n9 = this.tree.nameCode[n6];
                    int n10 = n9 & 0xFFFFF;
                    Object object2 = this.tree.getPrefix(n6);
                    int n11 = n4 = n5 == 0 && (n2 & 3) != 0 ? 64 : 0;
                    if (location.getLineNumber() < this.tree.getLineNumber(n6)) {
                        charSequence = location.getSystemId() == null ? this.getSystemId() : location.getSystemId();
                        location = new ExplicitLocation((String)charSequence, this.tree.getLineNumber(n6), this.getColumnNumber());
                    }
                    receiver.startElement(new CodedName(n10, (String)object2, (NamePool)object), schemaType, location, n4);
                    if (n7 == 17) {
                        n4 = 0;
                        receiver.startContent();
                        charSequence = TinyTextImpl.getStringValue(this.tree, n6);
                        receiver.characters(charSequence, location, 1024);
                        receiver.endElement();
                        break;
                    }
                    n4 = 1;
                    if ((n2 & 3) != 0 && this.tree.usesNamespaces) {
                        if (object2.isEmpty()) {
                            charSequence = this.getNamePool().getURI(n10);
                            charSequence.isEmpty();
                        }
                        if (n5 != 0) {
                            if ((n2 & 1) != 0) {
                                NamespaceBinding namespaceBinding;
                                NamespaceBinding[] namespaceBindingArray;
                                object2 = namespaceBindingArray = ((TinyNodeImpl)this).getDeclaredNamespaces(null);
                                n7 = namespaceBindingArray.length;
                                for (n5 = 0; n5 < n7 && (namespaceBinding = object2[n5]) != null; ++n5) {
                                    receiver.namespace(namespaceBinding, 0);
                                }
                            } else if ((n2 & 2) != 0) {
                                NamespaceIterator.sendNamespaces(this, receiver);
                            }
                        } else {
                            n7 = this.tree.beta[n6];
                            if (n7 > 0) {
                                while (n7 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n7] == n6) {
                                    object2 = this.tree.namespaceBinding[n7];
                                    receiver.namespace((NamespaceBindingSet)object2, 0);
                                    ++n7;
                                }
                            }
                        }
                    }
                    n5 = 0;
                    int n12 = this.tree.alpha[n6];
                    if (n12 >= 0) {
                        while (n12 < this.tree.numberOfAttributes && this.tree.attParent[n12] == n6) {
                            n7 = this.tree.attCode[n12];
                            int n13 = n7 & 0xFFFFF;
                            if (bl2) {
                                simpleType = this.tree.c(n12);
                                if (bl3) {
                                    try {
                                        int n14 = n12;
                                        Object object3 = simpleType;
                                        Object object4 = this;
                                        if (object3.isNamespaceSensitive()) {
                                            if (object3.isAtomicType()) {
                                                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
                                            }
                                            object4 = ((TinyNodeImpl)object4).tree.getTypedValueOfAttribute(null, n14);
                                            object4 = object4.iterator();
                                            while (object4.hasNext()) {
                                                object3 = (AtomicValue)object4.next();
                                                if (!((AtomicValue)object3).getPrimitiveType().isNamespaceSensitive()) continue;
                                                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
                                            }
                                        }
                                    }
                                    catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                                        n5 = receiver.getPipelineConfiguration().getHostLanguage();
                                        copyNamespaceSensitiveException.setErrorCode(n5 == 50 ? "XTTE0950" : "XQTY0086");
                                        throw copyNamespaceSensitiveException;
                                    }
                                }
                            }
                            String string = this.tree.prefixPool.getPrefix(n7 >> 20);
                            receiver.attribute(new CodedName(n13, string, (NamePool)object), simpleType, this.tree.attValue[n12], location, 0x100000);
                            ++n12;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 33: {
                    n4 = 0;
                    ((TinyElementImpl)this.tree.externalNodes.get(this.tree.alpha[n6])).copy(receiver, n2, location);
                    break;
                }
                case 3: {
                    n4 = 0;
                    CharSequence charSequence = TinyTextImpl.getStringValue(this.tree, n6);
                    receiver.characters(charSequence, location, 1024);
                    break;
                }
                case 4: {
                    n4 = 0;
                    CharSequence charSequence = WhitespaceTextImpl.getStringValueCS(this.tree, n6);
                    receiver.characters(charSequence, location, 1024);
                    break;
                }
                case 8: {
                    n4 = 0;
                    int n15 = this.tree.alpha[n6];
                    int n16 = this.tree.beta[n6];
                    if (n16 > 0) {
                        int n17 = n15;
                        receiver.comment(this.tree.commentBuffer.subSequence(n17, n17 + n16), location, 0);
                        break;
                    }
                    receiver.comment("", ExplicitLocation.UNKNOWN_LOCATION, 0);
                    break;
                }
                case 7: {
                    n4 = 0;
                    TinyNodeImpl tinyNodeImpl = this.tree.getNode(n6);
                    receiver.processingInstruction(tinyNodeImpl.getLocalPart(), tinyNodeImpl.getStringValue(), location, 0);
                    break;
                }
                case 12: {
                    n4 = 0;
                }
            }
        } while (++n6 < this.tree.numberOfNodes && this.tree.depth[n6] > s2);
        if (n4 != 0) {
            n3 = (short)(n3 + 1);
        }
        while (n3 > s2) {
            receiver.endElement();
            n3 = (short)(n3 - 1);
        }
    }

    protected void checkNotNamespaceSensitiveElement(SchemaType iterator, int n2) {
        if (iterator instanceof SimpleType && ((SimpleType)((Object)iterator)).isNamespaceSensitive()) {
            if (iterator.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            iterator = this.tree.getTypedValueOfElement(n2);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                AtomicValue atomicValue = (AtomicValue)iterator.next();
                if (!atomicValue.getPrimitiveType().isNamespaceSensitive()) continue;
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
        }
    }

    public String getURIForPrefix(String string, boolean bl2) {
        Iterable<NodeInfo> iterable;
        if (!bl2 && (string == null || string.isEmpty())) {
            return "";
        }
        int n2 = this.tree.beta[this.nodeNr];
        if (n2 > 0) {
            while (n2 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n2] == this.nodeNr) {
                iterable = this.tree.namespaceBinding[n2];
                if (((NamespaceBinding)iterable).getPrefix().equals(string)) {
                    String string2 = ((NamespaceBinding)iterable).getURI();
                    if (string2.isEmpty()) {
                        if (string.isEmpty()) {
                            return "";
                        }
                        return null;
                    }
                    return string2;
                }
                ++n2;
            }
        }
        if ((iterable = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)iterable)).getURIForPrefix(string, bl2);
        }
        return null;
    }

    @Override
    public boolean isId() {
        return this.tree.isIdElement(this.nodeNr);
    }

    @Override
    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }
}

